/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventListenersContainer;
import java.io.IOException;
import java.util.ArrayList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;

@JsxClasses(value={@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR}), @JsxClass(isJSObject=false, value={SupportedBrowser.IE})})
public class EventTarget
extends HtmlUnitScriptable {
    private EventListenersContainer eventListenersContainer_;

    @JsxConstructor
    public EventTarget() {
    }

    @JsxFunction
    public void addEventListener(String type, Scriptable listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    public final EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeEventLocally(Event event) {
        EventListenersContainer eventListenersContainer = this.getEventListenersContainer();
        Window window = this.getWindow();
        Object[] args = new Object[]{event};
        Event previousEvent = window.getCurrentEvent();
        window.setCurrentEvent(event);
        try {
            event.setEventPhase((short)2);
            eventListenersContainer.executeAtTargetListeners(event, args);
        }
        finally {
            window.setCurrentEvent(previousEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult fireEvent(Event event) {
        Window window = this.getWindow();
        event.startFire();
        Event previousEvent = window.getCurrentEvent();
        window.setCurrentEvent(event);
        try {
            HtmlElement element;
            Object elc;
            DomNode ourNode = this.getDomNodeOrNull();
            DomNode ourParentNode = ourNode != null ? ourNode.getParentNode() : null;
            ArrayList<EventTarget> propagationPath = new ArrayList<EventTarget>();
            propagationPath.add(this);
            for (DomNode parent = ourParentNode; parent != null; parent = parent.getParentNode()) {
                propagationPath.add((EventTarget)parent.getScriptableObject());
            }
            if (!"load".equals(event.getType()) && propagationPath.get(propagationPath.size() - 1) instanceof Document) {
                propagationPath.add(window);
            }
            event.setEventPhase((short)1);
            for (int i = propagationPath.size() - 1; i >= 1; --i) {
                EventTarget jsNode = (EventTarget)propagationPath.get(i);
                elc = jsNode.eventListenersContainer_;
                if (elc == null) continue;
                ((EventListenersContainer)elc).executeCapturingListeners(event, new Object[]{event});
                if (!event.isPropagationStopped()) continue;
                ScriptResult scriptResult = new ScriptResult(null);
                return scriptResult;
            }
            event.setEventPhase((short)2);
            if (!propagationPath.isEmpty()) {
                EventTarget jsNode = (EventTarget)propagationPath.get(0);
                EventListenersContainer elc2 = jsNode.eventListenersContainer_;
                if (elc2 != null) {
                    elc2.executeAtTargetListeners(event, new Object[]{event});
                    if (event.isPropagationStopped()) {
                        elc = new ScriptResult(null);
                        return elc;
                    }
                }
            }
            if (event.isBubbles()) {
                event.setEventPhase((short)3);
                int size = propagationPath.size();
                for (int i = 1; i < size; ++i) {
                    EventTarget jsNode = (EventTarget)propagationPath.get(i);
                    EventListenersContainer elc3 = jsNode.eventListenersContainer_;
                    if (elc3 == null) continue;
                    elc3.executeBubblingListeners(event, new Object[]{event});
                    if (!event.isPropagationStopped()) continue;
                    ScriptResult scriptResult = new ScriptResult(null);
                    return scriptResult;
                }
            }
            HtmlLabel label = null;
            if (event.processLabelAfterBubbling()) {
                for (DomNode parent = ourParentNode; parent != null; parent = parent.getParentNode()) {
                    if (!(parent instanceof HtmlLabel)) continue;
                    label = (HtmlLabel)parent;
                    break;
                }
            }
            if (label != null && (element = label.getLabeledElement()) != null && element != this.getDomNodeOrNull()) {
                try {
                    element.click(event.isShiftKey(), event.isCtrlKey(), event.isAltKey(), false, true, true, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            event.endFire();
            window.setCurrentEvent(previousEvent);
        }
        return new ScriptResult(null);
    }

    public boolean hasEventHandlers(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return false;
        }
        return this.eventListenersContainer_.hasEventListeners(StringUtils.substring(eventName, 2));
    }

    public Function getEventHandler(String eventType) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandler(eventType);
    }

    @JsxFunction
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        DomElement element = (DomElement)this.getDomNodeOrNull();
        ScriptResult result = null;
        if (event.getType().equals("click")) {
            try {
                element.click(event, event.isShiftKey(), event.isCtrlKey(), event.isAltKey(), true);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError("Error calling click(): " + e.getMessage());
            }
        } else {
            result = this.fireEvent(event);
        }
        return !event.isAborted(result);
    }

    @JsxFunction
    public void removeEventListener(String type, Scriptable listener, boolean useCapture) {
        if (this.eventListenersContainer_ == null) {
            return;
        }
        this.eventListenersContainer_.removeEventListener(type, listener, useCapture);
    }

    public void setEventHandler(String eventName, Object value) {
        if (this.isEventHandlerOnWindow()) {
            this.getWindow().getEventListenersContainer().setEventHandler(eventName, value);
            return;
        }
        this.getEventListenersContainer().setEventHandler(eventName, value);
    }

    protected boolean isEventHandlerOnWindow() {
        return false;
    }

    protected void clearEventListenersContainer() {
        this.eventListenersContainer_ = null;
    }
}

