/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMException;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.svg.SvgElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class XMLDocument
extends Document {
    private static final Log LOG = LogFactory.getLog(XMLDocument.class);

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public XMLDocument() {
        this(null);
    }

    public XMLDocument(WebWindow enclosingWindow) {
        if (enclosingWindow != null) {
            try {
                XmlPage page = new XmlPage((WebResponse)null, enclosingWindow);
                this.setDomNode(page);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError("IOException: " + e);
            }
        }
    }

    public boolean loadXML(String strXML) {
        WebWindow webWindow = this.getWindow().getWebWindow();
        try {
            if (StringUtils.isEmpty(strXML) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_EMPTY_STRING_IS_ERROR)) {
                throw new IOException("Error parsing XML '" + strXML + "'");
            }
            StringWebResponse webResponse = new StringWebResponse(strXML, webWindow.getEnclosedPage().getUrl());
            XmlPage page = new XmlPage(webResponse, webWindow, false);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error parsing XML\n" + strXML, e);
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_EXCEPTION_ON_ERROR)) {
                throw this.asJavaScriptException(new DOMException("Syntax Error", 12));
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_PARSERERROR_ON_ERROR)) {
                try {
                    XmlPage page = XMLDocument.createParserErrorXmlPage("Syntax Error", webWindow);
                    this.setDomNode(page);
                }
                catch (IOException eI) {
                    LOG.error("Could not handle ParserError", e);
                }
            }
            return false;
        }
    }

    private static XmlPage createParserErrorXmlPage(String message, WebWindow webWindow) throws IOException {
        String xml = "<parsererror xmlns=\"http://www.mozilla.org/newlayout/xml/parsererror.xml\">\n" + message + "\n<sourcetext></sourcetext>\n</parsererror>";
        StringWebResponse webResponse = new StringWebResponse(xml, webWindow.getEnclosedPage().getUrl());
        return new XmlPage(webResponse, webWindow, false);
    }

    @Override
    public HtmlUnitScriptable makeScriptableFor(DomNode domNode) {
        HtmlUnitScriptable scriptable;
        if (domNode instanceof DomElement && !(domNode instanceof HtmlElement)) {
            if (domNode instanceof SvgElement) {
                Class<? extends HtmlUnitScriptable> javaScriptClass = ((JavaScriptEngine)this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine()).getJavaScriptClass(domNode.getClass());
                try {
                    scriptable = javaScriptClass.newInstance();
                }
                catch (Exception e) {
                    throw Context.throwAsScriptRuntimeEx(e);
                }
            } else {
                scriptable = new Element();
            }
        } else if (domNode instanceof DomAttr) {
            scriptable = new Attr();
        } else {
            return super.makeScriptableFor(domNode);
        }
        scriptable.setPrototype(this.getPrototype(scriptable.getClass()));
        scriptable.setParentScope(this.getParentScope());
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    @Override
    protected void initParentScope(DomNode domNode, HtmlUnitScriptable scriptable) {
        scriptable.setParentScope(this.getParentScope());
    }

    @Override
    @JsxFunction
    public HTMLCollection getElementsByTagName(final String tagName) {
        DomNode firstChild = this.getDomNodeOrDie().getFirstChild();
        if (firstChild == null) {
            return HTMLCollection.emptyCollection(this.getWindow().getDomNodeOrDie());
        }
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                String nodeName = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_GET_ELEMENTS_BY_TAG_NAME_LOCAL) ? node.getLocalName() : node.getNodeName();
                return nodeName.equals(tagName);
            }
        };
    }
}

