/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.placeholder.GlobalPlaceholderEngine;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.placeholder.util.PlaceholderEngine;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.color.ConsoleColor;
import org.jetbrains.annotations.NotNull;

public final class Console {
    private static final Map<KarmaSource, Consumer<String>> messageActions = new ConcurrentHashMap<KarmaSource, Consumer<String>>();
    private static final Map<KarmaSource, Set<PlaceholderEngine>> engines = new ConcurrentHashMap<KarmaSource, Set<PlaceholderEngine>>();
    private final KarmaSource source;

    public Console(KarmaSource src) {
        this.source = src;
        GlobalPlaceholderEngine global = new GlobalPlaceholderEngine(src);
        Set stored = engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        stored.add(global);
        engines.put(this.source, stored);
    }

    public Console(KarmaSource src, Consumer<String> onMessage) {
        this.source = src;
        if (onMessage != null) {
            boolean isNew = messageActions.getOrDefault(src, null) == null;
            messageActions.put(src, onMessage);
            if (isNew) {
                this.send("&b[ KarmaAPI &b]&7 Using custom console message sender");
            }
        } else {
            messageActions.remove(src);
        }
        GlobalPlaceholderEngine global = new GlobalPlaceholderEngine(src);
        Set stored = engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        stored.add(global);
        engines.put(this.source, stored);
    }

    public PrefixConsoleData getData() {
        return new PrefixConsoleData(this.source);
    }

    public void addEngine(PlaceholderEngine engine) {
        Set stored = engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        stored.add(engine);
        engines.put(this.source, stored);
    }

    public void removeEngine(PlaceholderEngine engine) {
        Set added = engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        added.remove(engine);
        engines.put(this.source, added);
    }

    public Set<PlaceholderEngine> getEngines() {
        return engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
    }

    public void send(CharSequence message) {
        Consumer messageAction = messageActions.getOrDefault(this.source, null);
        String msg = String.valueOf(message);
        Set added = engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        for (PlaceholderEngine engine : added) {
            msg = engine.parse(msg, new Object[0]);
        }
        if (messageAction == null) {
            System.out.println("\u001b[0m" + StringUtils.toAnyOsColor(msg + ConsoleColor.RESET.getCode()));
        } else {
            messageAction.accept(msg);
        }
    }

    public void send(CharSequence message, Object ... replaces) {
        Consumer messageAction = messageActions.getOrDefault(this.source, null);
        String tmpMessage = String.valueOf(message);
        for (int i = 0; i < replaces.length; ++i) {
            String placeholder = "{" + i + "}";
            String value = String.valueOf(replaces[i]);
            tmpMessage = tmpMessage.replace(placeholder, value);
        }
        Set added = engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        for (PlaceholderEngine engine : added) {
            tmpMessage = engine.parse(tmpMessage, new Object[0]);
        }
        if (messageAction == null) {
            System.out.println("\u001b[0m" + StringUtils.toAnyOsColor(tmpMessage + ConsoleColor.RESET.getCode()));
        } else {
            messageAction.accept(tmpMessage);
        }
    }

    public void send(@NotNull CharSequence message, @NotNull Level level) {
        Consumer messageAction = messageActions.getOrDefault(this.source, null);
        String tmpMessage = String.valueOf(message);
        String prefix = "&b[ &fALERT &b] &7NONE: &b";
        PrefixConsoleData data = this.getData();
        switch (level) {
            case OK: {
                prefix = data.getOkPrefix();
                break;
            }
            case INFO: {
                prefix = data.getInfoPrefix();
                break;
            }
            case WARNING: {
                prefix = data.getWarningPrefix();
                break;
            }
            case GRAVE: {
                prefix = data.getGravePrefix();
            }
        }
        tmpMessage = StringUtils.stripColor(tmpMessage);
        Set added = engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        for (PlaceholderEngine engine : added) {
            tmpMessage = engine.parse(tmpMessage, new Object[0]);
        }
        if (messageAction == null) {
            if (tmpMessage.contains("\n")) {
                for (String msg : tmpMessage.split("\n")) {
                    this.send(msg);
                }
            } else {
                this.send(prefix + tmpMessage);
            }
        } else {
            if (tmpMessage.contains("\n")) {
                tmpMessage = StringUtils.listToString(Arrays.asList(tmpMessage.split("\n")), false);
            }
            messageAction.accept(prefix + tmpMessage);
        }
    }

    public void send(@NotNull CharSequence message, @NotNull Level level, Object ... replaces) {
        Consumer messageAction = messageActions.getOrDefault(this.source, null);
        String tmpMessage = String.valueOf(message);
        String prefix = "&b[ &fALERT &b] &7NONE: &b";
        PrefixConsoleData data = this.getData();
        switch (level) {
            case OK: {
                prefix = data.getOkPrefix();
                break;
            }
            case INFO: {
                prefix = data.getInfoPrefix();
                break;
            }
            case WARNING: {
                prefix = data.getWarningPrefix();
                break;
            }
            case GRAVE: {
                prefix = data.getGravePrefix();
            }
        }
        for (int i = 0; i < replaces.length; ++i) {
            String placeholder = "{" + i + "}";
            String value = String.valueOf(replaces[i]);
            tmpMessage = tmpMessage.replace(placeholder, value);
        }
        tmpMessage = StringUtils.stripColor(tmpMessage);
        Set added = engines.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        for (PlaceholderEngine engine : added) {
            tmpMessage = engine.parse(tmpMessage, new Object[0]);
        }
        if (messageAction == null) {
            if (tmpMessage.contains("\n")) {
                for (String msg : tmpMessage.split("\n")) {
                    this.send(msg);
                }
            } else {
                this.send(prefix + tmpMessage);
            }
        } else {
            if (tmpMessage.contains("\n")) {
                tmpMessage = StringUtils.listToString(Arrays.asList(tmpMessage.split("\n")), false);
            }
            messageAction.accept(prefix + tmpMessage);
        }
    }
}

