/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karma;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KmFile {
    private final Path path;
    public static char SECTION_DIVIDER_CHARACTER = (char)46;

    public KmFile(String basePath) {
        this.path = Paths.get(basePath, new String[0]);
    }

    public KmFile(File file) {
        this.path = file.toPath();
    }

    public KmFile(Path file) {
        this.path = file;
    }

    public abstract void set(String var1, Object var2, String ... var3);

    public abstract void unset(String var1);

    public abstract boolean isSet(String var1);

    public abstract boolean isSet(String var1, Object var2);

    @Nullable
    public abstract Object get(String var1);

    @Nullable
    public abstract KmFile getSection(String var1);

    @Nullable
    public abstract String getString(String var1);

    public abstract boolean getBoolean(String var1);

    public abstract int getInteger(String var1);

    public abstract double getDouble(String var1);

    public abstract long getLong(String var1);

    public abstract float getFloat(String var1);

    public abstract byte getByte(String var1);

    public abstract byte[] getBytes(String var1);

    @NotNull
    public abstract Object get(String var1, Object var2);

    @NotNull
    public abstract KmFile getSection(String var1, KmFile var2);

    @NotNull
    public abstract String getString(String var1, String var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract int getInteger(String var1, int var2);

    public abstract double getDouble(String var1, double var2);

    public abstract long getLong(String var1, long var2);

    public abstract float getFloat(String var1, float var2);

    public abstract byte getByte(String var1, byte var2);

    public abstract byte[] getBytes(String var1, byte[] var2);

    public abstract Map<String, Object> getKeys();

    public abstract boolean create();

    public abstract boolean remove();

    public abstract boolean exists();

    public boolean check(KmFile check) {
        Map<String, Object> values = this.getKeys();
        boolean status = true;
        for (String key : values.keySet()) {
            if (!status) break;
            Object value = values.get(key);
            if (check.isSet(key, value)) {
                if (!(value instanceof KmFile)) continue;
                KmFile section = (KmFile)value;
                KmFile checkSection = check.getSection(key);
                if (checkSection != null) {
                    status = section.check(checkSection);
                    continue;
                }
                status = false;
                continue;
            }
            status = false;
        }
        return status;
    }

    public final Path getFile() {
        return this.path;
    }
}

