/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.TimeCondition;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.errors.TimerAlreadyStarted;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;

public abstract class SimpleScheduler {
    private static final Map<Integer, SimpleScheduler> id_instance = new ConcurrentHashMap<Integer, SimpleScheduler>();
    private static int global_id = 0;
    private final KarmaSource source;
    private final int id;

    public SimpleScheduler(KarmaSource owner) {
        this.source = owner;
        this.id = ++global_id;
        id_instance.put(this.id, this);
    }

    public static void cancelFor(KarmaSource owner) {
        for (int id : id_instance.keySet()) {
            SimpleScheduler scheduler = id_instance.getOrDefault(id, null);
            if (scheduler != null && scheduler.source == null) {
                KarmaAPI.source(true).console().send((CharSequence)"Cancelling timer with id {0} because its source is not valid", Level.GRAVE, id);
                scheduler.cancel();
                continue;
            }
            if (scheduler == null || !scheduler.source.isSource(owner)) continue;
            scheduler.cancel();
            id_instance.remove(id);
        }
    }

    public abstract void cancel();

    public abstract void pause();

    public abstract void start() throws TimerAlreadyStarted;

    public abstract void restart();

    public abstract SimpleScheduler updateAutoRestart(boolean var1);

    public abstract SimpleScheduler withPeriod(Number var1);

    public abstract SimpleScheduler multiThreading(boolean var1);

    public abstract SimpleScheduler exactSecondPeriodAction(int var1, Runnable var2);

    public abstract SimpleScheduler exactPeriodAction(long var1, Runnable var3);

    public abstract SimpleScheduler secondChangeAction(Consumer<Integer> var1);

    public abstract SimpleScheduler periodChangeAction(Consumer<Long> var1);

    public abstract SimpleScheduler cancelAction(Consumer<Long> var1);

    public abstract SimpleScheduler pauseAction(Consumer<Long> var1);

    public abstract SimpleScheduler startAction(Runnable var1);

    public abstract SimpleScheduler endAction(Runnable var1);

    public abstract SimpleScheduler restartAction(Runnable var1);

    public abstract SimpleScheduler conditionalAction(TimeCondition var1, int var2, Consumer<Integer> var3);

    public abstract SimpleScheduler conditionalPeriodAction(TimeCondition var1, long var2, Consumer<Long> var4);

    public abstract boolean isCancelled();

    public abstract boolean isRunning();

    public abstract boolean isPaused();

    public abstract boolean autoRestart();

    public abstract boolean isMultiThreading();

    public abstract long getOriginalTime();

    public abstract long getPeriod();

    public abstract long getMillis();

    public final long getTime(TimeUnit unit) {
        long time = this.getMillis();
        switch (unit) {
            case NANOSECONDS: {
                return TimeUnit.MILLISECONDS.toNanos(time);
            }
            case MICROSECONDS: {
                return TimeUnit.MILLISECONDS.toMicros(time);
            }
            case SECONDS: {
                return TimeUnit.MILLISECONDS.toSeconds(time);
            }
            case MINUTES: {
                return TimeUnit.MILLISECONDS.toMinutes(time);
            }
            case HOURS: {
                return TimeUnit.MILLISECONDS.toHours(time);
            }
            case DAYS: {
                return TimeUnit.MILLISECONDS.toDays(time);
            }
        }
        return time;
    }

    public final String format(TimeUnit unit, String name) {
        return this.getTime(unit) + " " + name;
    }

    public final String timeLeft(boolean millis) {
        long milliseconds = this.getMillis();
        long seconds = this.getTime(TimeUnit.SECONDS);
        long minutes = this.getTime(TimeUnit.MINUTES);
        long hours = this.getTime(TimeUnit.HOURS);
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours).append(" hour(s) ");
        }
        if (minutes > 0L) {
            if (minutes > 59L) {
                builder.append(Math.abs(hours - minutes)).append(" min(s) ");
            } else {
                builder.append(minutes).append(" min(s) ");
            }
        }
        if (seconds > 0L) {
            if (seconds > 59L) {
                builder.append(Math.abs(hours - minutes - seconds)).append(" sec(s) ");
            } else {
                builder.append(seconds).append(" sec(s) ");
            }
        }
        if (millis || builder.length() <= 0) {
            builder.append(milliseconds).append(" ms");
        }
        return builder.toString();
    }

    @Deprecated
    public void requestSync(Runnable action) {
        try {
            SwingUtilities.invokeAndWait(action);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Deprecated
    public void requestAsync(Runnable action) {
        SwingUtilities.invokeLater(action);
    }

    public final KarmaSource getSource() {
        return this.source;
    }

    public final int getId() {
        return this.id;
    }
}

