/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.timer.worker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.SourceSecondsTimer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.Scheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.SimpleScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.worker.SchedulerData;

public class AsyncScheduler<T extends KarmaSource>
extends Scheduler {
    private static final Map<KarmaSource, SchedulerData> tasks = new ConcurrentHashMap<KarmaSource, SchedulerData>();
    private final T instance;

    public AsyncScheduler(T source) {
        SchedulerData data;
        this.instance = source;
        SchedulerData tmpData = tasks.getOrDefault(source, null);
        if (tmpData == null) {
            tmpData = new SchedulerData();
            tasks.put((KarmaSource)source, tmpData);
        }
        if ((data = tmpData).getScheduler() == null) {
            SimpleScheduler scheduler = new SourceSecondsTimer((KarmaSource)source, 0, true).cancelUnloaded(false).multiThreading(true);
            scheduler.restartAction(() -> {
                int next = data.getCurrentId() + 1;
                Runnable runnable = data.getTask(next);
                if (runnable != null) {
                    if (data.onTaskStart() != null) {
                        data.onTaskStart().accept(next);
                    }
                    runnable.run();
                    data.updateId(next);
                    if (data.onTaskEnd() != null) {
                        data.onTaskEnd().accept(next);
                    }
                }
            }).start();
            data.updateScheduler(scheduler);
        }
    }

    @Override
    public final void onTaskStart(Consumer<Integer> taskId) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaSource)this.instance, data);
        }
        data.taskStart = taskId;
    }

    @Override
    public final void onTaskComplete(Consumer<Integer> taskId) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaSource)this.instance, data);
        }
        data.taskEnd = taskId;
    }

    @Override
    public final int queue(Runnable task) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaSource)this.instance, data);
        }
        return data.addTask(task);
    }

    @Override
    public final int currentTask() {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaSource)this.instance, data);
        }
        return data.getCurrentId();
    }

    public final boolean hasMoreTasks() {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaSource)this.instance, data);
        }
        return data.hasNext();
    }
}

