/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.loader.BruteLoader;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;

public abstract class BridgeLoader<T extends KarmaSource> {
    private static boolean running = false;
    private static boolean hooked = false;
    private static BruteLoader loader = null;

    public BridgeLoader(String connection, T instance) throws IllegalStateException {
        KarmaAPI.install();
        if (hooked && loader != null) {
            throw new IllegalStateException("Tried to setup a KarmaAPI bridge but a bridge is already built");
        }
        instance.console().send((CharSequence)"Initializing {0} <-> KarmaAPI bridge for KarmaAPI modules", Level.INFO, connection);
        loader = new BruteLoader((URLClassLoader)instance.getClass().getClassLoader());
        loader.add(KarmaAPI.source(true).getSourceFile());
        hooked = true;
        instance.console().send((CharSequence)"Created a bridge for {0} and KarmaAPI", Level.INFO, connection);
    }

    public abstract void start() throws Throwable;

    public abstract void stop() throws Throwable;

    protected final void connect(File target) {
        loader.add(target);
    }

    protected final void connect(Path target) {
        loader.add(target);
    }

    protected final void connect(URL target) {
        loader.add(target);
    }

    protected final void setRunning(boolean status) {
        running = status;
    }

    public static boolean isRunning() {
        return running;
    }
}

