/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtilities {
    public static void create(@NotNull Path file) {
        FileUtilities.create(file.toFile());
    }

    public static void createWithException(@NotNull Path file) throws IOException {
        FileUtilities.createWithException(file.toFile());
    }

    public static boolean createWithResults(@NotNull Path file) {
        return FileUtilities.createWithResults(file.toFile());
    }

    public static void destroy(@NotNull Path file) {
        FileUtilities.destroy(file.toFile());
    }

    public static void destroyWithException(@NotNull Path file) throws IOException {
        FileUtilities.destroyWithException(file.toFile());
    }

    public static boolean destroyWithResults(@NotNull Path file) {
        return FileUtilities.destroyWithResults(file.toFile());
    }

    public static boolean isKarmaPath(Path file) {
        return FileUtilities.isKarmaFile(file.toFile());
    }

    public static boolean isValidPath(Path path) {
        return FileUtilities.isValidFile(path.toFile());
    }

    public static boolean isCompressedFile(Path file) {
        return FileUtilities.isCompressedFile(file.toFile());
    }

    public static byte[] readPath(Path file) {
        return FileUtilities.readFile(file.toFile());
    }

    public static String getParentPath(@NotNull Path file) {
        return FileUtilities.getParentFile(file.toFile());
    }

    public static String getPath(Path file) {
        return FileUtilities.getFile(file.toFile());
    }

    public static String getPrettyParentPath(@NotNull Path file) {
        return FileUtilities.getPrettyParentFile(file.toFile());
    }

    public static String getPrettyFile(Path file) {
        return FileUtilities.getPrettyFile(file.toFile());
    }

    public static String getParentPath(@NotNull Path file, char barReplace) {
        return FileUtilities.getParentFile(file.toFile(), barReplace);
    }

    public static String getPath(@NotNull Path file, char barReplace) {
        return FileUtilities.getFile(file.toFile(), barReplace);
    }

    public static String getExtension(@NotNull Path file) {
        return FileUtilities.getExtension(file.toFile());
    }

    public static String getName(@NotNull Path file, boolean extension) {
        return FileUtilities.getName(file.toFile(), extension);
    }

    public static String getPathType(Path file) {
        return FileUtilities.getFileType(file.toFile());
    }

    public static String getPathCompleteType(Path file) {
        return FileUtilities.getFileCompleteType(file.toFile());
    }

    @Nullable
    public static String getPathCompression(Path file) {
        return FileUtilities.getFileCompression(file.toFile());
    }

    public static List<String> readAllLines(Path file) {
        return FileUtilities.readAllLines(file.toFile());
    }

    public static Path getSourcePath(KarmaSource source) {
        File file = new File(source.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        return FileUtilities.getFixedFile(file).toPath();
    }

    public static Path getFixedPath(@NotNull Path file) {
        return FileUtilities.getFixedFile(file.toFile()).toPath();
    }

    public static Path getProjectPath(String delimiter) {
        return FileUtilities.getProjectFolder(delimiter).toPath();
    }

    public static Path getProjectParent() {
        return FileUtilities.getProjectParent().toPath();
    }

    @Deprecated
    public static Path getProjectPath(KarmaSource source) {
        return source.getDataPath();
    }
}

