/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import ml.karmaconfigs.remote.messaging.google.gson.Gson;
import ml.karmaconfigs.remote.messaging.google.gson.GsonBuilder;
import ml.karmaconfigs.remote.messaging.google.gson.JsonElement;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

public final class HttpUtil {
    private final URI url;
    private static Object client = null;
    private static Object httpClient = null;

    HttpUtil(URL target) throws URISyntaxException {
        this.url = target.toURI();
        if (client == null) {
            client = new WebClient(BrowserVersion.BEST_SUPPORTED);
        }
        if (httpClient == null) {
            httpClient = HttpClientBuilder.create().disableRedirectHandling().build();
        }
    }

    public void push() {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet(this.url);
            httpclient.execute(httpget);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public String getResponse() {
        String response = "";
        try {
            HttpGet httpget = new HttpGet(this.url);
            CloseableHttpResponse httpresponse = ((CloseableHttpClient)httpClient).execute(httpget);
            Header[] contentType = httpresponse.getHeaders("Content-type");
            boolean json = false;
            for (Header header : contentType) {
                if (!header.getValue().equalsIgnoreCase("application/json")) continue;
                json = true;
                break;
            }
            Scanner sc = new Scanner(httpresponse.getEntity().getContent());
            StringBuilder sb = new StringBuilder();
            while (sc.hasNext()) {
                sb.append(sc.next());
            }
            response = sb.toString();
            if (json) {
                Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                JsonElement object = (JsonElement)gson.fromJson(response, JsonElement.class);
                response = gson.toJson(object);
            }
        }
        catch (HttpHostConnectException ex) {
            response = "403 - Connection refused";
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }

    @NotNull
    public String getWebResponse() {
        String response = "";
        try {
            ((WebClient)client).getCurrentWindow().setEnclosedPage((Page)((WebClient)client).getPage(this.url.toURL()));
            WebWindow window = ((WebClient)client).getCurrentWindow();
            Page windowPage = window.getEnclosedPage();
            WebResponse page = windowPage.getWebResponse();
            boolean json = page.getContentType().equals("application/json");
            response = page.getContentAsString();
            if (json) {
                Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                JsonElement object = (JsonElement)gson.fromJson(response, JsonElement.class);
                response = gson.toJson(object);
            }
        }
        catch (HttpHostConnectException ex) {
            response = "403 - Connection refused";
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }
}

