/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.karmaapi.common.Console;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.listener.ClientEvent;
import ml.karmaconfigs.remote.messaging.listener.RemoteListener;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerConnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerDisconnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerMessageEvent;
import ml.karmaconfigs.remote.messaging.platform.Client;
import ml.karmaconfigs.remote.messaging.remote.RemoteServer;
import ml.karmaconfigs.remote.messaging.util.WorkLevel;
import ml.karmaconfigs.remote.messaging.util.message.DataFixer;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataOutput;
import ml.karmaconfigs.remote.messaging.util.message.MessageInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.util.message.type.MergeType;
import ml.karmaconfigs.remote.messaging.worker.tcp.remote.TCPRemoteServer;

public final class TCPClient
extends Client {
    private final Set<byte[]> data_queue = Collections.newSetFromMap(new ConcurrentHashMap());
    private RemoteServer remote = null;
    private String client_name = "client_" + new Random().nextInt(Integer.MAX_VALUE);
    private String server = "127.0.0.1";
    private String key = "";
    private int sv_port = 49305;
    private int client = 49300;
    private boolean debug = false;
    private boolean operative = false;
    private boolean instant_close = false;
    private boolean award_connection = false;
    private boolean tryingConnect = true;
    private SocketChannel socket;
    private final Console console = new Console(this);

    public TCPClient() {
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Client (&4ERROR&3)]&b ");
    }

    public TCPClient(String server_host, int server_port) {
        this.server = server_host;
        this.sv_port = server_port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Client (&4ERROR&3)]&b ");
    }

    public TCPClient(int client_port, String server_host, int server_port) {
        this.client = client_port;
        this.server = server_host;
        this.sv_port = server_port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Client (&4ERROR&3)]&b ");
    }

    @Override
    public Client debug(boolean status) {
        this.debug = status;
        return this;
    }

    @Override
    public LateScheduler<Boolean> connect() {
        if (!this.operative) {
            AsyncLateScheduler<Boolean> result = new AsyncLateScheduler<Boolean>();
            Thread thread = new Thread(() -> {
                try {
                    ClientEvent event;
                    MessageDataInput input;
                    Object readBuffer;
                    ByteBuffer tmpBuffer;
                    int read;
                    if (this.debug) {
                        this.console.send((CharSequence)"Initializing the connection with the server", Level.INFO);
                    }
                    this.socket = SocketChannel.open().bind(new InetSocketAddress(this.client));
                    this.socket.configureBlocking(false);
                    this.socket.connect(new InetSocketAddress(this.server, this.sv_port));
                    while (!this.socket.finishConnect()) {
                        if (!this.tryingConnect) continue;
                        if (this.debug) {
                            this.console.send((CharSequence)"Trying to establish a connection with {0}/{1}", Level.INFO, this.server, this.sv_port);
                        }
                        this.tryingConnect = false;
                    }
                    this.award_connection = true;
                    this.tryingConnect = true;
                    if (this.debug) {
                        this.console.send((CharSequence)"The connection has been established but the client is still waiting for server confirmation, data can be started to be sent", Level.WARNING, this.server, this.sv_port);
                    }
                    while (this.award_connection) {
                        if (this.instant_close) {
                            this.close();
                            this.tryingConnect = false;
                            this.award_connection = false;
                            this.operative = false;
                        }
                        if (this.tryingConnect) {
                            MessageDataOutput output = new MessageDataOutput();
                            ((MessageOutput)output).write("MAC", this.getMAC());
                            ((MessageOutput)output).write("COMMAND_ENABLED", true);
                            ((MessageOutput)output).write("COMMAND", "connect");
                            ((MessageOutput)output).write("ARGUMENT", this.client_name);
                            if (!StringUtils.isNullOrEmpty(this.key)) {
                                ((MessageOutput)output).write("ACCESS_KEY", this.key);
                            }
                            byte[] compile = ((MessageOutput)output).compile();
                            ByteBuffer tmp = ByteBuffer.wrap(compile);
                            this.socket.write(tmp);
                            this.tryingConnect = false;
                        }
                        if ((read = this.socket.read(tmpBuffer = ByteBuffer.allocate(5120))) == 0) continue;
                        readBuffer = DataFixer.fixBuffer(tmpBuffer);
                        if (this.operative || !((MessageInput)(input = new MessageDataInput(((ByteBuffer)readBuffer).array()))).getBoolean("COMMAND_ENABLED")) continue;
                        String sequence = input.getString("COMMAND");
                        String mac = input.getString("MAC");
                        if (sequence == null || mac == null) continue;
                        if (sequence.equalsIgnoreCase("accept")) {
                            this.remote = new TCPRemoteServer(mac, InetAddress.getByName(this.server), this.sv_port, this.socket);
                            if (this.debug) {
                                this.console.send((CharSequence)"Connection has been validated by the server", Level.OK);
                            }
                            for (byte[] data : this.data_queue) {
                                ByteBuffer tmp = ByteBuffer.wrap(data);
                                this.socket.write(tmp);
                                this.data_queue.remove(data);
                            }
                            this.award_connection = false;
                            this.operative = true;
                            event = new ServerConnectEvent(this.remote);
                            RemoteListener.callClientEvent(event);
                            continue;
                        }
                        String argument = input.getString("ARGUMENT");
                        if (argument == null || !argument.equalsIgnoreCase("connect")) continue;
                        this.instant_close = true;
                        result.complete(false);
                        String reason = input.getString("COMMAND_ARGUMENT");
                        if (reason == null) continue;
                        this.console.send((CharSequence)"Connection has been declined by the server ({0})", Level.GRAVE, reason);
                    }
                    result.complete(true);
                    block39: while (this.operative) {
                        tmpBuffer = ByteBuffer.allocate(4056);
                        read = this.socket.read(tmpBuffer);
                        if (read == 0) {
                            for (byte[] queue : this.data_queue) {
                                ByteBuffer tmp = ByteBuffer.wrap(queue);
                                this.socket.write(tmp);
                                this.data_queue.remove(queue);
                            }
                            continue;
                        }
                        readBuffer = DataFixer.fixBuffer(tmpBuffer);
                        input = new MessageDataInput(((ByteBuffer)readBuffer).array());
                        String mac = input.getString("MAC");
                        boolean isCommand = ((MessageInput)input).getBoolean("COMMAND_ENABLED");
                        if (!this.remote.getMAC().equals(mac)) continue;
                        if (isCommand) {
                            String command = input.getString("COMMAND");
                            String argument = input.getString("ARGUMENT");
                            if (command == null || argument == null) continue;
                            switch (command.toLowerCase()) {
                                case "success": {
                                    String data;
                                    switch (argument.toLowerCase()) {
                                        case "rename": {
                                            this.client_name = input.getString("ARGUMENT_DATA");
                                            if (this.client_name == null || !this.debug) continue block39;
                                            this.console.send((CharSequence)"Server accepted the new client name: {0}", Level.OK, this.client_name);
                                            break;
                                        }
                                        case "message": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null || !this.debug) continue block39;
                                            this.console.send((CharSequence)"{0} to server: {1}", Level.INFO, data, new String(((ByteBuffer)readBuffer).array()));
                                            break;
                                        }
                                        case "unknown": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null || !this.debug) continue block39;
                                            String[] arg_data = data.split(",");
                                            this.console.send((CharSequence)"{0} ran custom command: {1} ( {2} )", Level.WARNING, arg_data[0], arg_data[1], arg_data[2]);
                                            break;
                                        }
                                        default: {
                                            if (!this.debug) continue block39;
                                            this.console.send((CharSequence)"Unknown command from server: {0} ( {1} )", Level.GRAVE, command, argument);
                                            break;
                                        }
                                    }
                                    continue block39;
                                }
                                case "failed": {
                                    String data;
                                    switch (argument.toLowerCase()) {
                                        case "connect": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            String[] connect_data = data.split(",");
                                            String name = connect_data[0];
                                            String reason = connect_data[1];
                                            this.console.send((CharSequence)"Server declined connection as {0}, because: {1}", Level.GRAVE, name, reason);
                                            ServerDisconnectEvent connectEvent = new ServerDisconnectEvent(this.remote, reason);
                                            RemoteListener.callClientEvent(connectEvent);
                                            break;
                                        }
                                        case "rename": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            String[] rename_data = data.split(",");
                                            this.console.send((CharSequence)"Failed to change client name to {0}: {1}", Level.GRAVE, rename_data[0], rename_data[1]);
                                            break;
                                        }
                                        case "disconnect": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            this.console.send((CharSequence)"Failed while trying to disconnect the server ( you've been disconnected anyway ): {0}", Level.GRAVE, data);
                                            ServerDisconnectEvent disconnectEvent = new ServerDisconnectEvent(this.remote, "no server reason...");
                                            RemoteListener.callClientEvent(disconnectEvent);
                                            break;
                                        }
                                        case "message": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            this.console.send((CharSequence)"Failed while trying to send a message to server: {0}", Level.GRAVE, data);
                                            break;
                                        }
                                        case "unknown": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            String[] unknown_data = data.split(",");
                                            this.console.send((CharSequence)"Failed while trying to execute custom command {0} with argument {1}: {2}", Level.GRAVE, unknown_data[0], unknown_data[1], unknown_data[2]);
                                            break;
                                        }
                                        default: {
                                            if (!this.debug) continue block39;
                                            this.console.send((CharSequence)"Unknown command from server: {0} ( {1} )", Level.WARNING, command, argument);
                                            break;
                                        }
                                    }
                                    continue block39;
                                }
                                case "disconnect": {
                                    String reason = input.getString("ARGUMENT_DATA");
                                    if (reason != null) {
                                        this.console.send((CharSequence)"Connection killed by server: {0}", Level.GRAVE, reason);
                                    }
                                    ServerDisconnectEvent event2 = new ServerDisconnectEvent(this.remote, reason);
                                    RemoteListener.callClientEvent(event2);
                                    this.close();
                                }
                            }
                            continue;
                        }
                        event = new ServerMessageEvent(this.remote, input);
                        RemoteListener.callClientEvent(event);
                    }
                }
                catch (Throwable ex) {
                    result.complete(false, ex);
                }
            });
            thread.start();
            return result;
        }
        return null;
    }

    @Override
    public LateScheduler<Boolean> connect(String accessKey) {
        if (!this.operative) {
            this.key = accessKey;
            return this.connect();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.client_name;
    }

    @Override
    public String getMAC() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] macArray = network.getHardwareAddress();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < macArray.length; ++i) {
                str.append(String.format("%02X%s", macArray[i], i < macArray.length - 1 ? ":" : ""));
            }
            return str.toString();
        }
        catch (Throwable ex) {
            System.out.println("Failed to locate MAC address...");
            System.exit(1);
            return null;
        }
    }

    @Override
    public RemoteServer getServer() {
        return this.remote;
    }

    @Override
    public WorkLevel getWorkLevel() {
        return WorkLevel.TCP;
    }

    @Override
    public boolean isConnecting() {
        return this.tryingConnect || this.award_connection;
    }

    @Override
    public boolean isConnected() {
        try {
            ByteBuffer tmp = ByteBuffer.allocate(1024);
            return this.socket != null && this.socket.read(tmp) != -1;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public void rename(String name) {
        if (this.award_connection || this.operative) {
            this.client_name = name;
            MessageDataOutput output = new MessageDataOutput();
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", true);
            ((MessageOutput)output).write("COMMAND", "rename");
            ((MessageOutput)output).write("ARGUMENT", this.client_name);
            try {
                if (this.debug) {
                    this.console.send((CharSequence)"Trying to inform the server about the name change request to {0}", Level.INFO, name);
                }
                byte[] compile = ((MessageOutput)output).compile();
                ByteBuffer tmp = ByteBuffer.wrap(compile);
                this.socket.write(tmp);
            }
            catch (Throwable ex) {
                this.data_queue.add(((MessageOutput)output).compile());
            }
        }
    }

    @Override
    public void send(byte[] data) {
        if (this.award_connection || this.operative) {
            MessageDataOutput output = new MessageDataOutput(data, MergeType.DIFFERENCE);
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", false);
            try {
                byte[] compile = ((MessageOutput)output).compile();
                ByteBuffer tmp = ByteBuffer.wrap(compile);
                this.socket.write(tmp);
            }
            catch (Throwable ex) {
                this.data_queue.add(((MessageOutput)output).compile());
            }
        }
    }

    @Override
    public void close() {
        if (this.operative) {
            try {
                MessageDataOutput output = new MessageDataOutput();
                ((MessageOutput)output).write("MAC", this.getMAC());
                ((MessageOutput)output).write("COMMAND_ENABLED", true);
                ((MessageOutput)output).write("COMMAND", "disconnect");
                ((MessageOutput)output).write("ARGUMENT", "Client disconnect request");
                this.data_queue.add(((MessageOutput)output).compile());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else {
            this.instant_close = true;
        }
    }

    @Override
    public String name() {
        return "TCP Client";
    }

    @Override
    public String version() {
        return "0";
    }

    @Override
    public String description() {
        return "TCP client to connect to a TCP server that has been created with RemoteMessaging API";
    }

    @Override
    public String[] authors() {
        return new String[]{"KarmaDev"};
    }

    @Override
    public String updateURL() {
        return null;
    }
}

