/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;

public class SourceCodeHandler
implements Component {
    private SourceCodeHandler() {
    }

    public static SourceCodeHandler create() {
        return new SourceCodeHandler();
    }

    public String extractClassName(String classCode) {
        return Optional.ofNullable(StaticComponentContainer.Strings.extractAllGroups(Pattern.compile("(package)\\s*([[a-zA-Z0-9\\s]*\\.?]*)"), classCode).get(2).get(0)).map(value -> value + ".").orElse("") + StaticComponentContainer.Strings.extractAllGroups(Pattern.compile("(?<=\\n|\\A)(?:public\\s*)?(class|interface|enum)\\s*([^\\n\\s<]*)"), classCode).get(2).get(0);
    }

    public Collection<String> extractImports(String classCode) {
        Collection imports = StaticComponentContainer.Strings.extractAllGroups(Pattern.compile("import\\s+(.*?)\\s*;"), classCode).get(1);
        HashSet<String> finalImports = new HashSet<String>();
        for (String className : imports) {
            if (className.startsWith("static")) {
                className = className.replaceAll("static\\s+", "");
                className = className.substring(0, className.lastIndexOf("."));
            }
            finalImports.add(className);
        }
        return finalImports;
    }

    public Collection<String> addLineCounter(Collection<String> sources) {
        return sources.stream().map(source -> this.addLineCounter((String)source)).collect(Collectors.toList());
    }

    public String addLineCounter(String source) {
        StringBuffer newSource = new StringBuffer();
        String[] lines = source.split("\n");
        int maxDigitCount = 0;
        int temp = lines.length;
        while (temp > 0) {
            temp /= 10;
            ++maxDigitCount;
        }
        for (int lineCounter = 1; lineCounter <= lines.length; ++lineCounter) {
            newSource.append(String.format(" %0" + maxDigitCount + "d", lineCounter) + " | \t" + lines[lineCounter - 1] + "\n");
        }
        return newSource.substring(0, newSource.length() - 1);
    }

    @Override
    public void close() {
    }
}

