/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.StringTokenizer;
import net.sourceforge.htmlunit.corejs.javascript.EcmaError;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.RhinoException;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptException
extends RuntimeException {
    private static final Log LOG = LogFactory.getLog(ScriptException.class);
    private final String scriptSourceCode_;
    private final HtmlPage page_;

    public ScriptException(HtmlPage page, Throwable throwable, String scriptSourceCode) {
        super(ScriptException.getMessageFrom(throwable), throwable);
        this.scriptSourceCode_ = scriptSourceCode;
        this.page_ = page;
    }

    private static String getMessageFrom(Throwable throwable) {
        if (throwable == null) {
            return "null";
        }
        return throwable.getMessage();
    }

    public ScriptException(HtmlPage page, Throwable throwable) {
        this(page, throwable, null);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        writer.write(this.createPrintableStackTrace());
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        stream.print(this.createPrintableStackTrace());
    }

    private String createPrintableStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("======= EXCEPTION START ========");
        if (this.getCause() != null) {
            if (this.getCause() instanceof EcmaError) {
                EcmaError ecmaError = (EcmaError)this.getCause();
                printWriter.print("EcmaError: ");
                printWriter.print("lineNumber=[");
                printWriter.print(ecmaError.lineNumber());
                printWriter.print("] column=[");
                printWriter.print(ecmaError.columnNumber());
                printWriter.print("] lineSource=[");
                printWriter.print(this.getFailingLine());
                printWriter.print("] name=[");
                printWriter.print(ecmaError.getName());
                printWriter.print("] sourceName=[");
                printWriter.print(ecmaError.sourceName());
                printWriter.print("] message=[");
                printWriter.print(ecmaError.getMessage());
                printWriter.print("]");
                printWriter.println();
            } else {
                printWriter.println("Exception class=[" + this.getCause().getClass().getName() + "]");
            }
        }
        super.printStackTrace(printWriter);
        if (this.getCause() instanceof JavaScriptException) {
            Object value = ((JavaScriptException)this.getCause()).getValue();
            printWriter.print("JavaScriptException value = ");
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace(printWriter);
            } else {
                printWriter.println(value);
            }
        } else if (this.getCause() instanceof WrappedException) {
            WrappedException wrappedException = (WrappedException)this.getCause();
            printWriter.print("WrappedException: ");
            wrappedException.printStackTrace(printWriter);
            Throwable innerException = wrappedException.getWrappedException();
            if (innerException == null) {
                printWriter.println("Inside wrapped exception: null");
            } else {
                printWriter.println("Inside wrapped exception:");
                innerException.printStackTrace(printWriter);
            }
        } else if (this.getCause() != null) {
            printWriter.println("Enclosed exception: ");
            this.getCause().printStackTrace(printWriter);
        }
        if (this.scriptSourceCode_ != null && !this.scriptSourceCode_.isEmpty()) {
            printWriter.println("== CALLING JAVASCRIPT ==");
            printWriter.println(this.scriptSourceCode_);
        }
        printWriter.println("======= EXCEPTION END ========");
        return stringWriter.toString();
    }

    public String getScriptSourceCode() {
        return this.scriptSourceCode_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getFailingLine() {
        int lineNumber = this.getFailingLineNumber();
        if (lineNumber == -1) return "<no source>";
        if (this.scriptSourceCode_ == null) {
            return "<no source>";
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(this.scriptSourceCode_));){
            for (int i = 0; i < lineNumber - 1; ++i) {
                reader.readLine();
            }
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            LOG.error("Reading scriptSourceCode failed.", e);
            return "";
        }
    }

    public int getFailingLineNumber() {
        if (this.getCause() instanceof RhinoException) {
            RhinoException cause = (RhinoException)this.getCause();
            return cause.lineNumber();
        }
        return -1;
    }

    public int getFailingColumnNumber() {
        if (this.getCause() instanceof RhinoException) {
            RhinoException cause = (RhinoException)this.getCause();
            return cause.columnNumber();
        }
        return -1;
    }

    public HtmlPage getPage() {
        return this.page_;
    }

    public void printScriptStackTrace(PrintWriter writer) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.getCause().printStackTrace(printWriter);
        writer.print(this.getCause().getMessage());
        StringTokenizer st = new StringTokenizer(stringWriter.toString(), "\r\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!line.contains("at script")) continue;
            writer.println();
            writer.print(line.replaceFirst("at script\\.?", "at "));
        }
    }
}

