/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsxClass(value={SupportedBrowser.IE})
public class XMLDOMNodeList
extends MSXMLScriptable
implements Function,
NodeList {
    private String description_;
    private final boolean attributeChangeSensitive_;
    private List<DomNode> cachedElements_;
    private boolean listenerRegistered_;
    private int currentIndex_;

    public XMLDOMNodeList() {
        this.attributeChangeSensitive_ = true;
    }

    XMLDOMNodeList(ScriptableObject parentScope, boolean attributeChangeSensitive, String description) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.description_ = description;
        this.attributeChangeSensitive_ = attributeChangeSensitive;
    }

    public XMLDOMNodeList(DomNode parentScope, boolean attributeChangeSensitive, String description) {
        this((ScriptableObject)parentScope.getScriptableObject(), attributeChangeSensitive, description);
        this.setDomNode(parentScope, false);
    }

    protected XMLDOMNodeList(DomNode parentScope, List<DomNode> initialElements) {
        this((ScriptableObject)parentScope.getScriptableObject(), true, null);
        this.cachedElements_ = new ArrayList<DomNode>(initialElements);
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return this.getElements().size();
    }

    @JsxFunction
    public final Object item(Object index) {
        return XMLDOMNodeList.nullIfNotFound(this.getIt(index));
    }

    @JsxFunction
    public Object nextNode() {
        List<DomNode> elements = this.getElements();
        Object nextNode = this.currentIndex_ >= 0 && this.currentIndex_ < elements.size() ? elements.get(this.currentIndex_).getScriptableObject() : null;
        ++this.currentIndex_;
        return nextNode;
    }

    @JsxFunction
    public void reset() {
        this.currentIndex_ = 0;
    }

    public static XMLDOMNodeList emptyCollection(MSXMLScriptable parentScope) {
        final List list = Collections.emptyList();
        return new XMLDOMNodeList(parentScope, true, null){

            @Override
            protected List<DomNode> getElements() {
                return list;
            }
        };
    }

    @Override
    public final Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError("Zero arguments; need an index or a key.");
        }
        return XMLDOMNodeList.nullIfNotFound(this.getIt(args[0]));
    }

    private Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    @Override
    public final Object get(int index, Scriptable start) {
        XMLDOMNodeList array = (XMLDOMNodeList)start;
        List<DomNode> elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableForElement(elements.get(index));
        }
        return NOT_FOUND;
    }

    protected List<DomNode> getElements() {
        List<DomNode> cachedElements = this.cachedElements_;
        if (cachedElements == null) {
            this.cachedElements_ = cachedElements = this.computeElements();
            if (!this.listenerRegistered_) {
                DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl(this);
                DomNode domNode = this.getDomNodeOrNull();
                if (domNode != null) {
                    domNode.addDomChangeListener(listener);
                    if (this.attributeChangeSensitive_ && domNode instanceof HtmlElement) {
                        ((HtmlElement)domNode).addHtmlAttributeChangeListener(listener);
                    }
                }
                this.listenerRegistered_ = true;
            }
        }
        return cachedElements;
    }

    protected List<DomNode> computeElements() {
        ArrayList<DomNode> response = new ArrayList<DomNode>();
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        for (DomNode node : this.getCandidates()) {
            if (!(node instanceof DomElement) || !this.isMatching(node)) continue;
            response.add(node);
        }
        return response;
    }

    protected Iterable<DomNode> getCandidates() {
        DomNode domNode = this.getDomNodeOrNull();
        return domNode.getDescendants();
    }

    protected boolean isMatching(DomNode node) {
        return false;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<DomNode> elements = this.getElements();
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        for (DomNode next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getId())) continue;
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            return new XMLDOMNodeList(this.getDomNodeOrDie(), matchingElements);
        }
        for (DomNode next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !name.equals(nodeName = ((DomElement)next).getAttributeDirect("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        return new XMLDOMNodeList(domNode, matchingElements);
    }

    private static Object nullIfNotFound(Object object) {
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    public String toString() {
        return this.description_ == null ? super.toString() : this.description_;
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof XMLDOMNodeList) {
            XMLDOMNodeList otherArray = (XMLDOMNodeList)other;
            DomNode domNode = this.getDomNodeOrNull();
            DomNode domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && this.getElements().equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return index >= 0;
    }

    @Override
    public boolean has(String name, Scriptable start) {
        if (this.isPrototype()) {
            return super.has(name, start);
        }
        try {
            return this.has(Integer.parseInt(name), start);
        }
        catch (NumberFormatException numberFormatException) {
            if ("length".equals(name)) {
                return true;
            }
            return this.getWithPreemption(name) != NOT_FOUND;
        }
    }

    @Override
    public Object[] getIds() {
        if (this.isPrototype()) {
            return super.getIds();
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<DomNode> elements = this.getElements();
        idList.add("length");
        this.addElementIds(idList, elements);
        return idList.toArray();
    }

    private boolean isPrototype() {
        return !(this.getPrototype() instanceof XMLDOMNodeList);
    }

    protected void addElementIds(List<String> idList, List<DomNode> elements) {
        int index = 0;
        for (DomNode next : elements) {
            HtmlElement element = (HtmlElement)next;
            String name = element.getAttributeDirect("name");
            if (DomElement.ATTRIBUTE_NOT_DEFINED == name) {
                String id = element.getId();
                if (DomElement.ATTRIBUTE_NOT_DEFINED == id) {
                    idList.add(Integer.toString(index));
                } else {
                    idList.add(id);
                }
            } else {
                idList.add(name);
            }
            ++index;
        }
    }

    protected EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
        return EffectOnCache.RESET;
    }

    @Override
    public Node item(int index) {
        return this.getElements().get(index);
    }

    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }

    private static final class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private final transient WeakReference<XMLDOMNodeList> nodeList_;

        DomHtmlAttributeChangeListenerImpl(XMLDOMNodeList nodeList) {
            this.nodeList_ = new WeakReference<XMLDOMNodeList>(nodeList);
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            XMLDOMNodeList nodes = (XMLDOMNodeList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            if (nodes.attributeChangeSensitive_) {
                this.handleChangeOnCache(nodes, event);
            }
        }

        private void handleChangeOnCache(HtmlAttributeChangeEvent event) {
            XMLDOMNodeList nodes = (XMLDOMNodeList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            this.handleChangeOnCache(nodes, event);
        }

        private void handleChangeOnCache(XMLDOMNodeList nodes, HtmlAttributeChangeEvent event) {
            EffectOnCache effectOnCache = nodes.getEffectOnCache(event);
            if (EffectOnCache.NONE == effectOnCache) {
                return;
            }
            if (EffectOnCache.RESET == effectOnCache) {
                this.clearCache();
            }
        }

        private void clearCache() {
            XMLDOMNodeList nodes = (XMLDOMNodeList)this.nodeList_.get();
            if (null != nodes) {
                nodes.cachedElements_ = null;
            }
        }
    }

    protected static enum EffectOnCache {
        NONE,
        RESET;

    }
}

