/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTemplate;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRectList;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.TextRange;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLScriptElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLStyleElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTemplateElement;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

@JsxClass(domClass=DomElement.class)
public class Element
extends Node {
    static final String POSITION_BEFORE_BEGIN = "beforebegin";
    static final String POSITION_AFTER_BEGIN = "afterbegin";
    static final String POSITION_BEFORE_END = "beforeend";
    static final String POSITION_AFTER_END = "afterend";
    private static final Pattern CLASS_NAMES_SPLIT_PATTERN = Pattern.compile("\\s");
    private static final Pattern PRINT_NODE_PATTERN = Pattern.compile("  ");
    private static final Pattern PRINT_NODE_QUOTE_PATTERN = Pattern.compile("\"");
    private NamedNodeMap attributes_;
    private Map<String, HTMLCollection> elementsByTagName_;
    private int scrollLeft_;
    private int scrollTop_;
    private CSSStyleDeclaration style_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element() {
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.setParentScope(this.getWindow().getDocument());
        this.style_ = new CSSStyleDeclaration(this);
        DomElement htmlElt = (DomElement)domNode;
        for (DomAttr attr : htmlElt.getAttributesMap().values()) {
            String eventName = attr.getName().toLowerCase(Locale.ROOT);
            if (!eventName.startsWith("on")) continue;
            this.createEventHandler(eventName.substring(2), attr.getValue());
        }
    }

    protected void createEventHandler(String eventName, String attrValue) {
        DomElement htmlElt = this.getDomNodeOrDie();
        EventHandler eventHandler = new EventHandler(htmlElt, eventName, attrValue);
        this.setEventHandler(eventName, eventHandler);
    }

    @JsxGetter
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    @JsxGetter
    public NamedNodeMap getAttributes() {
        if (this.attributes_ == null) {
            this.attributes_ = this.createAttributesObject();
        }
        return this.attributes_;
    }

    protected NamedNodeMap createAttributesObject() {
        return new NamedNodeMap(this.getDomNodeOrDie());
    }

    @JsxFunction
    public String getAttribute(String attributeName, Integer flags) {
        String value = this.getDomNodeOrDie().getAttribute(attributeName);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value) {
            value = null;
        }
        return value;
    }

    @JsxFunction
    public void setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    @JsxFunction
    public HTMLCollection getElementsByTagName(String tagName) {
        boolean caseSensitive;
        String searchTagName;
        DomNode dom;
        if (this.elementsByTagName_ == null) {
            this.elementsByTagName_ = new HashMap<String, HTMLCollection>();
        }
        if ((dom = this.getDomNodeOrNull()) == null) {
            searchTagName = tagName.toLowerCase(Locale.ROOT);
            caseSensitive = false;
        } else {
            SgmlPage page = dom.getPage();
            if (page != null && page.hasCaseSensitiveTagNames()) {
                searchTagName = tagName;
                caseSensitive = true;
            } else {
                searchTagName = tagName.toLowerCase(Locale.ROOT);
                caseSensitive = false;
            }
        }
        HTMLCollection collection = this.elementsByTagName_.get(searchTagName);
        if (collection != null) {
            return collection;
        }
        DomElement node = this.getDomNodeOrDie();
        collection = "*".equals(tagName) ? new HTMLCollection(node, false){

            @Override
            protected boolean isMatching(DomNode nodeToMatch) {
                return true;
            }
        } : new HTMLCollection(node, false){

            @Override
            protected boolean isMatching(DomNode nodeToMatch) {
                if (caseSensitive) {
                    return searchTagName.equals(nodeToMatch.getNodeName());
                }
                return searchTagName.equalsIgnoreCase(nodeToMatch.getNodeName());
            }
        };
        this.elementsByTagName_.put(tagName, collection);
        return collection;
    }

    @JsxFunction
    public Object getAttributeNode(String name) {
        Map<String, DomAttr> attributes = this.getDomNodeOrDie().getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object getElementsByTagNameNS(final Object namespaceURI, final String localName) {
        return new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return !(!"*".equals(namespaceURI) && !Objects.equals(namespaceURI, node.getNamespaceURI()) || !"*".equals(localName) && !Objects.equals(localName, node.getLocalName()));
            }
        };
    }

    @JsxFunction
    public boolean hasAttribute(String name) {
        return this.getDomNodeOrDie().hasAttribute(name);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public boolean hasAttributes() {
        return super.hasAttributes();
    }

    @Override
    public DomElement getDomNodeOrDie() {
        return (DomElement)super.getDomNodeOrDie();
    }

    @JsxFunction
    public void removeAttribute(String name) {
        this.getDomNodeOrDie().removeAttribute(name);
    }

    @JsxFunction
    public ClientRect getBoundingClientRect() {
        if (!this.getDomNodeOrDie().isAttachedToPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BOUNDINGCLIENTRECT_THROWS_IF_DISCONNECTED)) {
            throw Context.reportRuntimeError("Element is not attache to a page");
        }
        ClientRect textRectangle = new ClientRect(1, 1, 1, 1);
        textRectangle.setParentScope(this.getWindow());
        textRectangle.setPrototype(this.getPrototype(textRectangle.getClass()));
        return textRectangle;
    }

    @Override
    @JsxGetter
    public int getChildElementCount() {
        return this.getDomNodeOrDie().getChildElementCount();
    }

    @Override
    @JsxGetter
    public Element getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @Override
    @JsxGetter
    public Element getLastElementChild() {
        return super.getLastElementChild();
    }

    @JsxGetter
    public Element getNextElementSibling() {
        DomElement child = this.getDomNodeOrDie().getNextElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public Element getPreviousElementSibling() {
        DomElement child = this.getDomNodeOrDie().getPreviousElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @Override
    public Element getParentElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Element); parent = parent.getParent()) {
        }
        return (Element)parent;
    }

    public void setDefaults(ComputedCSSStyleDeclaration style) {
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DOMTokenList getClassList() {
        return new DOMTokenList(this, "class");
    }

    @JsxFunction
    public String getAttributeNS(String namespaceURI, String localName) {
        String value = this.getDomNodeOrDie().getAttributeNS(namespaceURI, localName);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_GET_ATTRIBUTE_RETURNS_EMPTY)) {
            return null;
        }
        return value;
    }

    @JsxFunction
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().hasAttributeNS(namespaceURI, localName);
    }

    @JsxFunction
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.getDomNodeOrDie().setAttributeNS(namespaceURI, qualifiedName, value);
    }

    @JsxFunction
    public void removeAttributeNS(String namespaceURI, String localName) {
        this.getDomNodeOrDie().removeAttributeNS(namespaceURI, localName);
    }

    @JsxFunction
    public Attr setAttributeNode(Attr newAtt) {
        String name = newAtt.getName();
        NamedNodeMap nodes = this.getAttributes();
        Attr replacedAtt = (Attr)nodes.getNamedItemWithoutSytheticClassAttr(name);
        if (replacedAtt != null) {
            replacedAtt.detachFromParent();
        }
        DomAttr newDomAttr = newAtt.getDomNodeOrDie();
        this.getDomNodeOrDie().setAttributeNode(newDomAttr);
        return replacedAtt;
    }

    @Override
    public Object get(String name, Scriptable start) {
        Document doc;
        Object response = super.get(name, start);
        if (response instanceof FunctionObject && ("querySelectorAll".equals(name) || "querySelector".equals(name)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && (doc = this.getWindow().getDocument()) instanceof HTMLDocument && doc.getDocumentMode() < 8) {
            return NOT_FOUND;
        }
        return response;
    }

    @JsxFunction
    public NodeList querySelectorAll(String selectors) {
        try {
            return NodeList.staticNodeList(this, this.getDomNodeOrDie().querySelectorAll(selectors));
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").");
        }
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").");
        }
    }

    @JsxGetter(propertyName="className", value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getClassName_js() {
        return this.getDomNodeOrDie().getAttributeDirect("class");
    }

    @JsxSetter(propertyName="className", value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setClassName_js(String className) {
        this.getDomNodeOrDie().setAttribute("class", className);
    }

    @JsxGetter
    public int getClientHeight() {
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedHeight(false, true);
    }

    @JsxGetter
    public int getClientWidth() {
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedWidth(false, true);
    }

    @JsxGetter
    public int getClientLeft() {
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getBorderLeftValue();
    }

    @JsxGetter
    public int getClientTop() {
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getBorderTopValue();
    }

    @JsxFunction
    public Object getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().getAttributeNodeNS(namespaceURI, localName).getScriptableObject();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLCollection getElementsByClassName(String className) {
        DomElement elt = this.getDomNodeOrDie();
        final String[] classNames = CLASS_NAMES_SPLIT_PATTERN.split(className, 0);
        return new HTMLCollection(elt, true){

            @Override
            protected boolean isMatching(DomNode node) {
                if (!(node instanceof HtmlElement)) {
                    return false;
                }
                String classAttribute = ((HtmlElement)node).getAttributeDirect("class");
                if (DomElement.ATTRIBUTE_NOT_DEFINED == classAttribute) {
                    return false;
                }
                classAttribute = " " + classAttribute + " ";
                for (String aClassName : classNames) {
                    if (classAttribute.contains(" " + aClassName + " ")) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @JsxFunction
    public ClientRectList getClientRects() {
        Window w = this.getWindow();
        ClientRectList rectList = new ClientRectList();
        rectList.setParentScope(w);
        rectList.setPrototype(this.getPrototype(rectList.getClass()));
        if (!this.isDisplayNone() && this.getDomNodeOrDie().isAttachedToPage()) {
            ClientRect rect = new ClientRect(0, 0, 1, 1);
            rect.setParentScope(w);
            rect.setPrototype(this.getPrototype(rect.getClass()));
            rectList.add(rect);
        }
        return rectList;
    }

    protected final boolean isDisplayNone() {
        for (Element element = this; element != null; element = element.getParentElement()) {
            CSS2Properties style = element.getWindow().getComputedStyle(element, null);
            String display = ((CSSStyleDeclaration)style).getDisplay();
            if (!HtmlElement.DisplayStyle.NONE.value().equals(display)) continue;
            return true;
        }
        return false;
    }

    protected TextRange createTextRange() {
        TextRange range = new TextRange(this);
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype(range.getClass()));
        return range;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object insertAdjacentElement(String where, Object insertedElement) {
        if (insertedElement instanceof Node) {
            DomNode childNode = ((Node)insertedElement).getDomNodeOrDie();
            Object[] values = this.getInsertAdjacentLocation(where);
            DomNode node = (DomNode)values[0];
            boolean append = (Boolean)values[1];
            if (append) {
                node.appendChild(childNode);
            } else {
                node.insertBefore(childNode);
            }
            return insertedElement;
        }
        throw Context.reportRuntimeError("Passed object is not an element: " + insertedElement);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void insertAdjacentText(String where, String text) {
        Object[] values = this.getInsertAdjacentLocation(where);
        DomNode node = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        DomText domText = new DomText(node.getPage(), text);
        if (append) {
            node.appendChild(domText);
        } else {
            node.insertBefore(domText);
        }
    }

    private Object[] getInsertAdjacentLocation(String where) {
        boolean append;
        DomNode node;
        DomElement currentNode = this.getDomNodeOrDie();
        if (POSITION_AFTER_BEGIN.equalsIgnoreCase(where)) {
            if (currentNode.getFirstChild() == null) {
                node = currentNode;
                append = true;
            } else {
                node = currentNode.getFirstChild();
                append = false;
            }
        } else if (POSITION_BEFORE_BEGIN.equalsIgnoreCase(where)) {
            node = currentNode;
            append = false;
        } else if (POSITION_BEFORE_END.equalsIgnoreCase(where)) {
            node = currentNode;
            append = true;
        } else if (POSITION_AFTER_END.equalsIgnoreCase(where)) {
            if (currentNode.getNextSibling() == null) {
                node = currentNode.getParentNode();
                append = true;
            } else {
                node = currentNode.getNextSibling();
                append = false;
            }
        } else {
            throw Context.reportRuntimeError("Illegal position value: \"" + where + "\"");
        }
        if (append) {
            return new Object[]{node, Boolean.TRUE};
        }
        return new Object[]{node, Boolean.FALSE};
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void insertAdjacentHTML(String position, String text) {
        Object[] values = this.getInsertAdjacentLocation(position);
        DomNode domNode = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        HTMLElement.ProxyDomNode proxyDomNode = new HTMLElement.ProxyDomNode(domNode.getPage(), domNode, append);
        Element.parseHtmlSnippet(proxyDomNode, text);
    }

    private static void parseHtmlSnippet(DomNode target, String source) {
        try {
            target.getPage().getWebClient().getPageCreator().getHtmlParser().parseFragment(target, source);
        }
        catch (IOException e) {
            LogFactory.getLog(HtmlElement.class).error("Unexpected exception occurred while parsing HTML snippet", e);
            throw Context.reportRuntimeError("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage());
        }
        catch (SAXException e) {
            LogFactory.getLog(HtmlElement.class).error("Unexpected exception occurred while parsing HTML snippet", e);
            throw Context.reportRuntimeError("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage());
        }
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}, functionName="getInnerHTML")
    public String innerHTML() {
        return this.getInnerHTML();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getInnerHTML() {
        try {
            DomNode domNode = this.getDomNodeOrDie();
            if (this instanceof HTMLTemplateElement) {
                domNode = ((HtmlTemplate)this.getDomNodeOrDie()).getContent();
            }
            return this.getInnerHTML(domNode);
        }
        catch (IllegalStateException e) {
            Context.throwAsScriptRuntimeEx(e);
            return "";
        }
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setInnerHTML(Object value) {
        DomElement domNode;
        try {
            domNode = this.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            Context.throwAsScriptRuntimeEx(e);
            return;
        }
        domNode.removeAllChildren();
        this.getDomNodeOrDie().getPage().clearComputedStylesUpToRoot(domNode);
        boolean addChildForNull = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_ADD_CHILD_FOR_NULL_VALUE);
        if (value == null && addChildForNull || value != null && !"".equals(value)) {
            String valueAsString = Context.toString(value);
            Element.parseHtmlSnippet(domNode, valueAsString);
        }
    }

    protected String getInnerHTML(DomNode domNode) {
        StringBuilder buf = new StringBuilder();
        String tagName = this.getTagName();
        boolean isPlain = "SCRIPT".equals(tagName);
        isPlain = isPlain || "STYLE".equals(tagName);
        this.printChildren(buf, domNode, !isPlain);
        return buf.toString();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getOuterHTML() {
        StringBuilder buf = new StringBuilder();
        this.printNode(buf, this.getDomNodeOrDie(), true);
        return buf.toString();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOuterHTML(Object value) {
        boolean append;
        DomNode target;
        DomElement domNode = this.getDomNodeOrDie();
        DomNode parent = domNode.getParentNode();
        if (null == parent) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OUTER_HTML_REMOVES_CHILDREN_FOR_DETACHED)) {
                domNode.removeAllChildren();
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OUTER_HTML_THROWS_FOR_DETACHED)) {
                throw Context.reportRuntimeError("outerHTML is readonly for detached nodes");
            }
            return;
        }
        if (value == null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OUTER_HTML_NULL_AS_STRING)) {
            domNode.remove();
            return;
        }
        String valueStr = Context.toString(value);
        if (valueStr.isEmpty()) {
            domNode.remove();
            return;
        }
        DomNode nextSibling = domNode.getNextSibling();
        domNode.remove();
        if (nextSibling != null) {
            target = nextSibling;
            append = false;
        } else {
            target = parent;
            append = true;
        }
        HTMLElement.ProxyDomNode proxyDomNode = new HTMLElement.ProxyDomNode(target.getPage(), target, append);
        Element.parseHtmlSnippet(proxyDomNode, valueStr);
    }

    protected final void printChildren(StringBuilder builder, DomNode node, boolean html) {
        if (node instanceof HtmlTemplate) {
            HtmlTemplate template = (HtmlTemplate)node;
            for (DomNode child : template.getContent().getChildren()) {
                this.printNode(builder, child, html);
            }
            return;
        }
        for (DomNode child : node.getChildren()) {
            this.printNode(builder, child, html);
        }
    }

    protected void printNode(StringBuilder builder, DomNode node, boolean html) {
        if (node instanceof DomComment) {
            if (html) {
                String s = PRINT_NODE_PATTERN.matcher(node.getNodeValue()).replaceAll(" ");
                builder.append("<!--").append(s).append("-->");
            }
        } else if (node instanceof DomCharacterData) {
            String s = node.getNodeValue();
            if (html) {
                s = StringUtils.escapeXmlChars(s);
            }
            builder.append(s);
        } else if (html) {
            DomElement element = (DomElement)node;
            Element scriptObject = (Element)node.getScriptableObject();
            String tag = element.getTagName();
            Element htmlElement = null;
            if (scriptObject instanceof HTMLElement) {
                htmlElement = scriptObject;
            }
            builder.append('<').append(tag);
            for (DomAttr attr : element.getAttributesMap().values()) {
                if (!attr.getSpecified()) continue;
                String name = attr.getName();
                String value = PRINT_NODE_QUOTE_PATTERN.matcher(attr.getValue()).replaceAll("&quot;");
                builder.append(' ').append(name).append('=');
                builder.append('\"');
                builder.append(value);
                builder.append('\"');
            }
            builder.append('>');
            boolean isHtml = html && !(scriptObject instanceof HTMLScriptElement) && !(scriptObject instanceof HTMLStyleElement);
            this.printChildren(builder, node, isHtml);
            if (null == htmlElement || !htmlElement.isEndTagForbidden()) {
                builder.append("</").append(tag).append('>');
            }
        } else if (node instanceof HtmlElement) {
            HtmlElement element = (HtmlElement)node;
            if ("p".equals(element.getTagName())) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_LF)) {
                    builder.append('\n');
                } else {
                    int i;
                    for (i = builder.length() - 1; i >= 0 && Character.isWhitespace(builder.charAt(i)); --i) {
                    }
                    builder.setLength(i + 1);
                    builder.append('\n');
                }
            }
            if (!"script".equals(element.getTagName())) {
                this.printChildren(builder, node, html);
            }
        }
    }

    protected boolean isEndTagForbidden() {
        return false;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getId() {
        return this.getDomNodeOrDie().getId();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setId(String newId) {
        this.getDomNodeOrDie().setId(newId);
    }

    @JsxFunction
    public void removeAttributeNode(Attr attribute) {
        String name = attribute.getName();
        Object namespaceUri = attribute.getNamespaceURI();
        if (namespaceUri instanceof String) {
            this.removeAttributeNS((String)namespaceUri, name);
            return;
        }
        this.removeAttributeNS(null, name);
    }

    @JsxGetter
    public int getScrollTop() {
        CSS2Properties style;
        if (this.scrollTop_ < 0) {
            this.scrollTop_ = 0;
        } else if (this.scrollTop_ > 0 && !(style = this.getWindow().getComputedStyle(this, null)).isScrollable(false)) {
            this.scrollTop_ = 0;
        }
        return this.scrollTop_;
    }

    @JsxSetter
    public void setScrollTop(int scroll) {
        this.scrollTop_ = scroll;
    }

    @JsxGetter
    public int getScrollLeft() {
        CSS2Properties style;
        if (this.scrollLeft_ < 0) {
            this.scrollLeft_ = 0;
        } else if (this.scrollLeft_ > 0 && !(style = this.getWindow().getComputedStyle(this, null)).isScrollable(true)) {
            this.scrollLeft_ = 0;
        }
        return this.scrollLeft_;
    }

    @JsxSetter
    public void setScrollLeft(int scroll) {
        this.scrollLeft_ = scroll;
    }

    @JsxGetter
    public int getScrollHeight() {
        return this.getClientHeight();
    }

    @JsxGetter
    public int getScrollWidth() {
        return this.getClientWidth();
    }

    protected CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    protected void setStyle(String style) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_GET_ATTRIBUTE_RETURNS_EMPTY)) {
            this.getStyle().setCssText(style);
        }
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void scrollIntoView() {
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void scrollIntoViewIfNeeded() {
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getPrefix() {
        return super.getPrefix();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getLocalName() {
        return super.getLocalName();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getNamespaceURI() {
        return super.getNamespaceURI();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforecopy() {
        return this.getEventHandler("beforecopy");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforecopy(Object onbeforecopy) {
        this.setEventHandler("beforecopy", onbeforecopy);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforecut() {
        return this.getEventHandler("beforecut");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforecut(Object onbeforecut) {
        this.setEventHandler("beforecut", onbeforecut);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnbeforepaste() {
        return this.getEventHandler("beforepaste");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnbeforepaste(Object onbeforepaste) {
        this.setEventHandler("beforepaste", onbeforepaste);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnsearch() {
        return this.getEventHandler("search");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnsearch(Object onsearch) {
        this.setEventHandler("search", onsearch);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnwebkitfullscreenchange() {
        return this.getEventHandler("webkitfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitfullscreenchange(Object onwebkitfullscreenchange) {
        this.setEventHandler("webkitfullscreenchange", onwebkitfullscreenchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnwebkitfullscreenerror() {
        return this.getEventHandler("webkitfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitfullscreenerror(Object onwebkitfullscreenerror) {
        this.setEventHandler("webkitfullscreenerror", onwebkitfullscreenerror);
    }

    public Function getOnwheel() {
        return this.getEventHandler("wheel");
    }

    public void setOnwheel(Object onwheel) {
        this.setEventHandler("wheel", onwheel);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOngotpointercapture() {
        return this.getEventHandler("gotpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOngotpointercapture(Object ongotpointercapture) {
        this.setEventHandler("gotpointercapture", ongotpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnlostpointercapture() {
        return this.getEventHandler("lostpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnlostpointercapture(Object onlostpointercapture) {
        this.setEventHandler("lostpointercapture", onlostpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturechange() {
        return this.getEventHandler("msgesturechange");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturechange(Object onmsgesturechange) {
        this.setEventHandler("msgesturechange", onmsgesturechange);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturedoubletap() {
        return this.getEventHandler("msgesturedoubletap");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturedoubletap(Object onmsgesturedoubletap) {
        this.setEventHandler("msgesturedoubletap", onmsgesturedoubletap);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgestureend() {
        return this.getEventHandler("msgestureend");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgestureend(Object onmsgestureend) {
        this.setEventHandler("msgestureend", onmsgestureend);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturehold() {
        return this.getEventHandler("msgesturehold");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturehold(Object onmsgesturehold) {
        this.setEventHandler("msgesturehold", onmsgesturehold);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturestart() {
        return this.getEventHandler("msgesturestart");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturestart(Object onmsgesturestart) {
        this.setEventHandler("msgesturestart", onmsgesturestart);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturetap() {
        return this.getEventHandler("msgesturetap");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturetap(Object onmsgesturetap) {
        this.setEventHandler("msgesturetap", onmsgesturetap);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgotpointercapture() {
        return this.getEventHandler("msgotpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgotpointercapture(Object onmsgotpointercapture) {
        this.setEventHandler("msgotpointercapture", onmsgotpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsinertiastart() {
        return this.getEventHandler("msinertiastart");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsinertiastart(Object onmsinertiastart) {
        this.setEventHandler("msinertiastart", onmsinertiastart);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmslostpointercapture() {
        return this.getEventHandler("mslostpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmslostpointercapture(Object onmslostpointercapture) {
        this.setEventHandler("mslostpointercapture", onmslostpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointercancel() {
        return this.getEventHandler("mspointercancel");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointercancel(Object onmspointercancel) {
        this.setEventHandler("mspointercancel", onmspointercancel);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerdown() {
        return this.getEventHandler("mspointerdown");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerdown(Object onmspointerdown) {
        this.setEventHandler("mspointerdown", onmspointerdown);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerenter() {
        return this.getEventHandler("mspointerenter");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerenter(Object onmspointerenter) {
        this.setEventHandler("mspointerenter", onmspointerenter);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerleave() {
        return this.getEventHandler("mspointerleave");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerleave(Object onmspointerleave) {
        this.setEventHandler("mspointerleave", onmspointerleave);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointermove() {
        return this.getEventHandler("mspointermove");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointermove(Object onmspointermove) {
        this.setEventHandler("mspointermove", onmspointermove);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerout() {
        return this.getEventHandler("mspointerout");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerout(Object onmspointerout) {
        this.setEventHandler("mspointerout", onmspointerout);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerover() {
        return this.getEventHandler("mspointerover");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerover(Object onmspointerover) {
        this.setEventHandler("mspointerover", onmspointerover);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerup() {
        return this.getEventHandler("mspointerup");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerup(Object onmspointerup) {
        this.setEventHandler("mspointerup", onmspointerup);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnpointercancel() {
        return this.getEventHandler("pointercancel");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnpointercancel(Object onpointercancel) {
        this.setEventHandler("pointercancel", onpointercancel);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnpointerdown() {
        return this.getEventHandler("pointerdown");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnpointerdown(Object onpointerdown) {
        this.setEventHandler("pointerdown", onpointerdown);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnpointerenter() {
        return this.getEventHandler("pointerenter");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnpointerenter(Object onpointerenter) {
        this.setEventHandler("pointerenter", onpointerenter);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnpointerleave() {
        return this.getEventHandler("pointerleave");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnpointerleave(Object onpointerleave) {
        this.setEventHandler("pointerleave", onpointerleave);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnpointermove() {
        return this.getEventHandler("pointermove");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnpointermove(Object onpointermove) {
        this.setEventHandler("pointermove", onpointermove);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnpointerout() {
        return this.getEventHandler("pointerout");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnpointerout(Object onpointerout) {
        this.setEventHandler("pointerout", onpointerout);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnpointerover() {
        return this.getEventHandler("pointerover");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnpointerover(Object onpointerover) {
        this.setEventHandler("pointerover", onpointerover);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnpointerup() {
        return this.getEventHandler("pointerup");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnpointerup(Object onpointerup) {
        this.setEventHandler("pointerup", onpointerup);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void remove() {
        super.remove();
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setCapture(boolean retargetToElement) {
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public boolean releaseCapture() {
        return true;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static void before(Context context, Scriptable thisObj, Object[] args, Function function) {
        Node.before(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static void after(Context context, Scriptable thisObj, Object[] args, Function function) {
        Node.after(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static void replaceWith(Context context, Scriptable thisObj, Object[] args, Function function) {
        Node.replaceWith(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static boolean matches(Context context, Scriptable thisObj, Object[] args, Function function) {
        String selectorString = (String)args[0];
        if (!(thisObj instanceof Element)) {
            throw ScriptRuntime.typeError("Illegal invocation");
        }
        try {
            DomNode domNode = ((Element)thisObj).getDomNodeOrNull();
            return domNode != null && ((DomElement)domNode).matches(selectorString);
        }
        catch (CSSException e) {
            throw ScriptRuntime.constructError("SyntaxError", "An invalid or illegal selector was specified (selector: '" + selectorString + "' error: " + e.getMessage() + ").");
        }
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static boolean mozMatchesSelector(Context context, Scriptable thisObj, Object[] args, Function function) {
        return Element.matches(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static boolean webkitMatchesSelector(Context context, Scriptable thisObj, Object[] args, Function function) {
        return Element.matches(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public static boolean msMatchesSelector(Context context, Scriptable thisObj, Object[] args, Function function) {
        return Element.matches(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static Element closest(Context context, Scriptable thisObj, Object[] args, Function function) {
        String selectorString = (String)args[0];
        if (!(thisObj instanceof Element)) {
            throw ScriptRuntime.typeError("Illegal invocation");
        }
        try {
            DomNode domNode = ((Element)thisObj).getDomNodeOrNull();
            if (domNode == null) {
                return null;
            }
            DomElement elem = domNode.closest(selectorString);
            if (elem == null) {
                return null;
            }
            return (Element)elem.getScriptableObject();
        }
        catch (CSSException e) {
            throw ScriptRuntime.constructError("SyntaxError", "An invalid or illegal selector was specified (selector: '" + selectorString + "' error: " + e.getMessage() + ").");
        }
    }
}

