/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.Key;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class KarmaInputFile
implements Serializable {
    private final List<String> lines = new ArrayList<String>();

    public KarmaInputFile(InputStream stream) {
        InputStreamReader ir = new InputStreamReader(stream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(ir);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.lines.add(line);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private boolean isComment(String line) {
        if (line.startsWith("/*")) {
            return true;
        }
        return line.startsWith("/// ") || line.startsWith("// ") && line.endsWith(" -->");
    }

    private boolean isOpenList(String line, String path) {
        return line.equals("[LIST=" + path.replaceAll("\\s", "_") + "]");
    }

    private boolean isOpenList(String line) {
        return line.startsWith("[LIST=") && line.endsWith("]");
    }

    private boolean isCloseList(String line, String path) {
        return line.equals("[/LIST=" + path.replaceAll("\\s", "_") + "]");
    }

    private boolean isCloseList(String line) {
        return line.startsWith("[/LIST=") && line.endsWith("]");
    }

    private String getKeyPath(String line) {
        if (this.isOpenList(line) || this.isCloseList(line)) {
            String pathN1 = line.replaceFirst("\\[LIST=", "").replaceFirst("\\[/LIST=", "");
            return pathN1.substring(0, pathN1.length() - 1);
        }
        if (line.contains(":")) {
            return line.split(":")[0];
        }
        return line;
    }

    @NotNull
    public Object get(String path, @NotNull Object def) {
        Object val = def;
        path = path.replaceAll("\\s", "_");
        for (String line : this.lines) {
            String actualPath;
            if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
            val = line.replace(actualPath + ": ", "");
        }
        return val;
    }

    @NotNull
    public String getString(String path, @NotNull String def) {
        String val = def;
        path = path.replaceAll("\\s", "_");
        for (String line : this.lines) {
            String actualPath;
            if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
            val = line.replace(actualPath + ": ", "");
        }
        return val;
    }

    @NotNull
    public List<?> getList(String path, Object ... default_contents) {
        path = path.replaceAll("\\s", "_");
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.isSet(path)) {
            boolean adding = false;
            for (String line : this.lines) {
                if (this.isOpenList(line, path)) {
                    adding = true;
                }
                if (this.isCloseList(line, path)) {
                    adding = false;
                }
                if (!adding || this.isOpenList(line, path) || line.startsWith("/// ") || line.endsWith(" -->")) continue;
                values.add(line);
            }
            return values;
        }
        values.addAll(Arrays.asList(default_contents));
        return values;
    }

    @NotNull
    public List<String> getStringList(String path, String ... default_contents) {
        Object[] default_objects;
        ArrayList<String> values = new ArrayList<String>();
        List<?> originalList = this.getList(path = path.replaceAll("\\s", "_"), default_objects = Arrays.copyOf((Object[])default_contents, default_contents.length));
        if (!originalList.isEmpty()) {
            for (Object value : originalList) {
                String str = value.toString();
                if (str.startsWith("/// ") || str.endsWith(" -->")) continue;
                values.add(str);
            }
        }
        return values;
    }

    @NotNull
    public List<String> readFullFile() {
        return this.lines;
    }

    public boolean getBoolean(String path, boolean def) {
        boolean val = def;
        path = path.replaceAll("\\s", "_");
        for (String line : this.lines) {
            String actualPath;
            if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
            val = Boolean.parseBoolean(line.replace(actualPath + ": ", ""));
        }
        return val;
    }

    public boolean isList(String path) {
        path = path.replaceAll("\\s", "_");
        boolean exist = false;
        if (this.isSet(path)) {
            for (String line : this.lines) {
                if (!this.isOpenList(line, path)) continue;
                exist = true;
            }
        }
        return exist;
    }

    public boolean isSet(String path) {
        path = path.replaceAll("\\s", "_");
        boolean set = false;
        for (String line : this.lines) {
            String currentPath;
            if (line.split(":")[0] == null || !(currentPath = line.split(":")[0]).equals(path) && !this.isOpenList(line, path) && !this.isCloseList(line, path)) continue;
            set = true;
            break;
        }
        return set;
    }

    public int getInt(String path, int def) {
        int val = def;
        path = path.replaceAll("\\s", "_");
        for (String line : this.lines) {
            String actualPath;
            if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
            val = Integer.parseInt(line.replace(actualPath + ": ", ""));
        }
        return val;
    }

    public double getDouble(String path, double def) {
        double val = def;
        path = path.replaceAll("\\s", "_");
        for (String line : this.lines) {
            String actualPath;
            if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
            val = Double.parseDouble(line.replace(actualPath + ": ", ""));
        }
        return val;
    }

    public long getLong(String path, long def) {
        long val = def;
        path = path.replaceAll("\\s", "_");
        for (String line : this.lines) {
            String actualPath;
            if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
            val = Long.parseLong(line.replace(actualPath + ": ", ""));
        }
        return val;
    }

    public Set<Key> getKeys(boolean deep) {
        LinkedHashSet<Key> keys = new LinkedHashSet<Key>();
        for (String line : this.lines) {
            Key key;
            if (line.replaceAll("\\s", "").isEmpty() || this.isComment(line)) continue;
            String pathKey = this.getKeyPath(line);
            if (this.isList(pathKey)) {
                List<?> list = this.getList(pathKey, new Object[0]);
                if (list.isEmpty() && !deep) continue;
                key = new Key(pathKey, list);
            } else {
                Object value = this.get(pathKey, "");
                if (StringUtils.isNullOrEmpty(value) && !deep) continue;
                key = new Key(pathKey, value);
            }
            keys.add(key);
        }
        return keys;
    }

    public String toString() {
        StringBuilder val_builder = new StringBuilder();
        for (String line : this.lines) {
            val_builder.append(line);
        }
        String val = val_builder.toString();
        return val;
    }
}

