/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.serializer;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.PathUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.serializer.SerializedFile;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class FileSerializer
implements Serializable {
    private final transient Set<FileSerializer> subFiles = new HashSet<FileSerializer>();
    private final boolean directory;
    private final byte[] data;
    private final transient Path file;
    private String name;

    FileSerializer(File start, FileSerializer main) {
        this.file = start.toPath().resolve(main.name);
        this.directory = main.directory;
        this.name = main.name;
        this.data = main.data;
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            PathUtilities.create(this.file);
        }
    }

    FileSerializer(Path start, FileSerializer main) {
        this.file = start.resolve(main.name);
        this.directory = main.directory;
        this.name = main.name;
        this.data = main.data;
        if (!Files.isDirectory(this.file, new LinkOption[0])) {
            PathUtilities.create(this.file);
        }
    }

    public FileSerializer(File target) throws IllegalStateException {
        if (FileUtilities.isCompressedFile(target)) {
            throw new IllegalStateException("FileSerializer cannot serialize compressed files. Please provide a folder or a file ( " + FileUtilities.getFileCompression(target) + " )");
        }
        if (FileUtilities.isValidFile(target) && target.exists()) {
            this.file = target.toPath();
            this.directory = target.isDirectory();
            this.name = FileUtilities.getName(target, true);
            this.data = !this.directory ? FileUtilities.readFile(target) : new byte[0];
        } else {
            throw new IllegalStateException("Invalid or non existent file given. Cannot continue");
        }
    }

    public FileSerializer(Path target) throws IllegalStateException {
        if (PathUtilities.isCompressedFile(target)) {
            throw new IllegalStateException("FileSerializer cannot serialize compressed files. Please provide a folder or a file ( " + PathUtilities.getPathCompression(target) + " )");
        }
        if (PathUtilities.isValidPath(target) && Files.exists(target, new LinkOption[0])) {
            this.file = target;
            this.directory = Files.isDirectory(target, new LinkOption[0]);
            this.name = PathUtilities.getName(this.file, true);
            this.data = !this.directory ? PathUtilities.readPath(this.file) : new byte[0];
        } else {
            throw new IllegalStateException("Invalid or non existent file given. Cannot continue");
        }
    }

    public FileSerializer withPath(String relative) {
        this.name = relative + (relative.endsWith("/") ? this.name : "/" + this.name);
        return this;
    }

    public LateScheduler<Void> parse(@Nullable FileFilter filter) {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        KarmaSource tmp = KarmaAPI.source(false);
        tmp.async().queue(() -> {
            if (this.directory) {
                StringBuilder source = new StringBuilder(this.name);
                try {
                    Stream<Path> sub = Files.list(this.file);
                    Set paths = sub.collect(Collectors.toSet());
                    for (Path file : paths) {
                        if (!Files.isDirectory(file, new LinkOption[0])) {
                            boolean process = true;
                            if (filter != null) {
                                process = filter.accept(file.toFile());
                            }
                            if (!process) continue;
                            FileSerializer serializer = new FileSerializer(file).withPath(this.name);
                            this.subFiles.add(serializer);
                            continue;
                        }
                        source.append("/").append(PathUtilities.getName(file, true));
                        Set<FileSerializer> secondary = this.list(source.toString(), file, filter);
                        this.subFiles.addAll(secondary);
                        source = new StringBuilder(this.name);
                    }
                    result.complete(null, null);
                }
                catch (Throwable ex) {
                    result.complete(null, ex);
                }
            } else {
                result.complete(null, null);
            }
        });
        return result;
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder();
        if (!this.subFiles.isEmpty()) {
            this.subFiles.forEach(sub -> builder.append(StringUtils.serialize(sub)).append(";"));
        } else {
            builder.append(StringUtils.serialize(this));
        }
        String result = builder.toString();
        if (result.endsWith(";")) {
            result = StringUtils.replaceLast(result, ";", "");
        }
        return Base64.getEncoder().encodeToString(result.getBytes(StandardCharsets.UTF_8));
    }

    public SerializedFile getFile() {
        return new SerializedFile(this.directory, this.name, this.data);
    }

    public Set<SerializedFile> getFiles() {
        HashSet<SerializedFile> files = new HashSet<SerializedFile>();
        SerializedFile local = new SerializedFile(this.directory, this.name, this.data);
        files.add(local);
        this.subFiles.forEach(sub -> files.add(sub.getFile()));
        return files;
    }

    private Set<FileSerializer> list(String name, Path source, FileFilter filter) {
        HashSet<FileSerializer> serializers = new HashSet<FileSerializer>();
        try {
            Stream<Path> sub = Files.list(source);
            Set paths = sub.collect(Collectors.toSet());
            for (Path file : paths) {
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    boolean process = true;
                    if (filter != null) {
                        process = filter.accept(file.toFile());
                    }
                    if (!process) continue;
                    FileSerializer serializer = new FileSerializer(file).withPath(name);
                    serializers.add(serializer);
                    continue;
                }
                String tmpName = name + "/" + PathUtilities.getName(file, true);
                Set<FileSerializer> secondary = this.list(tmpName, file, filter);
                serializers.addAll(secondary);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return serializers;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[isDirectory:" + this.directory + ";relativePath:" + this.name + ";content:" + Integer.toHexString(this.data.length) + "]";
    }

    public static FileSerializer load(File startSource, String serialized) {
        FileUtilities.destroy(startSource);
        FileUtilities.create(startSource);
        String decoded = new String(Base64.getDecoder().decode(serialized.getBytes()), StandardCharsets.UTF_8);
        FileSerializer serializer = null;
        if (decoded.contains(";")) {
            FileSerializer tmp;
            String[] data = decoded.split(";");
            for (int i = 0; i < data.length && (tmp = (FileSerializer)StringUtils.loadUnsafe(data[i])) != null; ++i) {
                if (i == 0) {
                    serializer = new FileSerializer(startSource, tmp);
                    continue;
                }
                serializer.subFiles.add(tmp);
            }
        } else {
            FileSerializer tmp = (FileSerializer)StringUtils.loadUnsafe(decoded);
            if (tmp != null) {
                serializer = new FileSerializer(startSource, tmp);
            }
        }
        return serializer;
    }

    @Nullable
    public static FileSerializer load(Path startSource, String serialized) {
        PathUtilities.destroy(startSource);
        PathUtilities.create(startSource);
        String decoded = new String(Base64.getDecoder().decode(serialized.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        FileSerializer serializer = null;
        if (decoded.contains(";")) {
            FileSerializer tmp;
            String[] data = decoded.split(";");
            for (int i = 0; i < data.length && (tmp = (FileSerializer)StringUtils.loadUnsafe(data[i])) != null; ++i) {
                if (i == 0) {
                    serializer = new FileSerializer(startSource, tmp);
                    continue;
                }
                serializer.subFiles.add(tmp);
            }
        } else {
            FileSerializer tmp = (FileSerializer)StringUtils.loadUnsafe(decoded);
            if (tmp != null) {
                serializer = new FileSerializer(startSource, tmp);
            }
        }
        return serializer;
    }
}

