/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.version.spigot;

import java.net.URL;
import ml.karmaconfigs.remote.messaging.google.gson.Gson;
import ml.karmaconfigs.remote.messaging.google.gson.GsonBuilder;
import ml.karmaconfigs.remote.messaging.google.gson.JsonArray;
import ml.karmaconfigs.remote.messaging.google.gson.JsonElement;
import ml.karmaconfigs.remote.messaging.google.gson.JsonObject;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url.HttpUtil;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url.URLUtils;

public final class SpigotChecker {
    private final int resource_id;
    private static final String fetch_version = "https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id={0}";
    private static final String fetch_update = "https://api.spigotmc.org/simple/0.2/index.php?action=getResourceUpdates&id={0}&page={1}";
    private static final String update_url = "https://www.spigotmc.org/resources/{0}/update?update={1}";

    public SpigotChecker(int id) {
        this.resource_id = id;
    }

    public String getLatest() {
        try {
            Gson gson;
            JsonObject object;
            String response;
            URL url = new URL(StringUtils.formatString((CharSequence)fetch_version, this.resource_id));
            HttpUtil utils = URLUtils.extraUtils(url);
            if (utils != null && (response = utils.getResponse()) != null && (object = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("current_version")) {
                return object.get("current_version").getAsString();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public LateScheduler<URL> getUpdateURL() {
        AsyncLateScheduler<URL> result = new AsyncLateScheduler<URL>();
        KarmaAPI.source(false).async().queue(() -> {
            try {
                int page = 0;
                URL url = new URL(StringUtils.formatString((CharSequence)fetch_update, this.resource_id, page));
                HttpUtil utils = URLUtils.extraUtils(url);
                if (utils != null) {
                    String response = utils.getResponse();
                    while (!response.equalsIgnoreCase("[]") && (utils = URLUtils.extraUtils(url = new URL(StringUtils.formatString((CharSequence)fetch_update, this.resource_id, ++page)))) != null) {
                        response = utils.getResponse();
                    }
                    url = new URL(StringUtils.formatString((CharSequence)fetch_update, this.resource_id, --page));
                    utils = URLUtils.extraUtils(url);
                    if (utils != null) {
                        response = utils.getResponse();
                        if (!response.equals("403 - Connection refused")) {
                            Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                            JsonArray array = (JsonArray)gson.fromJson(response, JsonArray.class);
                            JsonElement last = array.get(array.size() - 1);
                            if (last.isJsonObject()) {
                                JsonObject object = last.getAsJsonObject();
                                if (object.has("id")) {
                                    int updateId = object.get("id").getAsInt();
                                    URL updateInfo = new URL(StringUtils.formatString((CharSequence)update_url, this.resource_id, updateId));
                                    result.complete(updateInfo, null);
                                } else {
                                    result.complete(null, new Exception("Failed to fetch last update id for project with id " + this.resource_id + " #001"));
                                }
                            } else {
                                result.complete(null, new Exception("Failed to fetch last update for project with id " + this.resource_id + " #002"));
                            }
                        } else {
                            result.complete(null, new Exception("Failed to fetch last update for project with id " + this.resource_id + " #003"));
                        }
                    } else {
                        result.complete(null, new Exception("Failed to fetch last update for project with id " + this.resource_id + " #004"));
                    }
                }
            }
            catch (Throwable ex) {
                result.complete(null, ex);
            }
        });
        return result;
    }
}

