/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class SystemProperties {
    Map<String, String> systemProperties = new ConcurrentHashMap<String, String>();

    private SystemProperties() {
        this.refresh();
    }

    public static final SystemProperties getInstance() {
        return Holder.getSystemPropertiesInstance();
    }

    public String get(String key) {
        return this.systemProperties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String key, String value) {
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties) {
            properties.setProperty(key, value);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.systemProperties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemProperties refresh() {
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties) {
            this.systemProperties.clear();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.systemProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this;
        }
    }

    public void forEach(BiConsumer<String, String> consumer) {
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    private static class Holder {
        private static final SystemProperties INSTANCE = new SystemProperties();

        private Holder() {
        }

        private static SystemProperties getSystemPropertiesInstance() {
            return INSTANCE;
        }
    }
}

