/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.io.FileSystemItem;

public class Resources {
    private static final Map.Entry<URL, InputStream> EMPTY_RESOURCE = new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null);

    public Collection<URL> getAll(String resourceRelativePath, ClassLoader resourceClassLoader, boolean onlyParents) {
        return StaticComponentContainer.Driver.getResources(resourceRelativePath, false, onlyParents ? StaticComponentContainer.ClassLoaders.getAllParents(resourceClassLoader) : StaticComponentContainer.ClassLoaders.getHierarchy(resourceClassLoader));
    }

    public Collection<URL> getAll(String resourceRelativePath, ClassLoader ... resourceClassLoaders) {
        return StaticComponentContainer.Driver.getResources(resourceRelativePath, false, resourceClassLoaders);
    }

    public URL get(String resourceRelativePath, ClassLoader resourceClassLoader, boolean onlyParents) {
        Collection<URL> resourceURLs = StaticComponentContainer.Driver.getResources(resourceRelativePath, true, onlyParents ? StaticComponentContainer.ClassLoaders.getAllParents(resourceClassLoader) : StaticComponentContainer.ClassLoaders.getHierarchy(resourceClassLoader));
        if (!resourceURLs.isEmpty()) {
            return resourceURLs.iterator().next();
        }
        return null;
    }

    public URL get(String resourceRelativePath, ClassLoader ... resourceClassLoaders) {
        Collection<URL> resourceURLs = StaticComponentContainer.Driver.getResources(resourceRelativePath, true, resourceClassLoaders);
        if (!resourceURLs.isEmpty()) {
            return resourceURLs.iterator().next();
        }
        return null;
    }

    public URL get(String resourceRelativePath, Collection<ClassLoader> resourceClassLoaders) {
        Collection<URL> resourceURLs = StaticComponentContainer.Driver.getResources(resourceRelativePath, true, resourceClassLoaders);
        if (!resourceURLs.isEmpty()) {
            return resourceURLs.iterator().next();
        }
        return null;
    }

    public Map<URL, InputStream> getAsInputStreams(String resourceRelativePath, ClassLoader resourceClassLoader, boolean onlyParents) {
        return this.getAsInputStreams(resourceRelativePath, () -> StaticComponentContainer.Driver.getResources(resourceRelativePath, false, onlyParents ? StaticComponentContainer.ClassLoaders.getAllParents(resourceClassLoader) : StaticComponentContainer.ClassLoaders.getHierarchy(resourceClassLoader)));
    }

    public Map<URL, InputStream> getAsInputStreams(String resourceRelativePath, ClassLoader ... resourceClassLoaders) {
        return this.getAsInputStreams(resourceRelativePath, () -> StaticComponentContainer.Driver.getResources(resourceRelativePath, false, resourceClassLoaders));
    }

    private Map<URL, InputStream> getAsInputStreams(String resourceRelativePath, Supplier<Collection<URL>> resourceSupplier) {
        LinkedHashMap<URL, InputStream> streams = new LinkedHashMap<URL, InputStream>();
        for (URL resourceURL : resourceSupplier.get()) {
            try {
                streams.put(resourceURL, resourceURL.openStream());
            }
            catch (Throwable exc) {
                try {
                    streams.put(resourceURL, FileSystemItem.of(resourceURL).toInputStream());
                }
                catch (Throwable exc2) {
                    return (Map)StaticComponentContainer.Driver.throwException(exc);
                }
            }
        }
        return streams;
    }

    public Map.Entry<URL, InputStream> getAsInputStream(String resourceRelativePath, ClassLoader resourceClassLoader, boolean onlyParents) {
        return this.getAsInputStream(resourceRelativePath, () -> StaticComponentContainer.Driver.getResources(resourceRelativePath, true, onlyParents ? StaticComponentContainer.ClassLoaders.getAllParents(resourceClassLoader) : StaticComponentContainer.ClassLoaders.getHierarchy(resourceClassLoader)));
    }

    public Map.Entry<URL, InputStream> getAsInputStream(String resourceRelativePath, ClassLoader ... resourceClassLoaders) {
        return this.getAsInputStream(resourceRelativePath, () -> StaticComponentContainer.Driver.getResources(resourceRelativePath, true, resourceClassLoaders));
    }

    private Map.Entry<URL, InputStream> getAsInputStream(String resourceRelativePath, Supplier<Collection<URL>> resourceSupplier) {
        Collection<URL> resourceURLs = resourceSupplier.get();
        if (!resourceURLs.isEmpty()) {
            URL resourceURL = resourceURLs.iterator().next();
            try {
                return new AbstractMap.SimpleImmutableEntry<URL, InputStream>(resourceURL, resourceURL.openStream());
            }
            catch (Throwable exc) {
                try {
                    return new AbstractMap.SimpleImmutableEntry<URL, InputStream>(resourceURL, FileSystemItem.of(resourceURL).toInputStream());
                }
                catch (Throwable exc2) {
                    return (Map.Entry)StaticComponentContainer.Driver.throwException(exc);
                }
            }
        }
        return EMPTY_RESOURCE;
    }

    public FileSystemItem get(Class<?> cls) {
        return FileSystemItem.of(this.get(StaticComponentContainer.Classes.toPath(cls), StaticComponentContainer.Classes.getClassLoader(cls)));
    }

    public FileSystemItem getClassPath(Class<?> cls) {
        String classRelativePath = StaticComponentContainer.Classes.toPath(cls);
        String classAbsolutePath = FileSystemItem.of(this.get(classRelativePath, StaticComponentContainer.Classes.getClassLoader(cls))).getAbsolutePath();
        return FileSystemItem.ofPath(classAbsolutePath.substring(0, classAbsolutePath.lastIndexOf(classRelativePath) - 1));
    }

    public StringBuffer getAsStringBuffer(String resourceRelativePath, ClassLoader resourceClassLoader, boolean onlyParents) throws IOException {
        try (InputStream inputSteram = this.getAsInputStream(resourceRelativePath, resourceClassLoader, onlyParents).getValue();){
            StringBuffer stringBuffer = this.getAsStringBuffer(inputSteram);
            return stringBuffer;
        }
    }

    public StringBuffer getAsStringBuffer(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String sCurrentLine;
            StringBuffer result = new StringBuffer();
            while ((sCurrentLine = reader.readLine()) != null) {
                result.append(sCurrentLine + "\n");
            }
            StringBuffer stringBuffer = result;
            return stringBuffer;
        }
    }

    @SafeVarargs
    public final Collection<FileSystemItem> getAsFileSystemItems(ClassLoader classLoader, String ... paths) {
        return this.getAsFileSystemItems(classLoader, Arrays.asList(paths));
    }

    @SafeVarargs
    public final Collection<FileSystemItem> getAsFileSystemItems(ClassLoader classLoader, Collection<String> ... pathCollections) {
        HashSet<FileSystemItem> paths = new HashSet<FileSystemItem>();
        for (Collection<String> pathCollection : pathCollections) {
            for (String path : pathCollection) {
                paths.addAll(this.getAll(path, classLoader, false).stream().map(url -> FileSystemItem.of(url)).collect(Collectors.toSet()));
            }
        }
        return paths;
    }
}

