/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DoTypeProcessor;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextSelectionDelegate;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HtmlEmailInput
extends HtmlInput
implements SelectableTextInput,
LabelableElement {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+\\/=?^_`\\{|\\}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$");
    private SelectableTextSelectionDelegate selectionDelegate_ = new SelectableTextSelectionDelegate(this);
    private DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(this);

    HtmlEmailInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        if (StringUtils.isBlank(newValue) && this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_EMAIL_TRIMMED)) {
            newValue = "";
        }
        super.setValueAttribute(newValue);
    }

    @Override
    public int getSelectionStart() {
        return this.selectionDelegate_.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        this.selectionDelegate_.setSelectionStart(selectionStart);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionDelegate_.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        this.selectionDelegate_.setSelectionEnd(selectionEnd);
    }

    @Override
    public String getSelectedText() {
        return this.selectionDelegate_.getSelectedText();
    }

    @Override
    public void select() {
        this.selectionDelegate_.select();
    }

    @Override
    public void setText(String text) {
        this.setValueAttribute(text);
    }

    @Override
    public String getText() {
        return this.getValueAttribute();
    }

    @Override
    protected void doType(char c, boolean lastType) {
        this.doTypeProcessor_.doType(this.getValueAttribute(), (SelectionDelegate)this.selectionDelegate_, c, (HtmlElement)this, lastType);
    }

    @Override
    protected void doType(int keyCode, boolean lastType) {
        this.doTypeProcessor_.doType(this.getValueAttribute(), (SelectionDelegate)this.selectionDelegate_, keyCode, (HtmlElement)this, lastType);
    }

    @Override
    protected void typeDone(String newValue, boolean notifyAttributeChangeListeners) {
        if (newValue.length() <= this.getMaxLength()) {
            this.setAttributeNS(null, "value", newValue, notifyAttributeChangeListeners, false);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelectionEnd(0);
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlEmailInput newnode = (HtmlEmailInput)super.cloneNode(deep);
        newnode.selectionDelegate_ = new SelectableTextSelectionDelegate(newnode);
        newnode.doTypeProcessor_ = new DoTypeProcessor(newnode);
        return newnode;
    }

    @Override
    public boolean isValid() {
        boolean isValid = super.isValid();
        if (!isValid) {
            return false;
        }
        String val = this.getValueAttribute();
        if (StringUtils.isNotBlank(val)) {
            return DEFAULT_PATTERN.matcher(val).matches();
        }
        return true;
    }

    @Override
    protected boolean isPatternSupported() {
        return true;
    }

    @Override
    protected boolean isBlankPatternValidated() {
        return false;
    }
}

