/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLLinkElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlLink
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlLink.class);
    public static final String TAG_NAME = "link";

    HtmlLink(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttributeDirect("charset");
    }

    public final String getHrefAttribute() {
        return this.getAttributeDirect("href");
    }

    public final String getHrefLangAttribute() {
        return this.getAttributeDirect("hreflang");
    }

    public final String getTypeAttribute() {
        return this.getAttributeDirect("type");
    }

    public final String getRelAttribute() {
        return this.getAttributeDirect("rel");
    }

    public final String getRevAttribute() {
        return this.getAttributeDirect("rev");
    }

    public final String getMediaAttribute() {
        return this.getAttributeDirect("media");
    }

    public final String getTargetAttribute() {
        return this.getAttributeDirect("target");
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        return this.getWebResponse(downloadIfNeeded, null);
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded, WebRequest request) throws IOException {
        WebClient webclient = this.getPage().getWebClient();
        if (null == request) {
            request = this.getWebRequest();
        }
        if (downloadIfNeeded) {
            try {
                WebResponse response = webclient.loadWebResponse(request);
                if (response.isSuccess()) {
                    this.executeEvent("load");
                } else {
                    this.executeEvent("error");
                }
                return response;
            }
            catch (IOException e) {
                this.executeEvent("error");
                throw e;
            }
        }
        return webclient.getCache().getCachedResponse(request);
    }

    public WebRequest getWebRequest() throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getPage();
        URL url = page.getFullyQualifiedUrl(this.getHrefAttribute());
        BrowserVersion browser = page.getWebClient().getBrowserVersion();
        WebRequest request = new WebRequest(url, browser.getCssAcceptHeader(), browser.getAcceptEncodingHeader());
        request.setCharset(page.getCharset());
        request.setRefererlHeader(page.getUrl());
        return request;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_DISPLAY_BLOCK2)) {
            return HtmlElement.DisplayStyle.NONE;
        }
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean mayBeDisplayed() {
        return false;
    }

    private void executeEvent(String type) {
        Object scriptable = this.getScriptableObject();
        HTMLLinkElement link = (HTMLLinkElement)scriptable;
        Event event = new Event(this, type);
        link.executeEventLocally(event);
    }

    @Override
    public void onAllChildrenAddedToPage(boolean postponed) {
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Link node added: " + this.asXml());
        }
        WebClient webClient = this.getPage().getWebClient();
        if (!this.isStyleSheetLink()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Link type '" + this.getRelAttribute() + "' not supported (" + this.asXml().replaceAll("[\\r\\n]", "") + ").");
            }
            return;
        }
        if (!webClient.getOptions().isCssEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stylesheet Link found but ignored because css support is disabled (" + this.asXml().replaceAll("[\\r\\n]", "") + ").");
            }
            return;
        }
        if (!webClient.isJavaScriptEngineEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stylesheet Link found but ignored because javascript engine is disabled (" + this.asXml().replaceAll("[\\r\\n]", "") + ").");
            }
            return;
        }
        PostponedAction action = new PostponedAction(this.getPage(), "Loading of link " + this){

            @Override
            public void execute() {
                HTMLLinkElement linkElem = (HTMLLinkElement)HtmlLink.this.getScriptableObject();
                linkElem.getSheet();
            }
        };
        AbstractJavaScriptEngine<?> engine = webClient.getJavaScriptEngine();
        if (postponed) {
            engine.addPostponedAction(action);
        } else {
            try {
                action.execute();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isStyleSheetLink() {
        String rel = this.getRelAttribute();
        if (rel != null) {
            rel = rel.trim().toLowerCase(Locale.ROOT);
        }
        return "stylesheet".equals(rel);
    }
}

