/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlMonthInput
extends HtmlInput
implements LabelableElement {
    private static final DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("yyyy-MM");

    HtmlMonthInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        try {
            if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED) && StringUtils.isNotEmpty(newValue)) {
                FORMATTER_.parse(newValue);
            }
            super.setValueAttribute(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED) && !this.getMin().isEmpty()) {
            try {
                YearMonth dateValue = YearMonth.parse(this.getValueAttribute(), FORMATTER_);
                YearMonth minDate = YearMonth.parse(this.getMin(), FORMATTER_);
                return minDate.equals(dateValue) || minDate.isBefore(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED) && !this.getMax().isEmpty()) {
            try {
                YearMonth dateValue = YearMonth.parse(this.getValueAttribute(), FORMATTER_);
                YearMonth maxDate = YearMonth.parse(this.getMax(), FORMATTER_);
                return maxDate.equals(dateValue) || maxDate.isAfter(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }
}

