/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.file.File;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLFormElement;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ES6Iterator;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class FormData
extends HtmlUnitScriptable {
    public static final String FORM_DATA_TAG = "FormData";
    private final List<NameValuePair> requestParameters_ = new ArrayList<NameValuePair>();

    public FormData() {
    }

    @JsxConstructor
    public FormData(Object formObj) {
        if (formObj instanceof HTMLFormElement) {
            HTMLFormElement form = (HTMLFormElement)formObj;
            this.requestParameters_.addAll(form.getHtmlForm().getParameterListForSubmit(null));
        }
    }

    @JsxFunction
    public void append(String name, Object value, Object filename) {
        if (value instanceof File) {
            String contentType;
            File file = (File)value;
            String fileName = null;
            if (filename instanceof String) {
                fileName = (String)filename;
            }
            if (StringUtils.isEmpty(contentType = file.getType())) {
                contentType = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_DATA_CONTENT_TYPE_PLAIN_IF_FILE_TYPE_UNKNOWN) ? "text/plain" : "application/octet-stream";
            }
            this.requestParameters_.add(new KeyDataPair(name, file.getFile(), fileName, contentType, (Charset)null));
        } else {
            this.requestParameters_.add(new NameValuePair(name, Context.toString(value)));
        }
    }

    @JsxFunction(functionName="delete", value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void delete_js(String name) {
        if (StringUtils.isEmpty(name)) {
            return;
        }
        this.requestParameters_.removeIf(pair -> name.equals(pair.getName()));
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String get(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            return pair.getValue();
        }
        return null;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Scriptable getAll(String name) {
        if (StringUtils.isEmpty(name)) {
            return Context.getCurrentContext().newArray((Scriptable)this, 0);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            values.add(pair.getValue());
        }
        Object[] stringValues = values.toArray(new Object[0]);
        return Context.getCurrentContext().newArray((Scriptable)this, stringValues);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public boolean has(String name) {
        if (StringUtils.isEmpty(name)) {
            return false;
        }
        for (NameValuePair pair : this.requestParameters_) {
            if (!name.equals(pair.getName())) continue;
            return true;
        }
        return false;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void set(String name, Object value, Object filename) {
        if (StringUtils.isEmpty(name)) {
            return;
        }
        int pos = -1;
        Iterator<NameValuePair> iter = this.requestParameters_.iterator();
        int idx = 0;
        while (iter.hasNext()) {
            NameValuePair pair = iter.next();
            if (name.equals(pair.getName())) {
                iter.remove();
                if (pos < 0) {
                    pos = idx;
                }
            }
            ++idx;
        }
        if (pos < 0) {
            pos = this.requestParameters_.size();
        }
        if (value instanceof File) {
            File file = (File)value;
            String fileName = null;
            if (filename instanceof String) {
                fileName = (String)filename;
            }
            this.requestParameters_.add(pos, new KeyDataPair(name, file.getFile(), fileName, file.getType(), (Charset)null));
        } else {
            this.requestParameters_.add(pos, new NameValuePair(name, Context.toString(value)));
        }
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Scriptable entries() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_DATA_ITERATOR_SIMPLE_NAME)) {
            return new FormDataIterator(this, "Iterator", this.requestParameters_);
        }
        return new FormDataIterator(this, "FormData Iterator", this.requestParameters_);
    }

    public void fillRequest(WebRequest webRequest) {
        webRequest.setEncodingType(FormEncodingType.MULTIPART);
        webRequest.setRequestParameters(this.requestParameters_);
    }

    public static final class FormDataIterator
    extends ES6Iterator {
        private final String className_;
        private final List<NameValuePair> nameValuePairList_;
        private int index_ = 0;

        public static void init(ScriptableObject scope, String className) {
            ES6Iterator.init(scope, false, new FormDataIterator(className), FormData.FORM_DATA_TAG);
        }

        public FormDataIterator(String className) {
            this.nameValuePairList_ = Collections.emptyList();
            this.className_ = className;
        }

        public FormDataIterator(Scriptable scope, String className, List<NameValuePair> nameValuePairList) {
            super(scope, FormData.FORM_DATA_TAG);
            this.nameValuePairList_ = nameValuePairList;
            this.className_ = className;
        }

        @Override
        public String getClassName() {
            return this.className_;
        }

        @Override
        protected boolean isDone(Context cx, Scriptable scope) {
            return this.index_ >= this.nameValuePairList_.size();
        }

        @Override
        protected Object nextValue(Context cx, Scriptable scope) {
            if (this.isDone(cx, scope)) {
                return Context.getUndefinedValue();
            }
            NameValuePair nextNameValuePair = this.nameValuePairList_.get(this.index_++);
            return cx.newArray(scope, new Object[]{nextNameValuePair.getName(), nextNameValuePair.getValue()});
        }
    }
}

