/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;

public final class ResourceDownloader {
    private static final Set<String> success = Collections.newSetFromMap(new ConcurrentHashMap());
    private final File destFile;
    private final String url;
    private boolean history = false;

    public ResourceDownloader(File destination, String _url) {
        this.destFile = destination;
        this.url = _url;
    }

    public static ResourceDownloader toCache(KarmaSource source, String fileName, String downloadURL, String ... sub) {
        File target;
        if (sub.length > 0) {
            Path dataPath = source.getDataPath();
            for (String dir : sub) {
                dataPath = dataPath.resolve(dir);
            }
            target = dataPath.resolve(fileName).toFile();
        } else {
            target = source.getDataPath().resolve("cache").resolve(fileName).toFile();
        }
        if (FileUtilities.isValidFile(target)) {
            return new ResourceDownloader(target, downloadURL);
        }
        throw new RuntimeException("Tried to download invalid resource file");
    }

    public ResourceDownloader history(boolean status) {
        this.history = status;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void download() {
        block21: {
            FileOutputStream output;
            InputStream stream;
            Channel rbc;
            block20: {
                rbc = null;
                stream = null;
                output = null;
                boolean process = true;
                if (this.history && success.contains(FileUtilities.getPrettyFile(this.destFile))) {
                    boolean bl = process = !this.destFile.exists();
                }
                if (!process) break block20;
                FileUtilities.create(this.destFile);
                URL download_url = new URL(this.url);
                stream = download_url.openStream();
                KarmaAPI.source(false).console().send((CharSequence)"Downloading file {0}", Level.INFO, this.destFile.getName());
                rbc = Channels.newChannel(stream);
                output = new FileOutputStream(this.destFile);
                output.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
                if (!this.history) break block20;
                success.add(FileUtilities.getPrettyFile(this.destFile));
            }
            try {
                if (rbc != null) {
                    rbc.close();
                }
                if (stream != null) {
                    stream.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (Throwable process) {
                // empty catch block
            }
            KarmaAPI.source(false).console().send((CharSequence)"Downloaded file {0}", Level.OK, this.destFile.getName());
            break block21;
            catch (Throwable ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        if (rbc != null) {
                            rbc.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    KarmaAPI.source(false).console().send((CharSequence)"Downloaded file {0}", Level.OK, this.destFile.getName());
                    throw throwable;
                }
                try {
                    if (rbc != null) {
                        rbc.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                KarmaAPI.source(false).console().send((CharSequence)"Downloaded file {0}", Level.OK, this.destFile.getName());
            }
        }
    }

    public File getDestFile() {
        return this.destFile;
    }

    public static void clearHistory() {
        success.clear();
    }

    public static void removeHistory(File file) {
        success.remove(FileUtilities.getPrettyFile(file));
    }
}

