/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.color;

import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;

public enum ConsoleColor {
    BLACK("0"),
    DARK_BLUE("1"),
    DARK_GREEN("2"),
    DARK_AQUA("3"),
    DARK_RED("4"),
    DARK_PURPLE("5"),
    DARK_YELLOW("6"),
    GRAY("7"),
    DARK_GRAY("8"),
    BLUE("9"),
    GREEN("a"),
    AQUA("b"),
    RED("c"),
    PURPLE("d"),
    YELLOW("e"),
    WHITE("f"),
    BOLD("l"),
    STRIKETHROUGH("m"),
    UNDERLINE("n"),
    ITALIC("o"),
    RESET("r"),
    CUSTOM("r");

    private String color_code;

    private ConsoleColor(String code) {
        this.color_code = code;
    }

    private ConsoleColor setCode(String code) {
        this.color_code = code;
        return this;
    }

    public final boolean isCustom() {
        for (ConsoleColor color : ConsoleColor.values()) {
            if (color == CUSTOM || !this.color_code.equals(color.color_code)) continue;
            return false;
        }
        return true;
    }

    public final String getCode() {
        return StringUtils.SINGLE_COLOR_IDENTIFIER + this.color_code;
    }

    public static ConsoleColor customColor(String code) {
        return CUSTOM.setCode(code);
    }

    public static ConsoleColor fromCode(String code) {
        for (ConsoleColor color : ConsoleColor.values()) {
            if (!color.getCode().equals(code)) continue;
            return color;
        }
        return ConsoleColor.customColor(code);
    }
}

