/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.burningwave.core.classes.AnnotationSourceGenerator;
import org.burningwave.core.classes.ClassSourceGenerator;
import org.burningwave.core.classes.FunctionSourceGenerator;
import org.burningwave.core.classes.GenericSourceGenerator;
import org.burningwave.core.classes.SourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.classes.VariableSourceGenerator;

public class BodySourceGenerator
extends SourceGenerator.Abst {
    private static final long serialVersionUID = 5923611245424078711L;
    private Collection<TypeDeclarationSourceGenerator> usedTypes;
    private String startingDelimiter;
    private String endingDelimiter;
    private String elementPrefix;
    private String elementSeparator;
    private Collection<SourceGenerator> bodyGenerators;

    BodySourceGenerator() {
    }

    public static BodySourceGenerator create() {
        return new BodySourceGenerator().setDelimiters("{\n", "\n}").setElementPrefix("\t");
    }

    public static BodySourceGenerator createSimple() {
        return new BodySourceGenerator().setDelimiters(null, null).setElementPrefix(null);
    }

    public BodySourceGenerator setBodyElementSeparator(String elementSeparator) {
        this.elementSeparator = elementSeparator;
        return this;
    }

    public BodySourceGenerator setElementPrefix(String elementPrefix) {
        this.elementPrefix = elementPrefix;
        return this;
    }

    public BodySourceGenerator setDelimiters(String startingDelimiter, String endingDelimiter) {
        this.startingDelimiter = startingDelimiter;
        this.endingDelimiter = endingDelimiter;
        return this;
    }

    public BodySourceGenerator setStartingDelimiter(String startingDelimiter) {
        this.startingDelimiter = startingDelimiter;
        return this;
    }

    public BodySourceGenerator setEndingDelimiter(String endingDelimiter) {
        this.endingDelimiter = endingDelimiter;
        return this;
    }

    public BodySourceGenerator addElement(SourceGenerator ... generators) {
        Optional.ofNullable(this.bodyGenerators).orElseGet(() -> {
            this.bodyGenerators = new ArrayList<SourceGenerator>();
            return this.bodyGenerators;
        });
        for (SourceGenerator generator : generators) {
            this.bodyGenerators.add(generator);
        }
        return this;
    }

    public BodySourceGenerator addCode(String ... elements) {
        Optional.ofNullable(this.bodyGenerators).orElseGet(() -> {
            this.bodyGenerators = new ArrayList<SourceGenerator>();
            return this.bodyGenerators;
        });
        for (final String element : elements) {
            this.bodyGenerators.add(new SourceGenerator(){
                private static final long serialVersionUID = 5843006583153055991L;

                @Override
                public String make() {
                    return element;
                }
            });
        }
        return this;
    }

    boolean isEmpty() {
        return this.bodyGenerators == null || this.bodyGenerators.isEmpty();
    }

    public BodySourceGenerator addCodeLine(String ... codes) {
        if (codes.length > 0) {
            for (String code : codes) {
                this.addCode((this.bodyGenerators != null && !this.bodyGenerators.isEmpty() ? "\n" : "") + code);
            }
        } else {
            this.addCode(this.bodyGenerators != null && !this.bodyGenerators.isEmpty() ? "\n" : "");
        }
        return this;
    }

    public BodySourceGenerator addAllElements(Collection<? extends SourceGenerator> generators) {
        Optional.ofNullable(this.bodyGenerators).orElseGet(() -> {
            this.bodyGenerators = new ArrayList<SourceGenerator>();
            return this.bodyGenerators;
        });
        generators.forEach(generator -> this.addElement((SourceGenerator)generator));
        return this;
    }

    Collection<TypeDeclarationSourceGenerator> getTypeDeclarations() {
        ArrayList<TypeDeclarationSourceGenerator> types = new ArrayList<TypeDeclarationSourceGenerator>();
        Optional.ofNullable(this.usedTypes).ifPresent(usedTypes -> types.addAll((Collection<TypeDeclarationSourceGenerator>)usedTypes));
        Optional.ofNullable(this.bodyGenerators).ifPresent(bodyGenerators -> {
            for (SourceGenerator generator : bodyGenerators) {
                if (generator instanceof AnnotationSourceGenerator) {
                    types.addAll(((AnnotationSourceGenerator)generator).getTypeDeclarations());
                }
                if (generator instanceof BodySourceGenerator) {
                    types.addAll(((BodySourceGenerator)generator).getTypeDeclarations());
                }
                if (generator instanceof ClassSourceGenerator) {
                    types.addAll(((ClassSourceGenerator)generator).getTypeDeclarations());
                }
                if (generator instanceof FunctionSourceGenerator) {
                    types.addAll(((FunctionSourceGenerator)generator).getTypeDeclarations());
                }
                if (generator instanceof GenericSourceGenerator) {
                    types.addAll(((GenericSourceGenerator)generator).getTypeDeclarations());
                }
                if (generator instanceof TypeDeclarationSourceGenerator) {
                    types.addAll(((TypeDeclarationSourceGenerator)generator).getTypeDeclarations());
                }
                if (!(generator instanceof VariableSourceGenerator)) continue;
                types.addAll(((VariableSourceGenerator)generator).getTypeDeclarations());
            }
        });
        return types;
    }

    public BodySourceGenerator useType(Class<?> ... classes) {
        Optional.ofNullable(this.usedTypes).orElseGet(() -> {
            this.usedTypes = new ArrayList<TypeDeclarationSourceGenerator>();
            return this.usedTypes;
        });
        for (Class<?> cls : classes) {
            this.usedTypes.add(TypeDeclarationSourceGenerator.create(cls));
        }
        return this;
    }

    String getStartingDelimiter() {
        return this.startingDelimiter;
    }

    String getEndingDelimiter() {
        return this.endingDelimiter;
    }

    String getBodyCode() {
        String elementPrefix = !this.isEmpty() ? this.elementPrefix : null;
        String bodyCode = Optional.ofNullable(elementPrefix).orElseGet(() -> "") + this.getOrEmpty(this.bodyGenerators, Optional.ofNullable(this.elementSeparator).orElse(" ")).replaceAll("\n(.)", "\n" + Optional.ofNullable(elementPrefix).orElseGet(() -> "") + "$1");
        return bodyCode;
    }

    public BodySourceGenerator useType(String ... classes) {
        Optional.ofNullable(this.usedTypes).orElseGet(() -> {
            this.usedTypes = new ArrayList<TypeDeclarationSourceGenerator>();
            return this.usedTypes;
        });
        for (String cls : classes) {
            this.usedTypes.add(TypeDeclarationSourceGenerator.create(cls, null));
        }
        return this;
    }

    public BodySourceGenerator useTypes(Collection<String> ... classCollections) {
        Optional.ofNullable(this.usedTypes).orElseGet(() -> {
            this.usedTypes = new ArrayList<TypeDeclarationSourceGenerator>();
            return this.usedTypes;
        });
        for (Collection<String> classes : classCollections) {
            for (String cls : classes) {
                this.usedTypes.add(TypeDeclarationSourceGenerator.create(cls, null));
            }
        }
        return this;
    }

    @Override
    public String make() {
        return this.getOrEmpty(this.startingDelimiter, this.getBodyCode(), this.endingDelimiter);
    }
}

