/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma.loader;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import ml.karmaconfigs.remote.messaging.karmaapi.common.JavaVM;
import ml.karmaconfigs.remote.messaging.karmaapi.common.ResourceDownloader;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.loader.component.NameComponent;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.PathUtilities;
import org.burningwave.core.assembler.StaticComponentContainer;

public final class BruteLoader {
    private static boolean open = false;
    private final ClassLoader loader;

    public BruteLoader(ClassLoader ucl) {
        ClassLoader tmp = ucl;
        if (!(tmp instanceof URLClassLoader)) {
            tmp = Thread.currentThread().getContextClassLoader();
        }
        if (!(tmp instanceof URLClassLoader)) {
            tmp = ucl;
        }
        this.loader = tmp;
        if (JavaVM.javaVersion() > 11 && !open) {
            open = true;
            StaticComponentContainer.Modules.exportAllToAll();
        }
    }

    public void downloadAndInject(URL downloadURL, NameComponent name) {
        name.addParentStart("dependencies");
        ResourceDownloader downloader = ResourceDownloader.toCache(KarmaAPI.source(true), name.getName() + "." + name.findExtension(), downloadURL.toString(), name.getParents()).history(true);
        downloader.download();
        this.add(downloader.getDestFile());
    }

    public boolean add(URL source) {
        try {
            Method method;
            if (this.loader instanceof URLClassLoader) {
                method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)this.loader, source);
            } else {
                method = ClassLoader.class.getDeclaredMethod("addClass", Class.class);
                Method define = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                Method load = ClassLoader.class.getMethod("loadClassData", String.class);
                method.setAccessible(true);
                define.setAccessible(true);
                load.setAccessible(true);
                JarFile jarFile = new JarFile(source.getFile());
                Enumeration<JarEntry> e = jarFile.entries();
                URL[] urls = new URL[]{new URL("jar:file:" + FileUtilities.getPrettyFile(new File(source.getFile())) + "!/")};
                URLClassLoader cl = URLClassLoader.newInstance(urls);
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                    String className = je.getName().substring(0, je.getName().length() - 6);
                    if ((className = className.replace('/', '.')).endsWith("module-info")) continue;
                    Class<?> clazz = cl.loadClass(className);
                    method.invoke((Object)this.loader, clazz);
                    byte[] data = (byte[])load.invoke((Object)this.loader, className);
                    define.invoke((Object)this.loader, className, data, 0, data.length);
                }
                load.setAccessible(false);
                define.setAccessible(false);
            }
            method.setAccessible(false);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean add(File source) {
        try {
            Method method;
            if (this.loader instanceof URLClassLoader) {
                method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)this.loader, source.toURI().toURL());
            } else {
                method = ClassLoader.class.getDeclaredMethod("addClass", Class.class);
                Method define = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                Method load = ClassLoader.class.getMethod("loadClassData", String.class);
                method.setAccessible(true);
                define.setAccessible(true);
                load.setAccessible(true);
                JarFile jarFile = new JarFile(source);
                Enumeration<JarEntry> e = jarFile.entries();
                URL[] urls = new URL[]{new URL("jar:file:" + FileUtilities.getPrettyFile(source) + "!/")};
                URLClassLoader cl = URLClassLoader.newInstance(urls);
                while (e.hasMoreElements()) {
                    String className;
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class") || (className = je.getName().substring(0, je.getName().length() - 6)).endsWith("module-info")) continue;
                    Class<?> clazz = cl.loadClass(className);
                    method.invoke((Object)this.loader, clazz);
                    byte[] data = (byte[])load.invoke((Object)this.loader, className);
                    define.invoke((Object)this.loader, className, data, 0, data.length);
                }
                load.setAccessible(false);
                define.setAccessible(false);
            }
            method.setAccessible(false);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean add(Path source) {
        try {
            Method method;
            if (this.loader instanceof URLClassLoader) {
                method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)this.loader, source.toUri().toURL());
            } else {
                method = ClassLoader.class.getDeclaredMethod("addClass", Class.class);
                Method define = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                Method load = ClassLoader.class.getMethod("loadClassData", String.class);
                method.setAccessible(true);
                define.setAccessible(true);
                load.setAccessible(true);
                JarFile jarFile = new JarFile(source.toFile());
                Enumeration<JarEntry> e = jarFile.entries();
                URL[] urls = new URL[]{new URL("jar:file:" + PathUtilities.getPrettyPath(source) + "!/")};
                URLClassLoader cl = URLClassLoader.newInstance(urls);
                while (e.hasMoreElements()) {
                    String className;
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class") || (className = je.getName().substring(0, je.getName().length() - 6)).endsWith("module-info")) continue;
                    Class<?> clazz = cl.loadClass(className);
                    method.invoke((Object)this.loader, clazz);
                    byte[] data = (byte[])load.invoke((Object)this.loader, className);
                    define.invoke((Object)this.loader, className, data, 0, data.length);
                }
                load.setAccessible(false);
                define.setAccessible(false);
            }
            method.setAccessible(false);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public ClassLoader getLoader() {
        return this.loader;
    }
}

