/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file;

import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.PathUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.validation.Checker;
import org.jetbrains.annotations.Nullable;

public class FileChecker
extends Checker {
    private Path file;
    private InputStream check = null;

    @Override
    public FileChecker withFile(Path target) {
        this.file = target;
        return this;
    }

    @Override
    public FileChecker withFile(File target) {
        this.file = target.toPath();
        return this;
    }

    @Override
    public FileChecker withCheck(InputStream target) {
        this.check = target;
        return this;
    }

    @Override
    public boolean verify() {
        if (this.check != null && this.file != null) {
            PathUtilities.create(this.file);
            try {
                byte[] host = new byte[this.check.available()];
                byte[] current = Files.readAllBytes(this.file);
                DataInputStream dataInputStream = new DataInputStream(this.check);
                dataInputStream.readFully(host);
                ByteBuffer hostBuffer = ByteBuffer.wrap(host);
                ByteBuffer currentBuffer = ByteBuffer.wrap(current);
                CRC32 check = new CRC32();
                check.update(hostBuffer);
                long hostCheck = check.getValue();
                check.update(currentBuffer);
                long currentCheck = check.getValue();
                return hostCheck != currentCheck;
            }
            catch (Throwable ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public String generateHash(String algorithm) {
        String result = null;
        if (this.file != null) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] hash = digest.digest(Files.readAllBytes(this.file));
                StringBuilder builder = new StringBuilder();
                for (byte aByte : hash) {
                    builder.append(String.format("%02x", aByte));
                }
                result = builder.toString();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String generateHashCheck(String algorithm) {
        String result = null;
        if (this.check != null) {
            try {
                byte[] host = new byte[this.check.available()];
                DataInputStream dataInputStream = new DataInputStream(this.check);
                dataInputStream.readFully(host);
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] hash = digest.digest(host);
                StringBuilder builder = new StringBuilder();
                for (byte aByte : hash) {
                    builder.append(String.format("%02x", aByte));
                }
                result = builder.toString();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }
}

