/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtilities {
    public static boolean DEBUG = true;
    private static boolean INTERNAL_CALL = false;

    public static void create(@NotNull File file) {
        block11: {
            if (!file.isDirectory()) {
                try {
                    if (!file.getParentFile().exists()) {
                        Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                        if (DEBUG && !INTERNAL_CALL) {
                            KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyParentFile(file));
                        }
                    }
                    if (file.exists()) break block11;
                    Files.createFile(file.toPath(), new FileAttribute[0]);
                    if (DEBUG && !INTERNAL_CALL) {
                        KarmaAPI.source(true).console().send((CharSequence)"Created file {0}", Level.INFO, FileUtilities.getPrettyFile(file));
                    }
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    if (!file.exists()) {
                        Files.createDirectories(file.toPath(), new FileAttribute[0]);
                        if (DEBUG && !INTERNAL_CALL) {
                            KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyFile(file));
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static void createWithException(@NotNull File file) throws IOException {
        if (!file.isDirectory()) {
            if (!file.getParentFile().exists()) {
                Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                if (DEBUG && !INTERNAL_CALL) {
                    KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyParentFile(file));
                }
            }
            if (!file.exists()) {
                Files.createFile(file.toPath(), new FileAttribute[0]);
                if (DEBUG && !INTERNAL_CALL) {
                    KarmaAPI.source(true).console().send((CharSequence)"Created file {0}", Level.INFO, FileUtilities.getPrettyFile(file));
                }
            }
        } else if (!file.exists()) {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
            if (DEBUG && !INTERNAL_CALL) {
                KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyFile(file));
            }
        }
    }

    public static boolean createWithResults(@NotNull File file) {
        if (!file.isDirectory()) {
            try {
                if (!file.getParentFile().exists()) {
                    Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                    if (DEBUG && !INTERNAL_CALL) {
                        KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyParentFile(file));
                    }
                }
                if (!file.exists()) {
                    Files.createFile(file.toPath(), new FileAttribute[0]);
                    if (DEBUG && !INTERNAL_CALL) {
                        KarmaAPI.source(true).console().send((CharSequence)"Created file {0}", Level.INFO, FileUtilities.getPrettyFile(file));
                    }
                    return true;
                }
            }
            catch (Throwable throwable) {}
        } else {
            try {
                if (!file.exists()) {
                    Files.createDirectories(file.toPath(), new FileAttribute[0]);
                    if (DEBUG && !INTERNAL_CALL) {
                        KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyFile(file));
                    }
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static void createDirectory(@NotNull File file) {
        try {
            if (!file.exists()) {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
                if (DEBUG && !INTERNAL_CALL) {
                    KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyFile(file));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void createDirectoryWithException(@NotNull File file) throws IOException {
        if (!file.exists()) {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
            if (DEBUG && !INTERNAL_CALL) {
                KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyFile(file));
            }
        }
    }

    public static boolean createDirectoryWithResults(@NotNull File file) {
        try {
            if (!file.exists()) {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
                if (DEBUG && !INTERNAL_CALL) {
                    KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyFile(file));
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void destroy(@NotNull File file) {
        try {
            if (file.exists()) {
                boolean dir = file.isDirectory();
                if (dir) {
                    Files.list(file.toPath()).forEach(sub -> FileUtilities.destroy(sub.toFile()));
                }
                Files.delete(file.toPath());
                if (DEBUG && !INTERNAL_CALL) {
                    KarmaAPI.source(true).console().send((CharSequence)"Deleted {0} {1}", Level.INFO, dir ? "directory" : "file", FileUtilities.getPrettyFile(file));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void destroyWithException(@NotNull File file) throws IOException {
        if (file.exists()) {
            boolean dir = file.isDirectory();
            if (dir) {
                Files.list(file.toPath()).forEach(sub -> FileUtilities.destroy(sub.toFile()));
            }
            Files.delete(file.toPath());
            if (DEBUG && !INTERNAL_CALL) {
                KarmaAPI.source(true).console().send((CharSequence)"Deleted {0} {1}", Level.INFO, dir ? "directory" : "file", FileUtilities.getPrettyFile(file));
            }
        }
    }

    public static boolean destroyWithResults(@NotNull File file) {
        try {
            if (file.exists()) {
                boolean dir = file.isDirectory();
                if (dir) {
                    Files.list(file.toPath()).forEach(sub -> FileUtilities.destroy(sub.toFile()));
                }
                Files.delete(file.toPath());
                if (DEBUG && !INTERNAL_CALL) {
                    KarmaAPI.source(true).console().send((CharSequence)"Removed {0} {1}", Level.INFO, dir ? "directory" : "file", FileUtilities.getPrettyFile(file));
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isKarmaFile(File file) {
        try {
            UserDefinedFileAttributeView view = Files.getFileAttributeView(file.toPath(), UserDefinedFileAttributeView.class, new LinkOption[0]);
            ByteBuffer buf = ByteBuffer.allocate(view.size("filetp"));
            view.read("filetp", buf);
            buf.flip();
            return Charset.defaultCharset().decode(buf).toString().equals("KarmaFile");
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isValidFile(File file) {
        try {
            if (file.exists()) {
                String filePath = file.getCanonicalPath();
                return !StringUtils.isNullOrEmpty(filePath);
            }
            INTERNAL_CALL = true;
            FileUtilities.create(file);
            boolean result = FileUtilities.isValidFile(file);
            FileUtilities.destroy(file);
            INTERNAL_CALL = false;
            return result;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isValidFile(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                String filePath = file.getCanonicalPath();
                return !StringUtils.isNullOrEmpty(filePath);
            }
            INTERNAL_CALL = true;
            FileUtilities.create(file);
            boolean result = FileUtilities.isValidFile(file);
            FileUtilities.destroy(file);
            INTERNAL_CALL = false;
            return result;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompressedFile(File file) {
        String name = FileUtilities.getName(file, true).toLowerCase();
        InputStream stream = null;
        InputStreamReader inReader = null;
        BufferedReader reader = null;
        try {
            stream = FileUtilities.class.getResourceAsStream("/compressions.txt");
            if (stream != null) {
                String format;
                inReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                reader = new BufferedReader(inReader);
                while ((format = reader.readLine()) != null) {
                    if (!name.endsWith(format.toLowerCase())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inReader != null) {
                    inReader.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    public static byte[] readFile(File file) {
        byte[] bytes = new byte[(int)file.length()];
        try (FileInputStream stream = new FileInputStream(file);
             DataInputStream dataInputStream = new DataInputStream(stream);){
            dataInputStream.readFully(bytes);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bytes;
    }

    public static String getParentFile(@NotNull File file) {
        return FileUtilities.getParentFile(file, ' ');
    }

    public static String getFile(File file) {
        return FileUtilities.getFile(file, ' ');
    }

    public static String getPrettyParentFile(@NotNull File file) {
        return FileUtilities.getParentFile(file, '/');
    }

    public static String getPrettyFile(File file) {
        return FileUtilities.getFile(file, '/');
    }

    public static String getParentFile(@NotNull File file, char barReplace) {
        if (Character.isSpaceChar(barReplace)) {
            return file.getParentFile().getAbsolutePath().replaceAll("%20", " ");
        }
        return file.getParentFile().getAbsolutePath().replaceAll("%20", " ").replace(File.separatorChar, barReplace);
    }

    public static String getFile(@NotNull File file, char barReplace) {
        if (Character.isSpaceChar(barReplace)) {
            return file.getAbsolutePath().replaceAll("%20", " ");
        }
        return file.getAbsolutePath().replaceAll("%20", " ").replace(File.separatorChar, barReplace);
    }

    public static String getExtension(@NotNull File file) {
        if (!file.isDirectory() && file.getName().contains(".")) {
            String name = file.getName();
            String[] nameData = name.split("\\.");
            return nameData[nameData.length - 1];
        }
        return "dir";
    }

    public static String getExtension(@NotNull String name) {
        if (name.contains(".")) {
            String[] nameData = name.split("\\.");
            return nameData[nameData.length - 1];
        }
        return "";
    }

    public static String[] findParents(String fileString) {
        if (fileString.contains(File.separator)) {
            String[] data = fileString.replace(File.separatorChar, ';').split(";");
            return Arrays.copyOf(data, data.length - 1);
        }
        return new String[0];
    }

    public static String clearParents(String fileString) {
        if (fileString.contains(File.separator)) {
            String[] data = fileString.replace(File.separatorChar, ';').split(";");
            return data[data.length - 1];
        }
        return fileString;
    }

    public static String getName(@NotNull File file, boolean extension) {
        if (extension) {
            return file.getName();
        }
        return StringUtils.replaceLast(file.getName(), "." + FileUtilities.getExtension(file), "");
    }

    public static String getFileType(File file) {
        try {
            String mimetype = Files.probeContentType(file.toPath());
            if (mimetype != null) {
                if (mimetype.contains("/")) {
                    return mimetype.split("/")[0];
                }
                return mimetype;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return FileUtilities.getExtension(file);
    }

    public static String getFileCompleteType(File file) {
        if (!file.isDirectory()) {
            try {
                String mimetype = Files.probeContentType(file.toPath());
                if (mimetype != null) {
                    return mimetype;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return FileUtilities.getExtension(file);
        }
        return "directory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getFileCompression(File file) {
        String name = FileUtilities.getName(file, true).toLowerCase();
        InputStream stream = null;
        InputStreamReader inReader = null;
        BufferedReader reader = null;
        try {
            stream = FileUtilities.class.getResourceAsStream("/compressions.txt");
            if (stream != null) {
                String format;
                inReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                reader = new BufferedReader(inReader);
                while ((format = reader.readLine()) != null) {
                    if (!name.endsWith(format.toLowerCase())) continue;
                    String string = format.replaceFirst("\\.", "");
                    return string;
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inReader != null) {
                    inReader.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static List<String> readAllLines(File file) {
        try {
            return Files.readAllLines(FileUtilities.getFixedFile(file).toPath());
        }
        catch (Throwable ex) {
            return Collections.emptyList();
        }
    }

    public static File getSourceFile(KarmaSource source) {
        File file = new File(source.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        return FileUtilities.getFixedFile(file);
    }

    public static File getFixedFile(@NotNull File file) {
        return new File(FileUtilities.getFile(file, ' '));
    }

    public static File getProjectFolder(String delimiter) {
        String path;
        File jar = FileUtilities.getFixedFile(new File(FileUtilities.class.getProtectionDomain().getCodeSource().getLocation().getPath()));
        File folder = FileUtilities.getFixedFile(new File(jar.getAbsolutePath().replace(jar.getName(), "")));
        if (!StringUtils.isNullOrEmpty(delimiter) && !folder.getName().equals(delimiter) && (path = folder.getAbsolutePath()).contains(delimiter)) {
            String[] path_data = path.split(File.separator.replace("\\", "\\\\"));
            int plugins_amount = 0;
            for (String data : path_data) {
                if (!data.equals(delimiter)) continue;
                ++plugins_amount;
            }
            int plugins_count = 0;
            StringBuilder builder = new StringBuilder();
            for (String data : path_data) {
                if (data.equals(delimiter)) {
                    ++plugins_count;
                }
                builder.append(data).append(File.separatorChar);
                if (plugins_count >= plugins_amount) break;
            }
            return FileUtilities.getFixedFile(new File(builder.toString()));
        }
        return FileUtilities.getFixedFile(folder);
    }

    public static File getProjectParent() {
        return FileUtilities.getFixedFile(KarmaAPI.source(false).getDataPath().toFile().getParentFile());
    }

    @Deprecated
    public static File getProjectFolder(KarmaSource source) {
        return FileUtilities.getFixedFile(source.getDataPath().toFile());
    }
}

