/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaElement;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaKeyArray;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaObject;
import org.jetbrains.annotations.NotNull;

public class KarmaArray
extends KarmaElement
implements Iterable<KarmaElement> {
    private final Set<KarmaElement> elements = new LinkedHashSet<KarmaElement>();

    public KarmaArray(KarmaElement ... element) {
        this.elements.addAll(Arrays.asList(element));
    }

    public void add(KarmaElement ... element) {
        this.elements.addAll(Arrays.asList(element));
    }

    public void remove(KarmaElement ... element) {
        Arrays.asList(element).forEach(this.elements::remove);
    }

    public boolean contains(KarmaElement ... element) {
        HashSet<String> strings = new HashSet<String>();
        HashSet<Number> numbers = new HashSet<Number>();
        HashSet<Boolean> booleans = new HashSet<Boolean>();
        for (KarmaElement item : this.elements) {
            if (!item.isArray() && !item.isKeyArray()) {
                KarmaObject obj = item.getObjet();
                if (obj.isString()) {
                    strings.add(obj.getString());
                }
                if (obj.isNumber()) {
                    numbers.add(obj.getNumber());
                }
                if (!obj.isBoolean()) continue;
                booleans.add(obj.getBoolean());
                continue;
            }
            this.fill(item, strings, numbers, booleans);
        }
        for (KarmaElement check : element) {
            boolean bool;
            Number number;
            String str;
            if (!check.isValid() || !(check instanceof KarmaObject)) continue;
            KarmaObject obj = check.getObjet();
            if (check.isString() && strings.contains(str = obj.getString())) {
                return true;
            }
            if (check.isNumber() && numbers.contains(number = obj.getNumber())) {
                return true;
            }
            if (!check.isBoolean() || !booleans.contains(bool = obj.getBoolean().booleanValue())) continue;
            return true;
        }
        return false;
    }

    public KarmaElement containsAny(KarmaElement ... element) {
        HashSet<String> strings = new HashSet<String>();
        HashSet<Number> numbers = new HashSet<Number>();
        HashSet<Boolean> booleans = new HashSet<Boolean>();
        for (KarmaElement item : this.elements) {
            if (!item.isArray() && !item.isKeyArray()) {
                KarmaObject obj = item.getObjet();
                if (obj.isString()) {
                    strings.add(obj.toString());
                }
                if (obj.isNumber()) {
                    numbers.add(obj.getNumber());
                }
                if (!obj.isBoolean()) continue;
                booleans.add(obj.getBoolean());
                continue;
            }
            this.fill(item, strings, numbers, booleans);
        }
        for (KarmaElement check : element) {
            boolean bool;
            Number number;
            String str;
            if (!check.isValid() || !(check instanceof KarmaObject)) continue;
            KarmaObject obj = check.getObjet();
            if (check.isString() && strings.contains(str = obj.getString())) {
                return check;
            }
            if (check.isNumber() && numbers.contains(number = obj.getNumber())) {
                return check;
            }
            if (!check.isBoolean() || !booleans.contains(bool = obj.getBoolean().booleanValue())) continue;
            return check;
        }
        return null;
    }

    public boolean containsAll(KarmaElement ... element) {
        HashSet<String> strings = new HashSet<String>();
        HashSet<Number> numbers = new HashSet<Number>();
        HashSet<Boolean> booleans = new HashSet<Boolean>();
        for (KarmaElement item : this.elements) {
            if (!item.isArray() && !item.isKeyArray()) {
                KarmaObject obj = item.getObjet();
                if (obj.isString()) {
                    strings.add(obj.toString());
                }
                if (obj.isNumber()) {
                    numbers.add(obj.getNumber());
                }
                if (!obj.isBoolean()) continue;
                booleans.add(obj.getBoolean());
                continue;
            }
            this.fill(item, strings, numbers, booleans);
        }
        for (KarmaElement check : element) {
            boolean bool;
            Number number;
            String str;
            if (!check.isValid() || !(check instanceof KarmaObject)) continue;
            KarmaObject obj = check.getObjet();
            if (check.isString() && !strings.contains(str = obj.getString())) {
                return false;
            }
            if (check.isNumber() && !numbers.contains(number = obj.getNumber())) {
                return false;
            }
            if (!check.isBoolean() || booleans.contains(bool = obj.getBoolean().booleanValue())) continue;
            return false;
        }
        return true;
    }

    public final KarmaElement get(int index) {
        int curr = 0;
        for (KarmaElement element : this.elements) {
            if (++curr != index && curr != this.elements.size()) continue;
            return element;
        }
        return null;
    }

    @Override
    public final KarmaElement toLowerCase() {
        LinkedHashSet<KarmaElement> result = new LinkedHashSet<KarmaElement>();
        for (KarmaElement current : this.elements) {
            KarmaElement tmp;
            if (!current.isArray() && !current.isKeyArray()) {
                KarmaObject object = current.getObjet();
                tmp = object.toLowerCase();
            } else if (current.isArray()) {
                KarmaArray ar = current.getArray();
                tmp = ar.toLowerCase();
            } else {
                KarmaKeyArray ark = current.getKeyArray();
                tmp = ark.toLowerCase();
            }
            result.add(tmp);
        }
        return new KarmaArray(result.toArray(new KarmaElement[0]));
    }

    @Override
    public final KarmaElement toUpperCase() {
        LinkedHashSet<KarmaElement> result = new LinkedHashSet<KarmaElement>();
        for (KarmaElement current : this.elements) {
            KarmaElement tmp;
            if (!current.isArray() && !current.isKeyArray()) {
                KarmaObject object = current.getObjet();
                tmp = object.toUpperCase();
            } else if (current.isArray()) {
                KarmaArray ar = current.getArray();
                tmp = ar.toUpperCase();
            } else {
                KarmaKeyArray ark = current.getKeyArray();
                tmp = ark.toUpperCase();
            }
            result.add(tmp);
        }
        return new KarmaArray(result.toArray(new KarmaElement[0]));
    }

    @Override
    @NotNull
    public final Iterator<KarmaElement> iterator() {
        return new LinkedHashSet<KarmaElement>(this.elements).iterator();
    }

    @Override
    public final KarmaElement copy() {
        return new KarmaArray(this.elements.toArray(new KarmaElement[0]));
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public final boolean isKeyArray() {
        return false;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isBoolean() {
        return false;
    }

    @Override
    public final boolean isValid() {
        for (KarmaElement element : this.elements) {
            if (element != null) continue;
            return false;
        }
        return true;
    }

    private void fill(KarmaElement array, Set<String> strings, Set<Number> numbers, Set<Boolean> booleans) {
        if (array instanceof KarmaArray) {
            KarmaArray r = (KarmaArray)array;
            r.forEach(item -> {
                if (!item.isArray() && !item.isKeyArray()) {
                    KarmaObject obj = item.getObjet();
                    if (obj.isString()) {
                        strings.add(obj.toString());
                    }
                    if (obj.isNumber()) {
                        numbers.add(obj.getNumber());
                    }
                    if (obj.isBoolean()) {
                        booleans.add(obj.getBoolean());
                    }
                } else {
                    this.fill((KarmaElement)item, strings, numbers, booleans);
                }
            });
        }
        if (array instanceof KarmaKeyArray) {
            KarmaKeyArray rk = (KarmaKeyArray)array;
            rk.forEach(item -> {
                if (!item.isArray() && !item.isKeyArray()) {
                    KarmaObject obj = item.getObjet();
                    if (obj.isString()) {
                        strings.add(obj.toString());
                    }
                    if (obj.isNumber()) {
                        numbers.add(obj.getNumber());
                    }
                    if (obj.isBoolean()) {
                        booleans.add(obj.getBoolean());
                    }
                } else {
                    this.fill((KarmaElement)item, strings, numbers, booleans);
                }
            });
        }
    }
}

