/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.uuid;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import ml.karmaconfigs.remote.messaging.google.gson.Gson;
import ml.karmaconfigs.remote.messaging.google.gson.GsonBuilder;
import ml.karmaconfigs.remote.messaging.google.gson.JsonArray;
import ml.karmaconfigs.remote.messaging.google.gson.JsonElement;
import ml.karmaconfigs.remote.messaging.google.gson.JsonObject;
import ml.karmaconfigs.remote.messaging.google.gson.JsonPrimitive;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url.HttpUtil;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url.URLUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.uuid.OKAResponse;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.uuid.UUIDType;
import org.jetbrains.annotations.Nullable;

public final class UUIDUtil {
    public static void registerMinecraftClient(String name) {
        HttpUtil utils;
        int response_code;
        URL first = URLUtils.getOrNull("https://karmadev.es/?nick=" + name);
        URL second = URLUtils.getOrNull("https://karmarepo.000webhostapp.com/api/?nick=" + name);
        URL third = URLUtils.getOrNull("https://karmaconfigs.ml/api/?nick=" + name);
        URL fourth = URLUtils.getOrNull("https://karmarepo.ml/api/?nick=" + name);
        if (first != null && (response_code = URLUtils.getResponseCode("https://karmadev.es")) == 200 && (utils = URLUtils.extraUtils(first)) != null) {
            utils.push();
        }
        if (second != null && (response_code = URLUtils.getResponseCode("https://karmarepo.000webhostapp.com")) == 200 && (utils = URLUtils.extraUtils(second)) != null) {
            utils.push();
        }
        if (third != null && (response_code = URLUtils.getResponseCode("https://karmaconfigs.ml/")) == 200 && (utils = URLUtils.extraUtils(third)) != null) {
            utils.push();
        }
        if (fourth != null && (response_code = URLUtils.getResponseCode("https://karmarepo.ml/")) == 200 && (utils = URLUtils.extraUtils(fourth)) != null) {
            utils.push();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static UUID fetch(String name, UUIDType type) {
        switch (1.$SwitchMap$ml$karmaconfigs$api$common$utils$uuid$UUIDType[type.ordinal()]) {
            case 1: {
                try {
                    url = URLUtils.getOrBackup("https://karmaconfigs.ml/api/?nick=" + name, new String[]{"https://karmarepo.ml/api/?nick=" + name});
                    if (url == null) ** GOTO lbl45
                    urlStr = url.toString();
                    result = null;
                    response = url.openStream();
                    responseReader = new InputStreamReader(response, StandardCharsets.UTF_8);
                    reader = new BufferedReader(responseReader);
                    if (!urlStr.equalsIgnoreCase("https://api.mojang.com/users/profiles/minecraft/" + name) && !urlStr.equalsIgnoreCase("https://api.minetools.eu/uuid/" + name)) ** GOTO lbl18
                    gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                    json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    if (json.has("id") && (element = json.get("id")).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString() && (result = primitive.getAsString()).equalsIgnoreCase("null")) {
                        result = null;
                    }
                    ** GOTO lbl37
lbl18:
                    // 1 sources

                    if (!urlStr.equalsIgnoreCase("https://minecraft-api.com/api/uuid/" + name)) ** GOTO lbl23
                    while ((line = reader.readLine()) != null) {
                        result = line.replaceAll("\\s", "");
                    }
                    ** GOTO lbl37
lbl23:
                    // 1 sources

                    gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                    json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    if (json.has("online")) {
                        online = json.getAsJsonArray("online");
                        for (JsonElement sub : online) {
                            if (!sub.isJsonObject() || !(data = sub.getAsJsonObject()).has("data") || !(onlineData = data.get("data")).isJsonObject() || !(data = onlineData.getAsJsonObject()).has("short")) continue;
                            result = data.get("short").getAsString();
                            break;
                        }
                        if (StringUtils.isNullOrEmpty(result)) {
                            offline = json.getAsJsonArray("offline");
                            for (JsonElement sub : offline) {
                                if (!sub.isJsonObject() || !(data = sub.getAsJsonObject()).has("data") || !(offlineData = data.get("data")).isJsonObject() || !(data = offlineData.getAsJsonObject()).has("short")) continue;
                                result = data.get("short").getAsString();
                                break;
                            }
                        }
                    }
lbl37:
                    // 8 sources

                    reader.close();
                    responseReader.close();
                    response.close();
                    if (result != null && result.equalsIgnoreCase("Playernotfound!")) {
                        result = null;
                    }
                    return UUIDUtil.fromTrimmed(result);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
lbl45:
                // 2 sources

                return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes());
            }
        }
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes());
    }

    public static String fetchNick(UUID uuid) {
        String result = null;
        try {
            JsonPrimitive primitive;
            JsonElement element;
            Gson gson;
            JsonObject json;
            String response;
            HttpUtil utils;
            URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=" + uuid, "https://karmarepo.000webhostapp.com/api/?fetch=" + uuid, "https://karmaconfigs.ml/api/?fetch=" + uuid, "https://karmarepo.ml/api/?fetch=" + uuid);
            if (url != null && (utils = URLUtils.extraUtils(url)) != null && !StringUtils.isNullOrEmpty(response = utils.getResponse()) && (json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("name") && (element = json.get("name")).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString() && (result = primitive.getAsString()).equals("unknown")) {
                result = null;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Nullable
    public static OKAResponse fetchOKA(String name) {
        OKAResponse result;
        block14: {
            result = null;
            if (!name.equalsIgnoreCase("@all")) {
                try {
                    String response;
                    HttpUtil utils;
                    URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=" + name, "https://karmarepo.000webhostapp.com/api/?fetch=" + name, "https://karmaconfigs.ml/api/?fetch=" + name, "https://karmarepo.ml/api/?fetch=" + name);
                    if (url == null || (utils = URLUtils.extraUtils(url)) == null || StringUtils.isNullOrEmpty(response = utils.getResponse())) break block14;
                    Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                    JsonObject json = (JsonObject)gson.fromJson(response, JsonObject.class);
                    if (json.has("stored")) {
                        JsonArray data = json.getAsJsonArray("fetched");
                        block10: for (JsonElement element : data) {
                            if (!element.isJsonObject()) continue;
                            JsonObject object = element.getAsJsonObject();
                            for (Map.Entry entry : object.entrySet()) {
                                String nick = (String)entry.getKey();
                                UUID off = null;
                                UUID on = null;
                                JsonObject info = ((JsonElement)entry.getValue()).getAsJsonObject();
                                JsonArray offline = info.getAsJsonArray("offline");
                                JsonArray online = info.getAsJsonArray("online");
                                JsonObject offlineData = offline.get(0).getAsJsonObject().get("data").getAsJsonObject();
                                JsonObject onlineData = online.get(0).getAsJsonObject().get("data").getAsJsonObject();
                                try {
                                    off = UUID.fromString(offlineData.get("id").getAsString());
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                try {
                                    on = UUID.fromString(onlineData.get("id").getAsString());
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (!nick.equals(name)) continue;
                                result = new OKAResponse(name, off, on);
                                continue block10;
                            }
                        }
                        break block14;
                    }
                    System.out.println(gson.toJson((JsonElement)json));
                    if (!json.has("name")) break block14;
                    String nick = json.get("name").getAsString();
                    UUID off = null;
                    UUID on = null;
                    JsonArray offline = json.get("offline").getAsJsonArray();
                    JsonArray online = json.get("online").getAsJsonArray();
                    JsonObject offlineData = offline.get(0).getAsJsonObject().get("data").getAsJsonObject();
                    JsonObject onlineData = online.get(0).getAsJsonObject().get("data").getAsJsonObject();
                    try {
                        off = UUID.fromString(offlineData.get("id").getAsString());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        on = UUID.fromString(onlineData.get("id").getAsString());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    result = new OKAResponse(nick, off, on);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    @Nullable
    public static OKAResponse fetchOKAID(UUID id) {
        String nick = UUIDUtil.fetchNick(id);
        return UUIDUtil.fetchOKA(nick);
    }

    public static LateScheduler<Integer> getStored() {
        AsyncLateScheduler<Integer> result = new AsyncLateScheduler<Integer>();
        KarmaAPI.source(false).async().queue(() -> {
            int stored = -1;
            Throwable error = null;
            try {
                JsonPrimitive primitive;
                JsonElement element;
                Gson gson;
                JsonObject json;
                String response;
                HttpUtil utils;
                URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=@all", "https://karmarepo.000webhostapp.com/api/?fetch=@all", "https://karmaconfigs.ml/api/?fetch=@all", "https://karmarepo.ml/api/?fetch=@all");
                if (url != null && (utils = URLUtils.extraUtils(url)) != null && !StringUtils.isNullOrEmpty(response = utils.getResponse()) && (json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("stored") && (element = json.get("stored")).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isNumber()) {
                    stored = primitive.getAsNumber().intValue();
                }
            }
            catch (Throwable ex) {
                error = ex;
            }
            result.complete(stored, error);
        });
        return result;
    }

    public static LateScheduler<Set<OKAResponse>> fetchAll() {
        AsyncLateScheduler<Set<OKAResponse>> result = new AsyncLateScheduler<Set<OKAResponse>>();
        KarmaAPI.source(false).async().queue(() -> {
            HashSet okaData = new HashSet();
            try {
                JsonElement element;
                Gson gson;
                JsonObject json;
                String response;
                HttpUtil utils;
                URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=@all", "https://karmarepo.000webhostapp.com/api/?fetch=@all", "https://karmaconfigs.ml/api/?fetch=@all", "https://karmarepo.ml/api/?fetch=@all");
                if (url != null && (utils = URLUtils.extraUtils(url)) != null && !StringUtils.isNullOrEmpty(response = utils.getResponse()) && (json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("fetched") && (element = json.get("fetched")).isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    for (JsonElement data : array) {
                        if (!data.isJsonObject()) continue;
                        JsonObject obj = data.getAsJsonObject();
                        obj.entrySet().forEach(account -> {
                            String nick = (String)account.getKey();
                            UUID off = null;
                            UUID on = null;
                            JsonObject info = ((JsonElement)account.getValue()).getAsJsonObject();
                            JsonArray offline = info.getAsJsonArray("offline");
                            JsonArray online = info.getAsJsonArray("online");
                            JsonObject offlineData = offline.get(0).getAsJsonObject().get("data").getAsJsonObject();
                            JsonObject onlineData = online.get(0).getAsJsonObject().get("data").getAsJsonObject();
                            try {
                                off = UUID.fromString(offlineData.get("id").getAsString());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                on = UUID.fromString(onlineData.get("id").getAsString());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            OKAResponse tmp = new OKAResponse(nick, off, on);
                            okaData.add(tmp);
                        });
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            result.complete(okaData);
        });
        return result;
    }

    @Nullable
    public static UUID fromTrimmed(String id) {
        UUID result;
        if (!StringUtils.isNullOrEmpty(id)) {
            if (!id.contains("-")) {
                StringBuilder builder = new StringBuilder(id);
                builder.insert(20, "-");
                builder.insert(16, "-");
                builder.insert(12, "-");
                builder.insert(8, "-");
                result = UUID.fromString(builder.toString());
            } else {
                result = UUID.fromString(id);
            }
        } else {
            result = null;
        }
        return result;
    }

    static {
        KarmaAPI.install();
    }
}

