/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging;

import ml.karmaconfigs.remote.messaging.platform.SecureClient;
import ml.karmaconfigs.remote.messaging.platform.SecureServer;
import ml.karmaconfigs.remote.messaging.worker.ssl.SSLClient;
import ml.karmaconfigs.remote.messaging.worker.ssl.SSLServer;

public final class SSLFactory {
    private final String password;
    private final String name;
    private final String extension;
    private final String type;

    public SSLFactory(String pwd, String nm, String ext, String tp) {
        this.password = pwd;
        this.name = nm;
        this.extension = ext;
        this.type = tp;
    }

    public SecureClient createClient() {
        return new SSLClient(this.password, this.name, this.extension, this.type);
    }

    public SecureClient createClient(int target_port) {
        return new SSLClient(this.password, this.name, this.extension, this.type, "127.0.0.1", target_port);
    }

    public SecureClient createClient(String target_host, int target_port) {
        return new SSLClient(this.password, this.name, this.extension, this.type, target_host, target_port);
    }

    public SecureClient createClient(String target_host, int target_port, int local_port) {
        return new SSLClient(this.password, this.name, this.extension, this.type, local_port, target_host, target_port);
    }

    public SecureServer createServer() {
        return new SSLServer(this.password, this.name, this.extension, this.type);
    }

    public SecureServer createServer(int target_port) throws IllegalArgumentException {
        return new SSLServer(this.password, this.name, this.extension, this.type, target_port);
    }

    public SecureServer createServer(String target_host, int target_port) {
        return new SSLServer(this.password, this.name, this.extension, this.type, target_host, target_port);
    }
}

