/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils;

import java.io.Serializable;
import java.util.HashMap;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.KarmaConfig;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class PrefixConsoleData
implements Serializable {
    private final KarmaConfig config = new KarmaConfig();
    private static final HashMap<KarmaSource, String> okPrefix = new HashMap();
    private static final HashMap<KarmaSource, String> infoPrefix = new HashMap();
    private static final HashMap<KarmaSource, String> warnPrefix = new HashMap();
    private static final HashMap<KarmaSource, String> gravPrefix = new HashMap();
    private final KarmaSource source;

    public PrefixConsoleData(@NotNull KarmaSource p) {
        this.source = p;
    }

    public void setOkPrefix(@NotNull String prefix) {
        okPrefix.put(this.source, StringUtils.toAnyOsColor(prefix));
    }

    public void setInfoPrefix(@NotNull String prefix) {
        infoPrefix.put(this.source, StringUtils.toAnyOsColor(prefix));
    }

    public void setWarnPrefix(@NotNull String prefix) {
        warnPrefix.put(this.source, StringUtils.toAnyOsColor(prefix));
    }

    public void setGravePrefix(@NotNull String prefix) {
        gravPrefix.put(this.source, StringUtils.toAnyOsColor(prefix));
    }

    public String getOkPrefix() {
        return okPrefix.getOrDefault(this.source, StringUtils.toAnyOsColor(this.config.consolePrefix(this.source, Level.OK)));
    }

    public String getInfoPrefix() {
        return infoPrefix.getOrDefault(this.source, StringUtils.toAnyOsColor(this.config.consolePrefix(this.source, Level.INFO)));
    }

    public String getWarningPrefix() {
        return warnPrefix.getOrDefault(this.source, StringUtils.toAnyOsColor(this.config.consolePrefix(this.source, Level.WARNING)));
    }

    public String getGravePrefix() {
        return gravPrefix.getOrDefault(this.source, StringUtils.toAnyOsColor(this.config.consolePrefix(this.source, Level.GRAVE)));
    }
}

