/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.listener;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.listener.ClientEvent;
import ml.karmaconfigs.remote.messaging.listener.RemoteMessagingListener;
import ml.karmaconfigs.remote.messaging.listener.ServerEvent;

public final class RemoteListener {
    private static final Map<UUID, RemoteMessagingListener> listeners = new ConcurrentHashMap<UUID, RemoteMessagingListener>();

    public static UUID register(RemoteMessagingListener listener) {
        UUID random = UUID.randomUUID();
        listeners.put(random, listener);
        return random;
    }

    public static void unRegister(UUID listenerId) {
        listeners.remove(listenerId);
    }

    public static void callServerEvent(ServerEvent event) {
        try {
            for (RemoteMessagingListener listener : listeners.values()) {
                Method[] methods;
                Class<?> clazz = listener.getClass();
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    if (method.getParameterTypes().length != 1) continue;
                    Class<?> type = method.getParameterTypes()[0];
                    if (!event.getClass().isAssignableFrom(type)) continue;
                    method.invoke((Object)listener, event);
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void callClientEvent(ClientEvent event) {
        try {
            for (RemoteMessagingListener listener : listeners.values()) {
                Method[] methods;
                Class<?> clazz = listener.getClass();
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    if (method.getParameterTypes().length != 1) continue;
                    Class<?> type = method.getParameterTypes()[0];
                    if (!event.getClass().isAssignableFrom(type)) continue;
                    method.invoke((Object)listener, event);
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

