/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.util.message;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.util.message.type.DataType;
import ml.karmaconfigs.remote.messaging.util.message.type.MergeType;
import ml.karmaconfigs.shaded.maputil.ConcurrentLinkedHashMap;
import org.jetbrains.annotations.Nullable;

public class MessageDataOutput
extends MessageOutput {
    private final ConcurrentMap<String, Serializable> serials = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    private final ConcurrentMap<String, CharSequence> sequences = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    private final ConcurrentMap<String, Boolean> booleans = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    private final ConcurrentMap<String, Number> numbers = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    private final ConcurrentMap<String, char[]> characters = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();
    private final ConcurrentMap<String, byte[]> bytes = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();

    public MessageDataOutput() {
    }

    public MessageDataOutput(MessageOutput affiliate, MergeType type) {
        super(affiliate, type);
    }

    public MessageDataOutput(byte[] compiled, MergeType type) {
        super(compiled, type);
    }

    @Override
    public void writeSerializable(String key, Serializable data) {
        this.serials.put(key, data);
    }

    @Override
    public void write(String key, CharSequence data) {
        this.sequences.put(key, data);
    }

    @Override
    public void write(String key, boolean data) {
        this.booleans.put(key, data);
    }

    @Override
    public void write(String key, Number number) {
        this.numbers.put(key, number);
    }

    @Override
    public void write(String key, char ... chars) {
        this.characters.put(key, chars);
    }

    @Override
    public void write(String key, byte[] data) {
        this.bytes.put(key, data);
    }

    @Override
    public <T> void unsafeWrite(String key, T data, DataType type) {
        try {
            switch (type) {
                case SERIALIZABLE: {
                    this.serials.put(key, (Serializable)data);
                    break;
                }
                case SEQUENCE: {
                    this.sequences.put(key, (CharSequence)data);
                    break;
                }
                case BOOLEAN: {
                    this.booleans.put(key, (Boolean)data);
                    break;
                }
                case NUMBER: {
                    this.numbers.put(key, (Number)data);
                    break;
                }
                case CHARACTER: {
                    this.characters.put(key, (char[])data);
                    break;
                }
                case BYTE: {
                    this.bytes.put(key, (byte[])data);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void remove(String key, DataType type) {
        switch (type) {
            case SERIALIZABLE: {
                this.serials.remove(key);
                break;
            }
            case SEQUENCE: {
                this.sequences.remove(key);
                break;
            }
            case BOOLEAN: {
                this.booleans.remove(key);
            }
            case NUMBER: {
                this.numbers.remove(key);
                break;
            }
            case CHARACTER: {
                this.characters.remove(key);
                break;
            }
            case BYTE: {
                this.bytes.remove(key);
            }
        }
    }

    @Override
    public Set<String> getKeys(DataType type) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        switch (type) {
            case SERIALIZABLE: {
                return this.serials.keySet();
            }
            case SEQUENCE: {
                return this.sequences.keySet();
            }
            case BOOLEAN: {
                return this.booleans.keySet();
            }
            case NUMBER: {
                return this.numbers.keySet();
            }
            case CHARACTER: {
                return this.characters.keySet();
            }
            case BYTE: {
                return this.bytes.keySet();
            }
        }
        return keys;
    }

    @Override
    public boolean contains(String key, DataType type) {
        Object obj = this.get(key, type);
        return obj != null;
    }

    @Override
    <T> T get(String key, DataType type) {
        switch (type) {
            case SERIALIZABLE: {
                Serializable serializable = this.serials.getOrDefault(key, null);
                if (serializable == null) break;
                try {
                    return (T)serializable;
                }
                catch (ClassCastException classCastException) {
                    break;
                }
            }
            case SEQUENCE: {
                CharSequence sequence = this.sequences.getOrDefault(key, null);
                if (sequence == null) break;
                try {
                    return (T)sequence;
                }
                catch (ClassCastException classCastException) {
                    break;
                }
            }
            case BOOLEAN: {
                Boolean bool = this.booleans.getOrDefault(key, null);
                if (bool == null) break;
                try {
                    return (T)bool;
                }
                catch (ClassCastException classCastException) {
                    break;
                }
            }
            case NUMBER: {
                Number number = this.numbers.getOrDefault(key, null);
                if (number == null) break;
                try {
                    return (T)number;
                }
                catch (ClassCastException classCastException) {
                    break;
                }
            }
            case CHARACTER: {
                char[] chars = this.characters.getOrDefault(key, null);
                if (chars == null) break;
                try {
                    return (T)chars;
                }
                catch (ClassCastException classCastException) {
                    break;
                }
            }
            case BYTE: {
                byte[] data = this.bytes.getOrDefault(key, null);
                if (data == null) break;
                try {
                    return (T)data;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public byte[] compile() {
        MessageOutput affiliate = this.affiliate();
        if (affiliate != null) {
            MergeType merge = this.merge();
            DataType[] types = DataType.values();
            switch (merge) {
                case REPLACE: {
                    for (DataType type : types) {
                        Set<String> keys = affiliate.getKeys(type);
                        keys.forEach(key -> {
                            if (this.contains((String)key, type)) {
                                this.unsafeWrite((String)key, affiliate.get((String)key, type), type);
                            }
                        });
                    }
                    break;
                }
                case DIFFERENCE: {
                    for (DataType type : types) {
                        Set<String> keys = affiliate.getKeys(type);
                        keys.forEach(key -> {
                            if (!this.contains((String)key, type)) {
                                this.unsafeWrite((String)key, affiliate.get((String)key, type), type);
                            }
                        });
                    }
                    break;
                }
            }
        }
        return StringUtils.serialize(this).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public MergeType merge() {
        return super.merge();
    }

    @Override
    @Nullable
    public MessageOutput affiliate() {
        return super.affiliate();
    }
}

