/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.util.message;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataOutput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.util.message.type.DataType;
import org.jetbrains.annotations.Nullable;

public abstract class MessageInput {
    private final MessageOutput output;

    public MessageInput(byte[] data) {
        this.output = (MessageOutput)StringUtils.loadUnsafe(new String(data));
    }

    public MessageInput(MessageOutput instance) {
        this.output = instance;
    }

    @Nullable
    public abstract Serializable getSerialized(String var1);

    @Nullable
    public abstract CharSequence getSequence(String var1);

    @Nullable
    public String getString(String key) {
        CharSequence sequence = this.getSequence(key);
        if (sequence != null) {
            try {
                return sequence.toString();
            }
            catch (Throwable throwable) {
            }
        } else {
            Serializable serializable = this.getSerialized(key);
            if (serializable instanceof String) {
                return (String)((Object)serializable);
            }
        }
        return null;
    }

    public abstract boolean getBoolean(String var1);

    @Nullable
    public abstract Number getNumber(String var1);

    public abstract char[] getCharacters(String var1);

    public abstract byte[] getBytes(String var1);

    public final MessageOutput getOutput() {
        return this.output;
    }

    public final MessageInput clone(Map<DataType, Set<String>> remove) {
        MessageDataOutput out = new MessageDataOutput();
        for (DataType type : DataType.values()) {
            this.output.getKeys(type).forEach(key -> {
                Set ignore;
                if (remove.containsKey((Object)type) && !(ignore = (Set)remove.getOrDefault((Object)type, new HashSet())).contains(key)) {
                    out.unsafeWrite((String)key, out.get((String)key, type), type);
                }
            });
        }
        return new MessageDataInput(out);
    }
}

