/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaArray;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaElement;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaKeyArray;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaObject;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.error.KarmaFormatException;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.PathUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.OptionsBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.RandomString;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.TextContent;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.TextType;

public final class KarmaMain {
    private final Path document;
    private final Map<String, KarmaElement> content = new LinkedHashMap<String, KarmaElement>();
    private final Map<KarmaElement, String> reverse = new LinkedHashMap<KarmaElement, String>();
    private final Map<String, Integer> indexes = new HashMap<String, Integer>();
    private String raw = "";
    private InputStream internal = null;

    public KarmaMain() throws IOException {
        OptionsBuilder builder = RandomString.createBuilder().withContent(TextContent.NUMBERS_AND_LETTERS).withSize(16).withType(TextType.RANDOM_SIZE);
        String random = StringUtils.generateString(builder).create();
        this.document = Files.createTempFile(random, "-kf", new FileAttribute[0]);
    }

    public KarmaMain(Path doc) {
        this.document = doc;
        this.preCache();
    }

    public KarmaMain internal(InputStream in) {
        this.internal = in;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preCache() throws KarmaFormatException {
        String main;
        if (!StringUtils.isNullOrEmpty(this.raw)) return;
        List<String> lines = PathUtilities.readAllLines(this.document);
        if (lines.isEmpty() && this.internal != null) {
            try {
                Files.copy(this.internal, this.document, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String fileLines = StringUtils.listToString(lines, false);
        Pattern blockComment = Pattern.compile("\\*\\((?:.|[\\n\\r])*?\\)\\*|\\*/.*");
        LinkedHashSet<String> comments = new LinkedHashSet<String>();
        Matcher commentMatcher = blockComment.matcher(fileLines);
        String remove_string = StringUtils.generateString(RandomString.createBuilder().withSize(32)).create();
        while (commentMatcher.find()) {
            int start = commentMatcher.start();
            int end = commentMatcher.end();
            comments.add(fileLines.substring(start, end));
        }
        for (String comment : comments) {
            fileLines = fileLines.replace(comment, remove_string);
        }
        String[] data = fileLines.split("\n");
        StringBuilder builder = new StringBuilder();
        for (String fl : data) {
            if (fl.replaceAll("\\s", "").equals(remove_string)) continue;
            builder.append(fl).append("\n");
        }
        String result = builder.toString();
        lines = new ArrayList<String>(Arrays.asList(StringUtils.replaceLast(result, "\n", "").split("\n")));
        StringBuilder rawBuilder = new StringBuilder();
        boolean underComment = false;
        boolean jump = true;
        boolean parsedFirst = false;
        String breaking = null;
        int index = 0;
        HashSet<String> added = new HashSet<String>();
        for (String line : lines) {
            if (line.replaceAll("\\s", "").startsWith("*/")) continue;
            int size = line.length();
            this.indexes.put(line, ++index);
            if (breaking != null) {
                throw new KarmaFormatException(this.document, breaking, index);
            }
            boolean string = false;
            for (int i = 0; i < size; ++i) {
                char current = line.charAt(i);
                int nextIndex = i + 1 != size ? i + 1 : i;
                char next = line.charAt(nextIndex);
                if (!underComment) {
                    jump = true;
                    if (current == '*') {
                        if (next == '(') {
                            underComment = true;
                            jump = false;
                        } else {
                            i = size;
                            continue;
                        }
                    }
                    if (underComment) continue;
                    if (current == '(') {
                        if (next != '\"') {
                            if (!parsedFirst) {
                                parsedFirst = true;
                                added.add("main");
                                this.indexes.put("main", index);
                            } else {
                                breaking = "Error, found invalid section definition at " + line + ", it must be (\"x\" where 'x' is any value!";
                            }
                        } else {
                            StringBuilder secName = new StringBuilder();
                            boolean broke = false;
                            for (int x = nextIndex + 1; x < size; ++x) {
                                char tmp = line.charAt(x);
                                if (tmp == '\"') {
                                    broke = true;
                                    break;
                                }
                                secName.append(tmp);
                            }
                            if (broke) {
                                String section = secName.toString();
                                if (!added.contains(section)) {
                                    added.add(section);
                                    this.indexes.put(section, index);
                                } else {
                                    breaking = "Error, found repeated section definition " + section;
                                }
                            } else {
                                breaking = "Error, found invalid section definition at " + line + ", it must be (\"x\" where 'x' is any value!";
                            }
                        }
                    }
                    if (current == '\"') {
                        boolean bl = string = !string;
                    }
                    if (!string) {
                        char prev = line.charAt(i != 0 ? i - 1 : 0);
                        char prev1 = line.charAt(i > 2 ? i - 2 : 0);
                        if (current == '-' && next == '>') {
                            char cont = line.charAt(nextIndex + 1 != size ? nextIndex + 1 : nextIndex);
                            char cont1 = line.charAt(nextIndex + 2 != size ? nextIndex + 2 : nextIndex);
                            boolean error = false;
                            if (Character.isSpaceChar(prev)) {
                                if (!Character.isSpaceChar(prev1)) {
                                    if (Character.isSpaceChar(cont)) {
                                        if (!Character.isSpaceChar(cont1)) {
                                            rawBuilder.append(current);
                                        } else {
                                            error = true;
                                        }
                                    } else {
                                        error = true;
                                    }
                                } else {
                                    error = true;
                                }
                            } else {
                                error = prev == '<' ? !Character.isSpaceChar(prev1) : true;
                            }
                            if (!error) continue;
                            breaking = "Error, found invalid key -> value definition at " + line + ". It must be 'Key' -> \"Value\"";
                            continue;
                        }
                        if (prev == '-' && prev1 == '<') {
                            rawBuilder.append(prev);
                        }
                        rawBuilder.append(current);
                        continue;
                    }
                    rawBuilder.append(current);
                    continue;
                }
                boolean bl = underComment = current != ')' && next != '*';
                if (underComment) continue;
                ++i;
                jump = true;
            }
            if (!jump) continue;
            rawBuilder.append("\n");
        }
        this.raw = rawBuilder.toString();
        String[] tmp = this.raw.split("\n");
        for (int i = 0; i < tmp.length; ++i) {
            if (StringUtils.isNullOrEmpty(tmp[i])) continue;
            this.raw = rawBuilder.substring(i);
            break;
        }
        if (!(main = (data = this.raw.split("\n"))[0]).equals("(") && !main.equals("(\"main\"")) throw new KarmaFormatException(this.document, "Error, found invalid main section name at " + main + "; it must be \"main\" or empty!", this.indexes.getOrDefault(main, -1));
        String parent = "main";
        for (int i = 1; i < data.length; ++i) {
            String line = data[i];
            if (line.replaceAll("\\s", "").startsWith("(")) {
                String name = line.replaceAll("\\s", "");
                name = name.replaceFirst("\\(", "");
                name = name.replaceFirst("\"", "");
                name = name.substring(0, name.length() - 1);
                parent = parent + "." + name;
                continue;
            }
            if (line.contains("->")) {
                KarmaObject obj;
                String[] dt;
                String tmpName;
                int end;
                boolean rec = false;
                Pattern pattern = Pattern.compile("' .?-> ");
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) {
                    throw new KarmaFormatException(this.document, "Error, couldn't find valid key format -> or <-> at ( " + line + " )", this.indexes.getOrDefault(line, -1));
                }
                int start = matcher.start();
                String match = line.substring(start + 2, (end = matcher.end()) - 2).replaceAll("\\s", "");
                if (match.equalsIgnoreCase("<-")) {
                    rec = true;
                }
                if (!(tmpName = (dt = line.split(rec ? "<->" : "->"))[0].replaceAll("\\s", "")).startsWith("'") && !tmpName.endsWith("'")) {
                    throw new KarmaFormatException(this.document, "Error, invalid key format, it must be 'x' where x is any value", this.indexes.getOrDefault(line, -1));
                }
                String name = StringUtils.replaceLast(dt[0].replaceFirst("'", ""), "'", "");
                String key = parent + "." + name.replaceAll("\\s", "");
                StringBuilder value = new StringBuilder();
                for (int x = 1; x < dt.length; ++x) {
                    value.append(dt[x]).append(x != dt.length - 1 ? (rec ? "<->" : "->") : "");
                }
                if (StringUtils.isNullOrEmpty(value)) continue;
                if (value.toString().replaceAll("\\s", "").startsWith("{")) {
                    boolean keyed = false;
                    boolean simple = false;
                    KarmaElement array = new KarmaArray(new KarmaElement[0]);
                    int subIndex = 0;
                    String parentKey = key;
                    int x = i + 1;
                    while (x < data.length) {
                        String v;
                        line = data[x];
                        if (line.replaceAll("\\s", "").endsWith("}")) {
                            i = x;
                            break;
                        }
                        if (line.contains("<->")) {
                            if (!(array instanceof KarmaKeyArray)) {
                                array = new KarmaKeyArray();
                            }
                            if (simple) throw new KarmaFormatException(this.document, "Error, invalid list format. It seems that you mixed a simple list and a keyed list", this.indexes.getOrDefault(line, -1));
                            keyed = true;
                            dt = line.split("->");
                            tmpName = dt[0].replaceAll("\\s", "");
                            if (!tmpName.startsWith("'") && !tmpName.endsWith("'")) {
                                throw new KarmaFormatException(this.document, "Error, invalid key format, it must be 'x' where x is any value", this.indexes.getOrDefault(line, -1));
                            }
                            name = StringUtils.replaceLast(StringUtils.replaceLast(dt[0].replaceFirst("'", ""), "'", ""), "<", "");
                            key = name.replaceAll("\\s", "");
                            value = new StringBuilder();
                            for (int y = 1; y < dt.length; ++y) {
                                value.append(dt[y]).append(y != dt.length - 1 ? "->" : "");
                            }
                            KarmaKeyArray ka = (KarmaKeyArray)array;
                            v = value.toString().replaceFirst(" ", "");
                            if (!StringUtils.isNullOrEmpty(v)) {
                                if (v.startsWith("\"") || v.startsWith("'")) {
                                    if (!v.endsWith(v.startsWith("\"") ? "\"" : "'")) {
                                        throw new KarmaFormatException(this.document, "Error, invalid text format. It seems that you mixed quotes or forgot to close string", this.indexes.getOrDefault(line, -1));
                                    }
                                    v = v.substring(1, v.length() - 1);
                                    KarmaObject obj2 = new KarmaObject(v);
                                    ka.add(key, obj2, true);
                                } else if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("false")) {
                                    boolean bool = Boolean.parseBoolean(v);
                                    KarmaObject obj3 = new KarmaObject(bool);
                                    ka.add(key, obj3, true);
                                } else if (v.contains(",")) {
                                    Double number = Double.parseDouble(v.replace(",", "."));
                                    KarmaObject obj4 = new KarmaObject(number);
                                    ka.add(key, obj4, true);
                                } else if (v.contains(".")) {
                                    Float number = Float.valueOf(Float.parseFloat(v));
                                    KarmaObject obj5 = new KarmaObject(number);
                                    ka.add(key, obj5, true);
                                } else {
                                    Integer number = Integer.parseInt(v);
                                    KarmaObject obj6 = new KarmaObject(number);
                                    ka.add(key, obj6, true);
                                }
                            }
                        } else if (line.contains("->")) {
                            if (!(array instanceof KarmaKeyArray)) {
                                array = new KarmaKeyArray();
                            }
                            if (simple) throw new KarmaFormatException(this.document, "Error, invalid list format. It seems that you mixed a simple list and a keyed list", this.indexes.getOrDefault(line, -1));
                            keyed = true;
                            dt = line.split("->");
                            tmpName = dt[0].replaceAll("\\s", "");
                            if (!tmpName.startsWith("'") && !tmpName.endsWith("'")) {
                                throw new KarmaFormatException(this.document, "Error, invalid key format, it must be 'x' where x is any value", this.indexes.getOrDefault(line, -1));
                            }
                            name = StringUtils.replaceLast(StringUtils.replaceLast(dt[0].replaceFirst("'", ""), "'", ""), "<", "");
                            key = name.replaceAll("\\s", "");
                            value = new StringBuilder();
                            for (int y = 1; y < dt.length; ++y) {
                                value.append(dt[y]).append(y != dt.length - 1 ? "->" : "");
                            }
                            KarmaKeyArray ka = (KarmaKeyArray)array;
                            v = value.toString().replaceFirst(" ", "");
                            if (!StringUtils.isNullOrEmpty(v)) {
                                if (v.startsWith("\"") || v.startsWith("'")) {
                                    if (!v.endsWith(v.startsWith("\"") ? "\"" : "'")) {
                                        throw new KarmaFormatException(this.document, "Error, invalid text format. It seems that you mixed quotes or forgot to close string", this.indexes.getOrDefault(line, -1));
                                    }
                                    v = v.substring(1, v.length() - 1);
                                    KarmaObject obj7 = new KarmaObject(v);
                                    ka.add(key, obj7, false);
                                } else if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("false")) {
                                    boolean bool = Boolean.parseBoolean(v);
                                    KarmaObject obj8 = new KarmaObject(bool);
                                    ka.add(key, obj8, false);
                                } else if (v.contains(",")) {
                                    Double number = Double.parseDouble(v.replace(",", "."));
                                    KarmaObject obj9 = new KarmaObject(number);
                                    ka.add(key, obj9, false);
                                } else if (v.contains(".")) {
                                    Float number = Float.valueOf(Float.parseFloat(v));
                                    KarmaObject obj10 = new KarmaObject(number);
                                    ka.add(key, obj10, false);
                                } else {
                                    Integer number = Integer.parseInt(v);
                                    KarmaObject obj11 = new KarmaObject(number);
                                    ka.add(key, obj11, false);
                                }
                            }
                        } else {
                            if (keyed) throw new KarmaFormatException(this.document, "Error, invalid list format. It seems that you mixed a simple list and a keyed list", this.indexes.getOrDefault(line, -1));
                            if (!(array instanceof KarmaArray)) {
                                array = new KarmaArray(new KarmaElement[0]);
                            }
                            simple = true;
                            value = new StringBuilder();
                            boolean parsing = false;
                            for (int y = 1; y < line.length(); ++y) {
                                char character = line.charAt(y);
                                if (!parsing && !Character.isSpaceChar(character)) {
                                    parsing = true;
                                }
                                if (!parsing) continue;
                                value.append(character);
                            }
                            KarmaElement ka = array;
                            String v2 = value.toString();
                            if (!StringUtils.isNullOrEmpty(v2) && !v2.equals("{")) {
                                KarmaObject obj12;
                                if (v2.startsWith("\"") || v2.startsWith("'")) {
                                    if (!v2.endsWith(v2.startsWith("\"") ? "\"" : "'")) {
                                        throw new KarmaFormatException(this.document, "Error, invalid text format. It seems that you mixed quotes or forgot to close string", this.indexes.getOrDefault(line, -1));
                                    }
                                    v2 = v2.substring(1, v2.length() - 1);
                                    KarmaObject obj13 = new KarmaObject(v2);
                                    ((KarmaArray)ka).add(obj13);
                                } else if (v2.equalsIgnoreCase("true") || v2.equalsIgnoreCase("false")) {
                                    boolean bool = Boolean.parseBoolean(v2);
                                    obj12 = new KarmaObject(bool);
                                    ((KarmaArray)ka).add(obj12);
                                } else if (v2.contains(",")) {
                                    Double number = Double.parseDouble(v2.replace(",", "."));
                                    obj12 = new KarmaObject(number);
                                    ((KarmaArray)ka).add(obj12);
                                } else if (v2.contains(".")) {
                                    Float number = Float.valueOf(Float.parseFloat(v2));
                                    obj12 = new KarmaObject(number);
                                    ((KarmaArray)ka).add(obj12);
                                } else {
                                    Integer number = Integer.parseInt(v2);
                                    obj12 = new KarmaObject(number);
                                    ((KarmaArray)ka).add(obj12);
                                }
                            }
                        }
                        ++x;
                        ++subIndex;
                    }
                    this.content.put(parentKey, array);
                    if (!rec) continue;
                    this.reverse.put(array, parentKey);
                    continue;
                }
                String v = value.toString().replaceFirst(" ", "");
                if (v.startsWith("\"") || v.startsWith("'")) {
                    if (!v.endsWith(v.startsWith("\"") ? "\"" : "'")) {
                        throw new KarmaFormatException(this.document, "Error, invalid text format. It seems that you mixed quotes or forgot to close string", this.indexes.getOrDefault(line, -1));
                    }
                    v = v.substring(1, v.length() - 1);
                    KarmaObject obj14 = new KarmaObject(v);
                    this.content.put(key, obj14);
                    if (!rec) continue;
                    this.reverse.put(obj14, key);
                    continue;
                }
                if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("false")) {
                    boolean bool = Boolean.parseBoolean(v);
                    obj = new KarmaObject(bool);
                    this.content.put(key, obj);
                    if (!rec) continue;
                    this.reverse.put(obj, key);
                    continue;
                }
                if (v.contains(",")) {
                    Double number = Double.parseDouble(v.replace(",", "."));
                    obj = new KarmaObject(number);
                    this.content.put(key, obj);
                    if (!rec) continue;
                    this.reverse.put(obj, key);
                    continue;
                }
                if (v.contains(".")) {
                    Float number = Float.valueOf(Float.parseFloat(v));
                    obj = new KarmaObject(number);
                    this.content.put(key, obj);
                    if (!rec) continue;
                    this.reverse.put(obj, key);
                    continue;
                }
                Integer number = Integer.parseInt(v);
                obj = new KarmaObject(number);
                this.content.put(key, obj);
                if (!rec) continue;
                this.reverse.put(obj, key);
                continue;
            }
            if (!line.replaceAll("\\s", "").endsWith(")") || !parent.contains(".")) continue;
            String[] pData = parent.split("\\.");
            parent = StringUtils.replaceLast(parent, "." + pData[pData.length - 1], "");
            if (pData.length != 1) continue;
            parent = pData[0];
        }
        if (parent.equals("main")) return;
        String[] pData = parent.split("\\.");
        throw new KarmaFormatException(this.document, "Error, non closed section path ( " + parent + " )", this.indexes.getOrDefault(pData[pData.length - 1], -1));
    }

    public boolean exportDefaults() {
        if (this.internal != null) {
            try {
                PathUtilities.create(this.document);
                Files.copy(this.internal, this.document, StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public String getRaw() {
        if (StringUtils.isNullOrEmpty(this.raw)) {
            this.preCache();
        }
        return this.raw;
    }

    public Set<String> getKeys() throws KarmaFormatException {
        return new LinkedHashSet<String>(this.content.keySet());
    }

    public KarmaElement get(String key) throws KarmaFormatException {
        String tmpKey = key;
        if (!tmpKey.startsWith("main.")) {
            tmpKey = "main." + key;
        }
        return this.content.getOrDefault(tmpKey, null);
    }

    public KarmaElement get(String key, KarmaElement def) {
        String tmpKey = key;
        if (!tmpKey.startsWith("main.")) {
            tmpKey = "main." + key;
        }
        return this.content.getOrDefault(tmpKey, def);
    }

    public String get(KarmaElement element) {
        return this.reverse.getOrDefault(element, "").replaceFirst("main\\.", "");
    }

    public String get(KarmaElement element, String def) {
        return this.reverse.getOrDefault(element, def).replaceFirst("main\\.", "");
    }

    public boolean isRecursive(String key) {
        KarmaElement element;
        String tmpKey = key;
        if (!tmpKey.startsWith("main.")) {
            tmpKey = "main." + key;
        }
        if ((element = (KarmaElement)this.content.getOrDefault(tmpKey, null)) != null) {
            String tmp = this.reverse.getOrDefault(element, null);
            return tmp.equals(tmpKey);
        }
        return false;
    }

    public boolean isRecursive(KarmaElement element) {
        String key = this.reverse.getOrDefault(element, null);
        if (key != null) {
            KarmaElement tmp = this.content.getOrDefault(key, null);
            return tmp == element;
        }
        return false;
    }

    public void set(String key, KarmaElement element) {
        String tmpKey = key;
        if (!tmpKey.startsWith("main.")) {
            tmpKey = "main." + tmpKey;
        }
        this.content.put(tmpKey, element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save() throws KarmaFormatException {
        try {
            ArrayList<String> updated = new ArrayList<String>();
            BufferedReader reader = Files.newBufferedReader(this.document, StandardCharsets.UTF_8);
            BufferedWriter writer = Files.newBufferedWriter(this.document, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            StringBuilder section = new StringBuilder();
            boolean closed = false;
            int index = 1;
            int last_section = 0;
            while (true) {
                block25: {
                    String line;
                    block26: {
                        Matcher matcher;
                        block27: {
                            if ((line = reader.readLine()) == null) {
                                if (!section.toString().equals("main")) throw new KarmaFormatException(this.document, "Error, couldn't save file because one or more sections didn't close properly", last_section);
                                return true;
                            }
                            if (closed) break block26;
                            Pattern keyMatcher = Pattern.compile("'.*' .?->");
                            matcher = keyMatcher.matcher(line);
                            if (!matcher.find()) break block27;
                            if (!section.toString().startsWith("main")) throw new KarmaFormatException(this.document, "Error, couldn't save file because the main section is not defined", index);
                            int start = matcher.start();
                            int end = matcher.end();
                            String space = line.substring(0, end);
                            String result = line.substring(start, end);
                            boolean recursive = line.endsWith("<->");
                            String name = result.substring(1, result.length() - (recursive ? 5 : 4));
                            String key = section + "." + name;
                            String value = line.replaceFirst(line.substring(0, start) + result + " ", "");
                            KarmaElement element = this.content.getOrDefault(key, null);
                            if (element != null) {
                                if (element.isString()) {
                                    writer.write(space + "'" + name + "' " + (recursive ? "<-> " : "-> ") + "\"" + element.getObjet().getString() + "\"");
                                } else if (element.isBoolean()) {
                                    writer.write(space + "'" + name + "' " + (recursive ? "<-> " : "-> ") + element.getObjet().getBoolean());
                                } else if (element.isNumber()) {
                                    Number number = element.getObjet().getNumber();
                                    writer.write(space + "'" + name + "' " + (recursive ? "<-> " : "-> ") + number);
                                }
                                if (value.startsWith("'")) {
                                    if (!value.endsWith("'")) throw new KarmaFormatException(this.document, "Error, couldn't save file because a string value is not correctly defined", index);
                                    value = value.substring(1, value.length() - 1);
                                    writer.write(space + "'" + name + "' " + (recursive ? "<-> " : "-> ") + value);
                                    break block25;
                                } else if (value.startsWith("\"")) {
                                    if (!value.endsWith("\"")) throw new KarmaFormatException(this.document, "Error, couldn't save file because a string value is not correctly defined", index);
                                    value = value.substring(1, value.length() - 1);
                                    break block25;
                                } else if (!value.startsWith("{")) {
                                    // empty if block
                                }
                            }
                            break block25;
                        }
                        Pattern sectMatcher = Pattern.compile("(^\\*\\(\".*\")|^\\*(\\()");
                        matcher = sectMatcher.matcher(line);
                        if (matcher.find()) {
                            int start = matcher.start();
                            int end = matcher.end();
                            if (line.contains("\"")) {
                                if (section.length() > 0) {
                                    section.append(".").append(line, start + 2, end - 1);
                                } else {
                                    section = new StringBuilder(line.substring(start + 2, end));
                                }
                                last_section = index;
                                break block25;
                            } else {
                                if (section.toString().equals("main")) throw new KarmaFormatException(this.document, "Error, couldn't save file because the main section has been defined two or more times", index);
                                section = new StringBuilder("main");
                            }
                            break block25;
                        } else {
                            String tmp;
                            Pattern comment = Pattern.compile("(\\*\\(.[^)*]*\\)\\*)|(\\*\\(\\n[^)*]*\\)\\*)|(\\*/.[^\\n]*)");
                            matcher = comment.matcher(line);
                            if (matcher.find() && (tmp = matcher.replaceAll("")).equals(")")) {
                                if (section.toString().contains("\\.")) {
                                    String[] data = section.toString().split("\\.");
                                    String last = data[data.length - 1];
                                    section = new StringBuilder(StringUtils.replaceLast(section.toString(), "." + last, ""));
                                } else {
                                    closed = true;
                                }
                            }
                            updated.add(line);
                        }
                        break block25;
                    }
                    if (!line.replaceAll("\\s", "").isEmpty()) {
                        throw new KarmaFormatException(this.document, "Error, couldn't save file because expected document end but text found", index);
                    }
                }
                ++index;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean save(String name) throws KarmaFormatException {
        return true;
    }

    public boolean save(Path target) throws KarmaFormatException {
        return true;
    }

    public void wad() {
        try {
            List<String> lines = PathUtilities.readAllLines(this.document);
            ArrayList<String> updated = new ArrayList<String>();
            boolean waiting_close = false;
            String waiting = null;
            for (String key : this.content.keySet()) {
                for (String str : lines) {
                    if (!waiting_close) {
                        String original = key;
                        String[] data = key.split("\\.");
                        key = data[data.length - 1];
                        if (str.contains("'" + key + "'")) {
                            KarmaElement array;
                            Pattern pattern;
                            Matcher match;
                            KarmaElement element = this.content.getOrDefault(original, null);
                            if (element == null || !(match = (pattern = Pattern.compile("'.*' .?-> .")).matcher(str)).find()) continue;
                            int end = match.end();
                            char character = str.charAt(end);
                            if (element instanceof KarmaObject) {
                                KarmaObject object = (KarmaObject)element;
                                if (character == '{') {
                                    waiting_close = true;
                                    if (element.isString()) {
                                        waiting = str.substring(0, end - 1) + "'" + object.getString() + "'";
                                        continue;
                                    }
                                    waiting = str.substring(0, end - 1) + (object.isNumber() ? (Serializable)object.getNumber() : (Serializable)object.getBoolean());
                                    continue;
                                }
                                if (element.isString()) {
                                    updated.add(str.substring(0, end - 1) + "'" + object.getString() + "'");
                                    continue;
                                }
                                updated.add(str.substring(0, end - 1) + (object.isNumber() ? (Serializable)object.getNumber() : (Serializable)object.getBoolean()));
                                continue;
                            }
                            StringBuilder waitBuilder = new StringBuilder(str.substring(0, end - 1) + " {\n");
                            if (element instanceof KarmaArray) {
                                array = (KarmaArray)element;
                                array.forEach(sub -> {
                                    KarmaObject object = sub.getObjet();
                                    if (object.isString()) {
                                        waitBuilder.append("'").append(object.getString()).append("'").append("\n");
                                    } else {
                                        waitBuilder.append(object.isNumber() ? (Serializable)object.getNumber() : (Serializable)object.getBoolean()).append("\n");
                                    }
                                });
                            } else {
                                array = (KarmaKeyArray)element;
                                ((KarmaKeyArray)array).getKeys().forEach(arg_0 -> KarmaMain.lambda$wad$1((KarmaKeyArray)array, waitBuilder, arg_0));
                            }
                            waiting = waitBuilder.toString();
                            if (character == '{') {
                                waiting_close = true;
                                continue;
                            }
                            updated.add(waiting);
                            waiting = null;
                            continue;
                        }
                        updated.add(str);
                        continue;
                    }
                    Pattern pattern = Pattern.compile("(\\*\\(.[^)*]*\\)\\*)|(\\*\\(\\n[^)*]*\\)\\*)|(\\*/.[^\\n]*)");
                    Matcher matcher = pattern.matcher(str);
                    if (matcher.find()) {
                        str = matcher.replaceAll("");
                    }
                    if (!str.replaceAll("\\s", "").startsWith("}") && !str.replaceAll("\\s", "").endsWith("}")) continue;
                    waiting_close = false;
                    updated.add(waiting);
                    waiting = null;
                }
            }
            Files.write(this.document, StringUtils.listToString(updated, false).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$wad$1(KarmaKeyArray array, StringBuilder waitBuilder, String sub) {
        KarmaObject object = array.get(sub).getObjet();
        if (object.isString()) {
            waitBuilder.append("'").append(sub).append("'").append(" ").append(array.isRecursive(sub) ? "<->" : "->").append(" ").append("'").append(object.getString()).append("'").append("\n");
        } else {
            waitBuilder.append("'").append(sub).append("'").append(" ").append(array.isRecursive(sub) ? "<->" : "->").append(" ").append(object.isNumber() ? (Serializable)object.getNumber() : (Serializable)object.getBoolean()).append("\n");
        }
    }
}

