/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karmayaml;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.KarmaConfig;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karmayaml.KarmaYamlManager;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.reader.BoundedBufferedReader;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public final class FileCopy {
    private final Map<String, Object> keySet = new HashMap<String, Object>();
    private final Map<String, Integer> keySection = new HashMap<String, Integer>();
    private final Map<String, Integer> repeatedCount = new HashMap<String, Integer>();
    private final Map<String, Integer> repeatedCountSection = new HashMap<String, Integer>();
    private final String fileName;
    private final Class<?> main;

    public FileCopy(KarmaSource source, String name) {
        this.fileName = name;
        this.main = source.getClass();
    }

    public FileCopy(Class<?> main, String name) {
        this.fileName = name;
        this.main = main;
    }

    public void copy(File destFile, @NotNull InputStream inFile) throws IOException {
        int len;
        KarmaConfig config = new KarmaConfig();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inFile.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        destFile = FileUtilities.getFixedFile(destFile);
        if (this.main != null) {
            if (destFile.exists()) {
                boolean yaml;
                ByteArrayInputStream clone = new ByteArrayInputStream(baos.toByteArray());
                InputStreamReader inReader = new InputStreamReader((InputStream)clone, StandardCharsets.UTF_8);
                BoundedBufferedReader reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                String ext = FileUtilities.getExtension(destFile);
                boolean bl = yaml = ext.equals("yml") || ext.equalsIgnoreCase("yaml");
                if (!yaml) {
                    try {
                        Yaml yamlParser = new Yaml();
                        Map tmpYaml = (Map)yamlParser.load((Reader)reader);
                        yaml = tmpYaml != null && !tmpYaml.isEmpty();
                    }
                    catch (Throwable yamlParser) {
                        // empty catch block
                    }
                }
                if (yaml) {
                    String line;
                    ByteArrayInputStream clone1 = new ByteArrayInputStream(baos.toByteArray());
                    this.fillKeySet(destFile, clone1);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                    String last_section = "";
                    if (config.fileDebug(Level.INFO)) {
                        KarmaAPI.source(true).console().send((CharSequence)"Preparing writer for file generation ( {0} )", Level.INFO, FileUtilities.getPrettyFile(destFile));
                    }
                    while ((line = reader.readLine()) != null) {
                        if (!line.replaceAll("\\s", "").isEmpty()) {
                            int repeatedAmount;
                            if (line.replaceAll("\\s", "").startsWith("-")) continue;
                            String key = this.getKey(line);
                            if (line.startsWith("#") || this.keySet.getOrDefault(key, null) == null || this.keySet.get(key) instanceof KarmaYamlManager) {
                                if (config.fileDebug(Level.INFO)) {
                                    KarmaAPI.source(true).console().send((CharSequence)"Writing comment / section &e{0}", Level.INFO, key);
                                }
                                writer.write(line + "\n");
                                continue;
                            }
                            if (this.isRepeated(key)) {
                                repeatedAmount = this.repeatedCount.getOrDefault(key, -1);
                                if (repeatedAmount != -1) {
                                    key = key + "_" + repeatedAmount;
                                }
                                this.repeatedCount.put(this.getKey(line), ++repeatedAmount);
                            }
                            if (this.isSectionRepeated(key)) {
                                last_section = key;
                                repeatedAmount = this.repeatedCountSection.getOrDefault(key, -1);
                                if (repeatedAmount != -1) {
                                    key = key + "_" + repeatedAmount;
                                }
                                this.repeatedCountSection.put(this.getKey(line), ++repeatedAmount);
                            }
                            String path = line.split(":")[0];
                            if (this.keySet.get(key) instanceof List) {
                                List list = (List)this.keySet.get(key);
                                if (!list.isEmpty()) {
                                    writer.write(path + ":\n");
                                    for (Object object : list) {
                                        String space = this.getSpace(key);
                                        writer.write(space + "- '" + object.toString().replace("'", "''") + "'\n");
                                        if (!config.fileDebug(Level.INFO)) continue;
                                        KarmaAPI.source(true).console().send((CharSequence)"Writing list value {0} of {1}", Level.INFO, object, key);
                                    }
                                    continue;
                                }
                                writer.write(path + ": []\n");
                                if (!config.fileDebug(Level.INFO)) continue;
                                KarmaAPI.source(true).console().send((CharSequence)"Written empty list {0}", Level.INFO, key);
                                continue;
                            }
                            String val = line.replace(path + ": ", "");
                            if (this.keySet.get(key) instanceof String) {
                                writer.write(line.replace(": " + val, "") + ": '" + this.keySet.get(key).toString().replace("'", "''").replace("\"", "") + "'\n");
                            } else {
                                writer.write(line.replace(": " + val, "") + ": " + this.keySet.get(key).toString().replace("'", "").replace("\"", "") + "\n");
                            }
                            if (!config.fileDebug(Level.INFO)) continue;
                            KarmaAPI.source(true).console().send((CharSequence)"Writing single value {0} of {1}", Level.INFO, val, key);
                            continue;
                        }
                        writer.write("\n");
                    }
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                } else {
                    List<String> lines = Files.readAllLines(destFile.toPath());
                    StringBuilder builder = new StringBuilder();
                    for (String line : lines) {
                        if (line.replaceAll("\\s", "").isEmpty()) continue;
                        builder.append(line);
                    }
                    if (builder.toString().replaceAll("\\s", "").isEmpty()) {
                        String line;
                        KarmaAPI.source(true).console().send((CharSequence)"Writing to {0} using in-jar file", Level.INFO, FileUtilities.getPrettyFile(destFile));
                        ByteArrayInputStream clone2 = new ByteArrayInputStream(baos.toByteArray());
                        inReader = new InputStreamReader((InputStream)clone2, StandardCharsets.UTF_8);
                        reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                        while ((line = reader.readLine()) != null) {
                            if (config.fileDebug(Level.INFO)) {
                                KarmaAPI.source(true).console().send((CharSequence)"Writing raw text {0} to {1}", Level.INFO, line, FileUtilities.getPrettyFile(destFile));
                            }
                            writer.write(line + "\n");
                        }
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                    }
                }
                inReader.close();
                reader.close();
            } else {
                if (!destFile.getParentFile().exists() && destFile.getParentFile().mkdirs() && config.fileDebug(Level.INFO)) {
                    KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyParentFile(destFile));
                }
                if (destFile.createNewFile()) {
                    String line;
                    if (config.fileDebug(Level.INFO)) {
                        KarmaAPI.source(true).console().send((CharSequence)"Writing to {0} using in-jar file", Level.INFO, FileUtilities.getPrettyFile(destFile));
                    }
                    ByteArrayInputStream clone2 = new ByteArrayInputStream(baos.toByteArray());
                    InputStreamReader inReader = new InputStreamReader((InputStream)clone2, StandardCharsets.UTF_8);
                    BoundedBufferedReader reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        writer.write(line + "\n");
                    }
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
            }
        }
    }

    public void copy(File destFile) throws IOException {
        KarmaConfig config = new KarmaConfig();
        destFile = FileUtilities.getFixedFile(destFile);
        if (this.main != null) {
            if (destFile.exists()) {
                File source = new File(this.main.getProtectionDomain().getCodeSource().getLocation().getFile());
                if (source.renameTo(source)) {
                    JarFile jar = new JarFile(source);
                    ZipEntry entry = jar.getEntry(this.fileName);
                    InputStream inFile = jar.getInputStream(entry);
                    if (inFile != null) {
                        boolean yaml;
                        int len;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((len = inFile.read(buffer)) > -1) {
                            baos.write(buffer, 0, len);
                        }
                        baos.flush();
                        ByteArrayInputStream clone = new ByteArrayInputStream(baos.toByteArray());
                        InputStreamReader inReader = new InputStreamReader((InputStream)clone, StandardCharsets.UTF_8);
                        BoundedBufferedReader reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                        String ext = FileUtilities.getExtension(destFile);
                        boolean bl = yaml = ext.equals("yml") || ext.equalsIgnoreCase("yaml");
                        if (!yaml) {
                            try {
                                Yaml yamlParser = new Yaml();
                                Map tmpYaml = (Map)yamlParser.load((Reader)reader);
                                yaml = tmpYaml != null && !tmpYaml.isEmpty();
                            }
                            catch (Throwable yamlParser) {
                                // empty catch block
                            }
                        }
                        if (yaml) {
                            String line;
                            ByteArrayInputStream clone1 = new ByteArrayInputStream(baos.toByteArray());
                            this.fillKeySet(destFile, clone1);
                            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                            String last_section = "";
                            if (config.fileDebug(Level.INFO)) {
                                KarmaAPI.source(true).console().send((CharSequence)"Preparing writer for file generation ( {0} )", Level.INFO, FileUtilities.getPrettyFile(destFile));
                            }
                            while ((line = reader.readLine()) != null) {
                                if (!line.replaceAll("\\s", "").isEmpty()) {
                                    int repeatedAmount;
                                    if (line.replaceAll("\\s", "").startsWith("-")) continue;
                                    String key = this.getKey(line);
                                    if (line.startsWith("#") || this.keySet.getOrDefault(key, null) == null || this.keySet.get(key) instanceof KarmaYamlManager) {
                                        if (config.fileDebug(Level.INFO)) {
                                            KarmaAPI.source(true).console().send((CharSequence)"Writing comment / section &e{0}", Level.INFO, key);
                                        }
                                        writer.write(line + "\n");
                                        continue;
                                    }
                                    if (this.isRepeated(key)) {
                                        repeatedAmount = this.repeatedCount.getOrDefault(key, -1);
                                        if (repeatedAmount != -1) {
                                            key = key + "_" + repeatedAmount;
                                        }
                                        this.repeatedCount.put(this.getKey(line), ++repeatedAmount);
                                    }
                                    if (this.isSectionRepeated(key)) {
                                        last_section = key;
                                        repeatedAmount = this.repeatedCountSection.getOrDefault(key, -1);
                                        if (repeatedAmount != -1) {
                                            key = key + "_" + repeatedAmount;
                                        }
                                        this.repeatedCountSection.put(this.getKey(line), ++repeatedAmount);
                                    }
                                    String path = line.split(":")[0];
                                    if (this.keySet.get(key) instanceof List) {
                                        List list = (List)this.keySet.get(key);
                                        if (!list.isEmpty()) {
                                            writer.write(path + ":\n");
                                            for (Object object : list) {
                                                String space = this.getSpace(last_section);
                                                writer.write(space + "- '" + object.toString().replace("'", "''") + "'\n");
                                                if (!config.fileDebug(Level.INFO)) continue;
                                                KarmaAPI.source(true).console().send((CharSequence)"Writing list value {0} of {1}", Level.INFO, object, key);
                                            }
                                            continue;
                                        }
                                        writer.write(path + ": []\n");
                                        if (!config.fileDebug(Level.INFO)) continue;
                                        KarmaAPI.source(true).console().send((CharSequence)"Written empty list {0}", Level.INFO, key);
                                        continue;
                                    }
                                    String val = line.replace(path + ": ", "");
                                    if (this.keySet.get(key) instanceof String) {
                                        writer.write(line.replace(": " + val, "") + ": '" + this.keySet.get(key).toString().replace("'", "''").replace("\"", "") + "'\n");
                                    } else {
                                        writer.write(line.replace(": " + val, "") + ": " + this.keySet.get(key).toString().replace("'", "").replace("\"", "") + "\n");
                                    }
                                    if (!config.fileDebug(Level.INFO)) continue;
                                    KarmaAPI.source(true).console().send((CharSequence)"Writing single value {0} of {1}", Level.INFO, val, key);
                                    continue;
                                }
                                writer.write("\n");
                            }
                            ((Writer)writer).flush();
                            ((Writer)writer).close();
                        } else {
                            List<String> lines = Files.readAllLines(destFile.toPath());
                            StringBuilder builder = new StringBuilder();
                            for (String line : lines) {
                                if (line.replaceAll("\\s", "").isEmpty()) continue;
                                builder.append(line);
                            }
                            if (builder.toString().replaceAll("\\s", "").isEmpty()) {
                                String line;
                                KarmaAPI.source(true).console().send((CharSequence)"Writing to {0} using in-jar file", Level.INFO, FileUtilities.getPrettyFile(destFile));
                                ByteArrayInputStream clone2 = new ByteArrayInputStream(baos.toByteArray());
                                inReader = new InputStreamReader((InputStream)clone2, StandardCharsets.UTF_8);
                                reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                                while ((line = reader.readLine()) != null) {
                                    if (config.fileDebug(Level.INFO)) {
                                        KarmaAPI.source(true).console().send((CharSequence)"Writing raw text {0} to {1}", Level.INFO, line, FileUtilities.getPrettyFile(destFile));
                                    }
                                    writer.write(line + "\n");
                                }
                                ((Writer)writer).flush();
                                ((Writer)writer).close();
                            }
                        }
                        inReader.close();
                        reader.close();
                        jar.close();
                    }
                    if (inFile != null) {
                        inFile.close();
                    }
                } else {
                    if (config.log(Level.GRAVE)) {
                        KarmaAPI.source(false).logger().scheduleLog(Level.GRAVE, "Failed to copy file {0} because its source ( {1} ) seems to be open", this.fileName, FileUtilities.getPrettyFile(source));
                    }
                    if (config.fileDebug(Level.GRAVE)) {
                        KarmaAPI.source(true).console().send((CharSequence)"Failed to open stream {0} because the file is open by another process", Level.GRAVE, FileUtilities.getPrettyFile(source));
                    }
                }
            } else {
                if (!destFile.getParentFile().exists() && destFile.getParentFile().mkdirs()) {
                    KarmaAPI.source(true).console().send((CharSequence)"Created directory {0}", Level.INFO, FileUtilities.getPrettyParentFile(destFile));
                }
                if (destFile.createNewFile()) {
                    KarmaAPI.source(true).console().send((CharSequence)"Writing to {0} using in-jar file", Level.INFO, FileUtilities.getPrettyFile(destFile));
                    File source = new File(this.main.getProtectionDomain().getCodeSource().getLocation().getFile());
                    JarFile jar = new JarFile(source);
                    ZipEntry entry = jar.getEntry(this.fileName);
                    InputStream inFile = jar.getInputStream(entry);
                    if (inFile != null) {
                        String line;
                        InputStreamReader inReader = new InputStreamReader(inFile, StandardCharsets.UTF_8);
                        BoundedBufferedReader reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                        while ((line = reader.readLine()) != null) {
                            writer.write(line + "\n");
                        }
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                        inFile.close();
                    }
                    jar.close();
                }
            }
        }
    }

    public void copy(Path destFile, InputStream inFile) throws IOException {
        this.copy(destFile.toFile(), inFile);
    }

    public void copy(Path destFile) throws IOException {
        this.copy(destFile.toFile());
    }

    public void fix(File destFile) {
        try {
            ArrayList<String> writeTarget = new ArrayList<String>();
            destFile = FileUtilities.getFixedFile(destFile);
            List<String> lines = FileUtilities.readAllLines(destFile);
            for (int i = 0; i < lines.size(); ++i) {
                String[] keyData;
                String key;
                String value;
                int nextSpaces;
                int currentSpaces;
                String next;
                boolean written = false;
                String current = lines.get(i);
                if (!current.startsWith("#") && i != lines.size() - 1 && !(next = lines.get(i + 1)).startsWith("#") && (currentSpaces = this.countSpaces(current)) < (nextSpaces = this.countSpaces(next)) && current.contains(":") && !(value = current.replaceFirst((key = (keyData = current.split(":"))[0]) + ": ", "").replaceAll("\\s", "")).isEmpty()) {
                    writeTarget.add(key + ": ");
                    written = true;
                }
                if (written) continue;
                writeTarget.add(current);
            }
            BufferedWriter writer = Files.newBufferedWriter(destFile.toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            for (String line : writeTarget) {
                writer.write(line + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void fillKeySet(File destFile, InputStream inFile) {
        KarmaYamlManager out = new KarmaYamlManager(FileUtilities.getFixedFile(destFile));
        KarmaYamlManager in = new KarmaYamlManager(inFile);
        for (String key : in.getKeySet()) {
            Object outValue;
            if (in.isSection(key)) {
                KarmaYamlManager inSection = in.getSection(key);
                KarmaYamlManager outSection = out.getSection(key, inSection);
                this.fillKeySet(0, inSection, outSection);
                this.putSection(key, 0);
                continue;
            }
            this.putSection(key, 1);
            if (out.isSet(key) && (outValue = out.get(key)) != null && in.matchesWith(key, outValue.getClass())) {
                this.putKey(key, outValue);
                continue;
            }
            this.putKey(key, in.get(key));
        }
    }

    private void fillKeySet(int tree, KarmaYamlManager inSection, KarmaYamlManager outSection) {
        for (String key : inSection.getKeySet()) {
            Object outValue;
            if (inSection.isSection(key)) {
                this.fillKeySet(++tree, inSection.getSection(key), outSection.getSection(key, inSection.getSection(key)));
                this.putSection(key, ++tree);
                continue;
            }
            int indent = 0;
            for (KarmaYamlManager parent = inSection.getParent(); parent != null; parent = parent.getParent()) {
                ++indent;
            }
            this.putSection(key, indent);
            if (outSection.isSet(key) && (outValue = outSection.get(key)) != null && inSection.matchesWith(key, outValue.getClass())) {
                this.putKey(key, outValue);
                continue;
            }
            this.putKey(key, inSection.get(key));
        }
    }

    private void putKey(String key, Object value) {
        if (!this.keySet.containsKey(key)) {
            this.keySet.put(key, value);
        } else {
            this.keySet.put(key + "_" + this.repeatedAmount(key), value);
        }
    }

    private void putSection(String key, int tree) {
        KarmaConfig config = new KarmaConfig();
        if (config.fileDebug(Level.INFO)) {
            KarmaAPI.source(true).console().send((CharSequence)"Added key {0} to section number {1}", Level.INFO, key, tree);
        }
        if (this.keySection.containsKey(key)) {
            this.keySection.put(key + "_" + this.repeatedSection(key), tree);
        } else {
            this.keySection.put(key, tree);
        }
    }

    private String getKey(String line) {
        line = line.split(":")[0];
        line = line.replaceAll("\\s", "");
        return line;
    }

    private String getSpace(String line) {
        KarmaConfig config = new KarmaConfig();
        if (config.fileDebug(Level.INFO)) {
            KarmaAPI.source(true).console().send((CharSequence)"Getting spaces amount for {0}", Level.INFO, line);
        }
        int spaces = this.keySection.getOrDefault(line, 0);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            builder.append("  ");
        }
        if (config.fileDebug(Level.INFO)) {
            KarmaAPI.source(true).console().send((CharSequence)"Spaces for {0}: {1} ({2})", Level.INFO, line, spaces, builder);
        }
        return builder.append("  ").toString();
    }

    private int repeatedAmount(String key) {
        int repeated = 0;
        Iterator<String> set = this.keySet.keySet().iterator();
        if (set.hasNext()) {
            do {
                String[] keyData;
                String next;
                if (!(next = set.next()).contains("_") || !(keyData = next.split("_"))[0].equals(key)) continue;
                ++repeated;
            } while (set.hasNext());
        }
        return repeated;
    }

    private int repeatedSection(String key) {
        int repeated = 0;
        Iterator<String> set = this.keySection.keySet().iterator();
        if (set.hasNext()) {
            do {
                String[] keyData;
                String next;
                if (!(next = set.next()).contains("_") || !(keyData = next.split("_"))[0].equals(key)) continue;
                ++repeated;
            } while (set.hasNext());
        }
        return repeated;
    }

    private int countSpaces(String line) {
        char character;
        int spaces = 0;
        for (int i = 0; i < line.length() && !Character.isLetterOrDigit(character = line.charAt(i)); ++i) {
            if (!Character.isSpaceChar(character)) continue;
            ++spaces;
        }
        return spaces;
    }

    private boolean isRepeated(String key) {
        return this.repeatedAmount(key) > 0;
    }

    private boolean isSectionRepeated(String key) {
        return this.repeatedSection(key) > 0;
    }
}

