/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker;

import java.util.function.BiConsumer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.BiLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.CancellableScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.TriConsumer;

public final class AsyncBiLateScheduler<A, B>
implements BiLateScheduler<A, B> {
    private Runnable whenCompleteRunner;
    private Runnable onCancel;
    private BiConsumer<A, B> whenComplete;
    private TriConsumer<A, B, Throwable> whenCompleteWithError;
    private boolean cancelled = false;
    private boolean completed = false;
    private A typeA = null;
    private B typeB = null;
    private Throwable typeE = null;

    @Override
    public BiLateScheduler<A, B> whenComplete(Runnable action) {
        this.whenCompleteRunner = action;
        if (this.completed) {
            this.whenCompleteRunner.run();
        }
        return this;
    }

    @Override
    public BiLateScheduler<A, B> whenComplete(BiConsumer<A, B> action) {
        this.whenComplete = action;
        if (this.completed) {
            this.whenComplete.accept(this.typeA, this.typeB);
        }
        return this;
    }

    @Override
    public BiLateScheduler<A, B> whenComplete(TriConsumer<A, B, Throwable> caughtAction) {
        this.whenCompleteWithError = caughtAction;
        if (this.completed) {
            this.whenCompleteWithError.accept(this.typeA, this.typeB, this.typeE);
        }
        return this;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public A getObject() {
        return this.typeA;
    }

    @Override
    public B getSubObject() {
        return this.typeB;
    }

    @Override
    public void complete(A target, B subTarget) {
        if (this.cancelled || this.completed) {
            return;
        }
        try {
            new Thread(() -> {
                if (this.whenComplete != null) {
                    this.whenComplete.accept(target, subTarget);
                }
                if (this.whenCompleteWithError != null) {
                    this.whenCompleteWithError.accept(target, subTarget, null);
                }
                if (this.whenCompleteRunner != null) {
                    this.whenCompleteRunner.run();
                }
                this.typeA = target;
                this.typeB = subTarget;
            }).start();
            this.completed = true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void complete(A target, B subTarget, Throwable error) {
        if (this.cancelled || this.completed) {
            return;
        }
        try {
            new Thread(() -> {
                if (this.whenCompleteWithError != null) {
                    this.whenCompleteWithError.accept(target, subTarget, error);
                }
                if (this.whenComplete != null) {
                    this.whenComplete.accept(target, subTarget);
                }
                if (this.whenCompleteRunner != null) {
                    this.whenCompleteRunner.run();
                }
                this.typeA = target;
                this.typeB = subTarget;
                this.typeE = error;
            }).start();
            this.completed = true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public CancellableScheduler whenCancelled(Runnable action) {
        this.onCancel = action;
        if (this.cancelled) {
            action.run();
        }
        return this;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled() {
        this.cancelled = true;
        if (this.onCancel != null) {
            this.onCancel.run();
        }
    }
}

