/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.ssl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import ml.karmaconfigs.remote.messaging.karmaapi.common.Console;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.SourceSecondsTimer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.SourceSimpleTimer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.SimpleScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.listener.RemoteListener;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerConnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerDisconnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerMessageEvent;
import ml.karmaconfigs.remote.messaging.platform.SecureClient;
import ml.karmaconfigs.remote.messaging.remote.RemoteServer;
import ml.karmaconfigs.remote.messaging.util.WorkLevel;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataOutput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.util.message.type.MergeType;
import ml.karmaconfigs.remote.messaging.worker.ssl.remote.SSLRemoteServer;

public final class SSLClient
extends SecureClient {
    private final Set<byte[]> data_queue = Collections.newSetFromMap(new ConcurrentHashMap());
    private RemoteServer remote = null;
    private String client_name = "client_" + new Random().nextInt(Integer.MAX_VALUE);
    private String server = "127.0.0.1";
    private String key = "";
    private int sv_port = 49305;
    private int client = 49300;
    private int disconnect = 10;
    private boolean disconnecting = false;
    private boolean debug = false;
    private boolean operative = false;
    private boolean instant_close = false;
    private boolean award_connection = false;
    private boolean tryingConnect = true;
    private boolean waitingResponse = false;
    private boolean preventStatusChange = false;
    private boolean fullyConnected = false;
    private SSLSocket socket;
    private final String password;
    private final String name;
    private final String extension;
    private final String type;
    private final Console console = new Console(this);
    private String protocol = "TLSv1.3";
    private Path parent = this.getDataPath().resolve("certs");

    public SSLClient(String pwd, String nm, String ext, String tp) {
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[SSL Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[SSL Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[SSL Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[SSL Client (&4ERROR&3)]&b ");
        this.password = pwd;
        this.name = nm;
        this.extension = ext;
        this.type = tp;
    }

    public SSLClient(String pwd, String nm, String ext, String tp, String server_host, int server_port) {
        this.server = server_host;
        this.sv_port = server_port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[SSL Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[SSL Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[SSL Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[SSL Client (&4ERROR&3)]&b ");
        this.password = pwd;
        this.name = nm;
        this.extension = ext;
        this.type = tp;
    }

    public SSLClient(String pwd, String nm, String ext, String tp, int client_port, String server_host, int server_port) {
        this.client = client_port;
        this.server = server_host;
        this.sv_port = server_port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[SSL Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[SSL Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[SSL Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[SSL Client (&4ERROR&3)]&b ");
        this.password = pwd;
        this.name = nm;
        this.extension = ext;
        this.type = tp;
    }

    @Override
    public SecureClient debug(boolean status) {
        this.debug = status;
        return this;
    }

    @Override
    public SecureClient protocol(String p) {
        this.protocol = p;
        return this;
    }

    @Override
    public SecureClient certsLocation(Path location) {
        this.parent = location;
        return this;
    }

    @Override
    public LateScheduler<Boolean> connect() {
        if (!this.operative) {
            this.tryingConnect = true;
            this.disconnecting = false;
            AsyncLateScheduler<Boolean> result = new AsyncLateScheduler<Boolean>();
            Thread thread = new Thread(() -> this.lambda$connect$0(result));
            thread.start();
            return result;
        }
        return null;
    }

    @Override
    public LateScheduler<Boolean> connect(String accessKey) {
        if (!this.operative) {
            this.key = accessKey;
            return this.connect();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.client_name;
    }

    @Override
    public String getMAC() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] macArray = network.getHardwareAddress();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < macArray.length; ++i) {
                str.append(String.format("%02X%s", macArray[i], i < macArray.length - 1 ? ":" : ""));
            }
            return str.toString();
        }
        catch (Throwable ex) {
            System.out.println("Failed to locate MAC address...");
            System.exit(1);
            return null;
        }
    }

    @Override
    public InetAddress getHost() {
        return InetAddress.getLoopbackAddress();
    }

    @Override
    public int getPort() {
        return this.client;
    }

    @Override
    public boolean sendMessage(MessageOutput message) {
        return false;
    }

    @Override
    public RemoteServer getServer() {
        return this.remote;
    }

    @Override
    public WorkLevel getWorkLevel() {
        return WorkLevel.TCP;
    }

    @Override
    public boolean isConnecting() {
        return this.tryingConnect || this.award_connection;
    }

    @Override
    public boolean isConnected() {
        if (this.operative) {
            try {
                MessageDataOutput output = new MessageDataOutput();
                ((MessageOutput)output).write("MAC", this.getMAC());
                ((MessageOutput)output).write("COMMAND_ENABLED", true);
                ((MessageOutput)output).write("COMMAND", "HELLO");
                ((MessageOutput)output).write("ARGUMENT", "");
                if (!StringUtils.isNullOrEmpty(this.key)) {
                    ((MessageOutput)output).write("ACCESS_KEY", this.key);
                }
                byte[] compile = ((MessageOutput)output).compile();
                PrintWriter writer = new PrintWriter(this.socket.getOutputStream());
                writer.println(new String(compile, StandardCharsets.UTF_8));
                writer.flush();
                if (!this.waitingResponse) {
                    this.waitingResponse = true;
                    SimpleScheduler timer = new SourceSecondsTimer(this, 30, false).multiThreading(false);
                    timer.secondChangeAction(sec -> {
                        if (this.preventStatusChange) {
                            timer.cancel();
                            this.preventStatusChange = false;
                        }
                    }).endAction(() -> {
                        this.fullyConnected = false;
                        this.waitingResponse = false;
                        this.close();
                    }).cancelAction(sec -> {
                        this.waitingResponse = false;
                    });
                    timer.start();
                }
                return this.fullyConnected;
            }
            catch (Throwable ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void rename(String name) {
        if (this.award_connection || this.operative) {
            this.client_name = name;
            MessageDataOutput output = new MessageDataOutput();
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", true);
            ((MessageOutput)output).write("COMMAND", "rename");
            ((MessageOutput)output).write("ARGUMENT", this.client_name);
            try {
                if (this.debug) {
                    this.console.send((CharSequence)"Trying to inform the server about the name change request to {0}", Level.INFO, name);
                }
                byte[] compile = ((MessageOutput)output).compile();
                PrintWriter writer = new PrintWriter(this.socket.getOutputStream());
                writer.println(new String(compile, StandardCharsets.UTF_8));
                writer.flush();
            }
            catch (Throwable ex) {
                this.data_queue.add(((MessageOutput)output).compile());
            }
        }
    }

    @Override
    public void send(byte[] data) {
        if (this.award_connection || this.operative) {
            MessageDataOutput output = new MessageDataOutput(data, MergeType.DIFFERENCE);
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", false);
            try {
                byte[] compile = ((MessageOutput)output).compile();
                PrintWriter writer = new PrintWriter(this.socket.getOutputStream());
                writer.println(new String(compile, StandardCharsets.UTF_8));
                writer.flush();
            }
            catch (Throwable ex) {
                this.data_queue.add(((MessageOutput)output).compile());
            }
        }
    }

    @Override
    public void close() {
        if (this.operative) {
            if (!this.disconnecting) {
                try {
                    MessageDataOutput output = new MessageDataOutput();
                    ((MessageOutput)output).write("MAC", this.getMAC());
                    ((MessageOutput)output).write("COMMAND_ENABLED", true);
                    ((MessageOutput)output).write("COMMAND", "disconnect");
                    ((MessageOutput)output).write("ARGUMENT", "Client disconnect request");
                    byte[] compile = ((MessageOutput)output).compile();
                    PrintWriter writer = new PrintWriter(this.socket.getOutputStream());
                    writer.println(new String(compile, StandardCharsets.UTF_8));
                    writer.flush();
                    if (this.debug) {
                        this.console.send((CharSequence)"Trying to inform the server about the disconnect request. The client will wait for server response. If no response is given in 10 seconds the client will disconnect anyway", Level.INFO);
                    }
                    this.disconnect = 10;
                    this.disconnecting = true;
                    SimpleScheduler scheduler = new SourceSimpleTimer(this, 1, true).multiThreading(false);
                    scheduler.restartAction(() -> {
                        if (this.disconnecting) {
                            if (this.disconnect == 0) {
                                this.operative = false;
                                this.award_connection = false;
                                this.tryingConnect = true;
                                try {
                                    this.socket.close();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                this.socket = null;
                                this.disconnecting = false;
                            } else {
                                --this.disconnect;
                            }
                        } else {
                            scheduler.cancel();
                        }
                    });
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            this.instant_close = true;
        }
    }

    @Override
    public String name() {
        return "SSL Client";
    }

    @Override
    public String version() {
        return "0";
    }

    @Override
    public String description() {
        return "TCP client to connect to a TCP server that has been created with RemoteMessaging API";
    }

    @Override
    public String[] authors() {
        return new String[]{"KarmaDev"};
    }

    @Override
    public String updateURL() {
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$connect$0(LateScheduler result) {
        block67: {
            block66: {
                try {
                    if (this.debug) {
                        this.console.send((CharSequence)"Initializing the connection with the server", Level.INFO);
                    }
                    try {
                        if (!Files.exists(this.parent, new LinkOption[0])) {
                            Files.createDirectories(this.parent, new FileAttribute[0]);
                        }
                        serverKeyStore = this.parent.resolve(this.name + "." + this.extension);
                        trustedKeyStore = this.parent.resolve(this.name + "_trusted." + this.extension);
                        internalStorage = new FileInputStream(serverKeyStore.toFile());
                        internalTruster = new FileInputStream(trustedKeyStore.toFile());
                        keyStore = KeyStore.getInstance(this.type);
                        keyStore.load(internalStorage, this.password.toCharArray());
                        kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(keyStore, this.password.toCharArray());
                        trustedStore = KeyStore.getInstance(this.type);
                        trustedStore.load(internalTruster, this.password.toCharArray());
                        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(trustedStore);
                        sc = SSLContext.getInstance(this.protocol);
                        trustManagers = tmf.getTrustManagers();
                        keyManagers = kmf.getKeyManagers();
                        sc.init((KeyManager[])keyManagers, trustManagers, null);
                        ssf = sc.getSocketFactory();
                        try {
                            this.socket = (SSLSocket)ssf.createSocket(this.server, this.sv_port, InetAddress.getLocalHost(), this.client);
                        }
                        catch (Throwable ex) {
                            this.socket = (SSLSocket)ssf.createSocket(this.server, this.sv_port, InetAddress.getLoopbackAddress(), this.client);
                        }
                        this.socket.startHandshake();
                    }
                    catch (Throwable ex) {
                        result.complete(false, ex);
                        return;
                    }
                    this.award_connection = true;
                    if (this.debug) {
                        this.console.send((CharSequence)"The connection has been established but the client is still waiting for server confirmation, data can be started to be sent", Level.WARNING, new Object[]{this.server, this.sv_port});
                    }
                    try {}
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        break block67;
                    }
                    break block66;
                }
                catch (Throwable ex) {
                    result.complete(false, ex);
                }
                return;
            }
            while (this.award_connection) {
                if (this.instant_close) {
                    this.tryingConnect = false;
                    this.award_connection = false;
                    this.operative = false;
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (Throwable ex) {
                            // empty catch block
                        }
                    }
                    this.socket = null;
                }
                if (this.tryingConnect) {
                    output = new MessageDataOutput();
                    output.write("MAC", this.getMAC());
                    output.write("COMMAND_ENABLED", true);
                    output.write("COMMAND", "connect");
                    output.write("ARGUMENT", this.client_name);
                    if (!StringUtils.isNullOrEmpty(this.key)) {
                        output.write("ACCESS_KEY", this.key);
                    }
                    compile = output.compile();
                    writer = new PrintWriter(this.socket.getOutputStream());
                    writer.println(new String(compile, StandardCharsets.UTF_8));
                    writer.flush();
                }
                if (this.operative || this.socket == null || !(input = new MessageDataInput((readBuffer = ByteBuffer.wrap((reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8))).readLine().getBytes(StandardCharsets.UTF_8))).array())).getBoolean("COMMAND_ENABLED")) continue;
                sequence = input.getString("COMMAND");
                mac = input.getString("MAC");
                if (sequence == null || mac == null) continue;
                if (sequence.equalsIgnoreCase("accept")) {
                    this.remote = new SSLRemoteServer(mac, InetAddress.getByName(this.server), this.sv_port, this.socket);
                    if (this.debug) {
                        this.console.send((CharSequence)"Connection has been validated by the server", Level.OK);
                    }
                    for (byte[] data : this.data_queue) {
                        tmp = ByteBuffer.wrap(data);
                        this.socket.getChannel().write(tmp);
                        this.data_queue.remove(data);
                    }
                    this.award_connection = false;
                    this.operative = true;
                    this.fullyConnected = true;
                    event /* !! */  = new ServerConnectEvent(this.remote, this);
                    RemoteListener.callClientEvent(event /* !! */ );
                    continue;
                }
                argument = input.getString("ARGUMENT");
                if (argument == null || !argument.equalsIgnoreCase("connect")) continue;
                this.instant_close = true;
                result.complete(false);
                reason = input.getString("COMMAND_ARGUMENT");
                if (reason == null) continue;
                this.console.send((CharSequence)"Connection has been declined by the server ({0})", Level.GRAVE, new Object[]{reason});
            }
        }
        result.complete(true);
lbl102:
        // 9 sources

        try {
            block52: while (this.operative != false) {
                block68: {
                    if (this.socket == null) continue;
                    if (!this.data_queue.isEmpty()) {
                        ex = this.data_queue.iterator();
                        while (true) {
                            if (!ex.hasNext()) continue block52;
                            waiting = ex.next();
                            writer = new PrintWriter(this.socket.getOutputStream());
                            writer.println(new String(waiting, StandardCharsets.UTF_8));
                            writer.flush();
                            this.data_queue.remove(waiting);
                        }
                    }
                    if (this.remote == null) continue;
                    reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8));
                    readBuffer = ByteBuffer.wrap(reader.readLine().getBytes(StandardCharsets.UTF_8));
                    input = new MessageDataInput(readBuffer.array());
                    mac = input.getString("MAC");
                    isCommand = input.getBoolean("COMMAND_ENABLED");
                    if (!this.remote.getMAC().equals(mac)) continue;
                    if (!isCommand) break block68;
                    command = input.getString("COMMAND");
                    argument = input.getString("ARGUMENT");
                    if (command == null || argument == null) continue;
                    var10_17 = command.toLowerCase();
                    var11_19 = -1;
                    switch (var10_17.hashCode()) {
                        case -1867169789: {
                            if (!var10_17.equals("success")) break;
                            var11_19 = 0;
                            break;
                        }
                        case -1281977283: {
                            if (!var10_17.equals("failed")) break;
                            var11_19 = 1;
                            break;
                        }
                        case 530405532: {
                            if (!var10_17.equals("disconnect")) break;
                            var11_19 = 2;
                            break;
                        }
                        case 99162322: {
                            if (!var10_17.equals("hello")) break;
                            var11_19 = 3;
                            break;
                        }
                    }
                    switch (var11_19) {
                        case 0: {
                            keyManagers = argument.toLowerCase();
                            ssf = -1;
                            switch (keyManagers.hashCode()) {
                                case -934594754: {
                                    if (!keyManagers.equals("rename")) break;
                                    ssf = 0;
                                    break;
                                }
                                case 954925063: {
                                    if (!keyManagers.equals("message")) break;
                                    ssf = 1;
                                    break;
                                }
                                case -284840886: {
                                    if (!keyManagers.equals("unknown")) break;
                                    ssf = 2;
                                    break;
                                }
                            }
                            switch (ssf) {
                                case 0: {
                                    this.client_name = input.getString("ARGUMENT_DATA");
                                    if (this.client_name == null || !this.debug) continue block52;
                                    this.console.send((CharSequence)"Server accepted the new client name: {0}", Level.OK, new Object[]{this.client_name});
                                    ** GOTO lbl102
                                }
                                case 1: {
                                    data = input.getString("ARGUMENT_DATA");
                                    if (data == null || !this.debug) continue block52;
                                    this.console.send((CharSequence)"{0} to server: {1}", Level.INFO, new Object[]{data, new String(readBuffer.array())});
                                    ** GOTO lbl102
                                }
                                case 2: {
                                    data = input.getString("ARGUMENT_DATA");
                                    if (data == null || !this.debug) continue block52;
                                    arg_data = data.split(",");
                                    this.console.send((CharSequence)"{0} ran custom command: {1} ( {2} )", Level.WARNING, new Object[]{arg_data[0], arg_data[1], arg_data[2]});
                                    ** GOTO lbl102
                                }
                            }
                            if (!this.debug) continue block52;
                            this.console.send((CharSequence)"Unknown command from server: {0} ( {1} )", Level.GRAVE, new Object[]{command, argument});
                            continue block52;
                        }
                        case 1: {
                            keyManagers = argument.toLowerCase();
                            ssf = -1;
                            switch (keyManagers.hashCode()) {
                                case 951351530: {
                                    if (!keyManagers.equals("connect")) break;
                                    ssf = 0;
                                    break;
                                }
                                case -934594754: {
                                    if (!keyManagers.equals("rename")) break;
                                    ssf = 1;
                                    break;
                                }
                                case 530405532: {
                                    if (!keyManagers.equals("disconnect")) break;
                                    ssf = 2;
                                    break;
                                }
                                case 954925063: {
                                    if (!keyManagers.equals("message")) break;
                                    ssf = 3;
                                    break;
                                }
                                case -284840886: {
                                    if (!keyManagers.equals("unknown")) break;
                                    ssf = 4;
                                    break;
                                }
                            }
                            switch (ssf) {
                                case 0: {
                                    data = input.getString("ARGUMENT_DATA");
                                    if (data == null) continue block52;
                                    connect_data = data.split(",");
                                    name = connect_data[0];
                                    reason = connect_data[1];
                                    this.console.send((CharSequence)"Server declined connection as {0}, because: {1}", Level.GRAVE, new Object[]{name, reason});
                                    connectEvent = new ServerDisconnectEvent(this.remote, this, reason);
                                    RemoteListener.callClientEvent(connectEvent);
                                    ** GOTO lbl102
                                }
                                case 1: {
                                    data = input.getString("ARGUMENT_DATA");
                                    if (data == null) continue block52;
                                    rename_data = data.split(",");
                                    this.console.send((CharSequence)"Failed to change client name to {0}: {1}", Level.GRAVE, new Object[]{rename_data[0], rename_data[1]});
                                    ** GOTO lbl102
                                }
                                case 2: {
                                    data = input.getString("ARGUMENT_DATA");
                                    if (data == null) continue block52;
                                    this.console.send((CharSequence)"Failed while trying to disconnect the server ( you've been disconnected anyway ): {0}", Level.GRAVE, new Object[]{data});
                                    disconnectEvent = new ServerDisconnectEvent(this.remote, this, "no server reason...");
                                    RemoteListener.callClientEvent(disconnectEvent);
                                    ** GOTO lbl102
                                }
                                case 3: {
                                    data = input.getString("ARGUMENT_DATA");
                                    if (data == null) continue block52;
                                    this.console.send((CharSequence)"Failed while trying to send a message to server: {0}", Level.GRAVE, new Object[]{data});
                                    ** GOTO lbl102
                                }
                                case 4: {
                                    data = input.getString("ARGUMENT_DATA");
                                    if (data == null) continue block52;
                                    unknown_data = data.split(",");
                                    this.console.send((CharSequence)"Failed while trying to execute custom command {0} with argument {1}: {2}", Level.GRAVE, new Object[]{unknown_data[0], unknown_data[1], unknown_data[2]});
                                    ** GOTO lbl102
                                }
                            }
                            if (!this.debug) continue block52;
                            this.console.send((CharSequence)"Unknown command from server: {0} ( {1} )", Level.WARNING, new Object[]{command, argument});
                            continue block52;
                        }
                        case 2: {
                            reason = input.getString("ARGUMENT_DATA");
                            if (reason != null) {
                                this.console.send((CharSequence)"Connection killed by server: {0}", Level.GRAVE, new Object[]{reason});
                            }
                            event = new ServerDisconnectEvent(this.remote, this, reason);
                            RemoteListener.callClientEvent(event);
                            this.operative = false;
                            this.award_connection = false;
                            this.tryingConnect = true;
                            this.socket.close();
                            this.socket = null;
                            this.disconnecting = false;
                            break;
                        }
                        case 3: {
                            this.fullyConnected = true;
                            this.preventStatusChange = true;
                            continue block52;
                        }
                    }
                    continue;
                }
                event /* !! */  = new ServerMessageEvent(this.remote, this, input);
                RemoteListener.callClientEvent(event /* !! */ );
            }
            return;
        }
        catch (Throwable ex) {
            if (!ex.getMessage().equals("Connection reset")) {
                ex.printStackTrace();
                return;
            }
            this.operative = false;
            this.award_connection = false;
            this.tryingConnect = true;
            try {
                this.socket.close();
            }
            catch (Throwable var3_9) {
                // empty catch block
            }
            this.socket = null;
            this.disconnecting = false;
            this.console.send((CharSequence)"Connection killed by server: Server disconnected unexpectedly", Level.GRAVE);
            return;
        }
    }
}

