/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.ssl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import ml.karmaconfigs.remote.messaging.karmaapi.common.Console;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.ConcurrentList;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.PathUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.listener.RemoteListener;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientCommandEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientConnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientDisconnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientMessageEvent;
import ml.karmaconfigs.remote.messaging.platform.SecureServer;
import ml.karmaconfigs.remote.messaging.remote.RemoteClient;
import ml.karmaconfigs.remote.messaging.util.DisconnectReason;
import ml.karmaconfigs.remote.messaging.util.WorkLevel;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataOutput;
import ml.karmaconfigs.remote.messaging.util.message.MessageInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.worker.ssl.remote.SSLRemoteClient;

public final class SSLServer
extends SecureServer {
    private final List<MessageInput> queue = new ConcurrentList<MessageInput>();
    private final Map<String, RemoteClient> clients = new ConcurrentHashMap<String, RemoteClient>();
    private final Map<Socket, String> connections = new ConcurrentHashMap<Socket, String>();
    private final Set<String> banned = Collections.newSetFromMap(new ConcurrentHashMap());
    private String server = "127.0.0.1";
    private int sv_port = 49305;
    private boolean debug = false;
    private boolean operative = false;
    private SSLServerSocket socket;
    private int processed = 0;
    private String key = "";
    private final Console console = new Console(this);
    private final String password;
    private final String name;
    private final String extension;
    private final String type;
    private String protocol = "TLSv1.3";
    private int max_connections = 50;
    private String[] protocols = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"};
    private String[] ciphers = new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
    private Path parent = this.getDataPath().resolve("certs");

    public SSLServer(String pwd, String nm, String ext, String tp) {
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[SSL Server (&aOK&3)]&b ");
        data.setInfoPrefix("&3[SSL Server (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[SSL Server (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[SSL Server (&4ERROR&3)]&b ");
        this.password = pwd;
        this.name = nm;
        this.extension = ext;
        this.type = tp;
    }

    public SSLServer(String pwd, String nm, String ext, String tp, int port) {
        this.sv_port = port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[SSL Server (&aOK&3)]&b ");
        data.setInfoPrefix("&3[SSL Server (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[SSL Server (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[SSL Server (&4ERROR&3)]&b ");
        this.password = pwd;
        this.name = nm;
        this.extension = ext;
        this.type = tp;
    }

    public SSLServer(String pwd, String nm, String ext, String tp, String host, int port) {
        this.server = host;
        this.sv_port = port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[SSL Server (&aOK&3)]&b ");
        data.setInfoPrefix("&3[SSL Server (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[SSL Server (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[SSL Server (&4ERROR&3)]&b ");
        this.password = pwd;
        this.name = nm;
        this.extension = ext;
        this.type = tp;
    }

    @Override
    public SecureServer debug(boolean status) {
        this.debug = status;
        return this;
    }

    @Override
    public SecureServer protocol(String p) {
        this.protocol = p;
        return this;
    }

    @Override
    public SecureServer maxConnections(int m) {
        this.max_connections = m;
        return this;
    }

    @Override
    public SecureServer allowedProtocol(String ... p) {
        this.protocols = p;
        return this;
    }

    @Override
    public SecureServer allowedCiphers(String ... c) {
        this.ciphers = c;
        return this;
    }

    @Override
    public SecureServer certsLocation(Path location) {
        this.parent = location;
        return this;
    }

    @Override
    public LateScheduler<Boolean> start() {
        if (!this.operative) {
            AsyncLateScheduler<Boolean> result = new AsyncLateScheduler<Boolean>();
            Thread thread = new Thread(() -> {
                try {
                    try {
                        if (!Files.exists(this.parent, new LinkOption[0])) {
                            Files.createDirectories(this.parent, new FileAttribute[0]);
                        }
                        Path serverKeyStore = this.parent.resolve(this.name + "." + this.extension);
                        Path trustedKeyStore = this.parent.resolve(this.name + "_trusted." + this.extension);
                        FileInputStream internalStorage = new FileInputStream(serverKeyStore.toFile());
                        FileInputStream internalTruster = new FileInputStream(trustedKeyStore.toFile());
                        KeyStore keyStore = KeyStore.getInstance(this.type);
                        keyStore.load(internalStorage, this.password.toCharArray());
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(keyStore, this.password.toCharArray());
                        KeyStore trustedStore = KeyStore.getInstance(this.type);
                        trustedStore.load(internalTruster, this.password.toCharArray());
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(trustedStore);
                        SSLContext sc = SSLContext.getInstance(this.protocol);
                        TrustManager[] trustManagers = tmf.getTrustManagers();
                        KeyManager[] keyManagers = kmf.getKeyManagers();
                        sc.init(keyManagers, trustManagers, new SecureRandom());
                        SSLServerSocketFactory ssf = sc.getServerSocketFactory();
                        this.socket = (SSLServerSocket)ssf.createServerSocket(this.sv_port, this.max_connections, InetAddress.getByName(this.server));
                        this.socket.setNeedClientAuth(true);
                        this.socket.setWantClientAuth(true);
                        this.socket.setEnabledProtocols(this.protocols);
                        this.socket.setEnabledCipherSuites(this.ciphers);
                        result.complete(true);
                    }
                    catch (Throwable ex) {
                        result.complete(false, ex);
                        return;
                    }
                    this.operative = true;
                    new Thread(this::lambda$null$0).start();
                    while (this.operative) {
                        try {
                            Socket channel = this.socket.accept();
                            if (channel == null) continue;
                            InetAddress incoming = channel.getInetAddress();
                            int port = channel.getPort();
                            String default_name = incoming.getHostAddress() + "/" + port;
                            this.connections.put(channel, default_name);
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
                catch (Throwable ex) {
                    result.complete(false);
                }
            });
            thread.start();
            return result;
        }
        return null;
    }

    @Override
    public LateScheduler<Boolean> start(String accessKey) {
        if (!this.operative) {
            this.key = accessKey;
            return this.start();
        }
        return null;
    }

    @Override
    public InetAddress getHost() {
        try {
            return InetAddress.getByName(this.server);
        }
        catch (Throwable throwable) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (Throwable ex) {
                return InetAddress.getLoopbackAddress();
            }
        }
    }

    @Override
    public String getMAC() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] macArray = network.getHardwareAddress();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < macArray.length; ++i) {
                str.append(String.format("%02X%s", macArray[i], i < macArray.length - 1 ? ":" : ""));
            }
            return str.toString();
        }
        catch (Throwable ex) {
            System.out.println("Failed to locate MAC address...");
            System.exit(1);
            return null;
        }
    }

    @Override
    public int getPort() {
        return this.sv_port;
    }

    @Override
    public boolean sendMessage(byte[] message) {
        return false;
    }

    @Override
    public Set<RemoteClient> getClients() {
        return new HashSet<RemoteClient>(this.clients.values());
    }

    @Override
    public WorkLevel getWorkLevel() {
        return WorkLevel.TCP;
    }

    @Override
    public void close() {
        this.operative = false;
        for (Socket connected : this.connections.keySet()) {
            try {
                MessageDataOutput output = new MessageDataOutput();
                ((MessageOutput)output).write("MAC", this.getMAC());
                ((MessageOutput)output).write("COMMAND_ENABLED", true);
                ((MessageOutput)output).write("COMMAND", "DISCONNECT");
                ((MessageOutput)output).write("ARGUMENT", "DISCONNECT");
                ((MessageOutput)output).write("ARGUMENT_DATA", "Server closed");
                byte[] compile = ((MessageOutput)output).compile();
                PrintWriter writer = new PrintWriter(connected.getOutputStream());
                writer.println(new String(compile, StandardCharsets.UTF_8));
                writer.flush();
            }
            catch (Throwable throwable) {}
        }
        this.connections.clear();
        try {
            this.socket.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void exportBans(Path destination) {
        try {
            PathUtilities.create(destination);
            String serialized = StringUtils.serialize(new ArrayList<String>(this.banned));
            Files.write(destination, serialized.getBytes(), StandardOpenOption.CREATE);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void loadBans(Path bans) {
        try {
            PathUtilities.create(bans);
            byte[] result = Files.readAllBytes(bans);
            Object serialized = StringUtils.load(new String(result));
            if (serialized instanceof ArrayList) {
                ArrayList list = (ArrayList)serialized;
                for (Object obj : list) {
                    this.ban(String.valueOf(obj));
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void broadcast(MessageOutput data) {
        int max = this.queue.size();
        int expected = this.processed + max;
        new Thread(() -> {
            long wait = 0L;
            while (this.processed < expected) {
                ++wait;
            }
            if (this.debug) {
                long sec = TimeUnit.MILLISECONDS.toSeconds(wait);
                this.console.send((CharSequence)"Sent message to everyone after {0} {1}", Level.OK, sec > 0L ? sec : wait, sec > 0L ? "seconds" : "ms");
            }
            for (RemoteClient client : this.clients.values()) {
                client.sendMessage(data);
            }
        }).start();
    }

    @Override
    public void redirect(String name, MessageOutput data) {
        int max = this.queue.size();
        int expected = this.processed + max;
        new Thread(() -> {
            long wait = 0L;
            while (this.processed < expected) {
                ++wait;
            }
            for (RemoteClient client : this.clients.values()) {
                if (!client.getName().equals(name) && !client.getMAC().equals(name)) continue;
                client.sendMessage(data);
                if (!this.debug) continue;
                long sec = TimeUnit.MILLISECONDS.toSeconds(wait);
                this.console.send((CharSequence)"Sent message to {0} after {1} {2}", Level.OK, name, sec > 0L ? sec : wait, sec > 0L ? "seconds" : "ms");
            }
        }).start();
    }

    @Override
    public void ban(String ... macAddresses) {
        this.banned.addAll(Arrays.asList(macAddresses));
        for (RemoteClient client : this.clients.values()) {
            if (!this.banned.contains(client.getMAC())) continue;
            MessageDataOutput output = new MessageDataOutput();
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", true);
            ((MessageOutput)output).write("COMMAND", "DISCONNECT");
            ((MessageOutput)output).write("ARGUMENT", "DISCONNECT");
            ((MessageOutput)output).write("ARGUMENT_DATA", "You have been banned from this server!");
            client.sendMessage(output);
        }
    }

    @Override
    public void kick(String ... macAddresses) {
        List<String> macs = Arrays.asList(macAddresses);
        for (RemoteClient client : this.clients.values()) {
            if (!macs.contains(client.getMAC())) continue;
            MessageDataOutput output = new MessageDataOutput();
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", true);
            ((MessageOutput)output).write("COMMAND", "DISCONNECT");
            ((MessageOutput)output).write("ARGUMENT", "DISCONNECT");
            ((MessageOutput)output).write("ARGUMENT_DATA", "You have been kicked from this server!");
            client.sendMessage(output);
        }
    }

    @Override
    public void unBan(String ... macAddresses) {
        Arrays.asList(macAddresses).forEach(this.banned::remove);
    }

    private RemoteClient getClient(String name, String mac, InetAddress address, int port, Socket socket) {
        RemoteClient client = this.clients.getOrDefault(address.getHostAddress() + "/" + port, null);
        if (client == null) {
            client = new SSLRemoteClient(name, mac, address, port, socket);
            this.clients.put(address.getHostAddress() + "/" + port, client);
        }
        return client;
    }

    @Override
    public String name() {
        return "SSL Server";
    }

    @Override
    public String version() {
        return "0";
    }

    @Override
    public String description() {
        return "TCP server to allow TCP Clients from RemoteMessaging API connect";
    }

    @Override
    public String[] authors() {
        return new String[]{"KarmaDev"};
    }

    @Override
    public String updateURL() {
        return null;
    }

    @Override
    public Console console() {
        return this.console;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private /* synthetic */ void lambda$null$0() {
        while (this.operative) {
            for (Socket channel : this.connections.keySet()) {
                if (!channel.isConnected() || channel.isClosed()) continue;
                try {
                    block36: {
                        block35: {
                            reader = new BufferedReader(new InputStreamReader(channel.getInputStream(), StandardCharsets.UTF_8));
                            BUFFER = ByteBuffer.wrap(reader.readLine().getBytes(StandardCharsets.UTF_8));
                            incoming = channel.getInetAddress();
                            port = channel.getPort();
                            default_name = incoming.getHostAddress() + "/" + port;
                            designated_name = this.connections.get(channel);
                            input = new MessageDataInput(BUFFER.array());
                            if (!this.queue.isEmpty()) {
                                this.queue.add(input);
                                input = this.queue.get(0);
                            }
                            mac = input.getString("MAC");
                            client = this.getClient(default_name, mac, incoming, port, channel);
                            if (!input.getBoolean("COMMAND_ENABLED")) break block35;
                            command = input.getString("COMMAND");
                            argument = input.getString("ARGUMENT");
                            if (command == null || argument == null) break block36;
                            var14_16 = command.toLowerCase();
                            var15_17 = -1;
                            switch (var14_16.hashCode()) {
                                case 951351530: {
                                    if (!var14_16.equals("connect")) break;
                                    var15_17 = 0;
                                    break;
                                }
                                case -934594754: {
                                    if (!var14_16.equals("rename")) break;
                                    var15_17 = 1;
                                    break;
                                }
                                case 530405532: {
                                    if (!var14_16.equals("disconnect")) break;
                                    var15_17 = 2;
                                    break;
                                }
                                case 99162322: {
                                    if (!var14_16.equals("hello")) break;
                                    var15_17 = 3;
                                }
                            }
                            switch (var15_17) {
                                case 0: {
                                    sendDecline = true;
                                    validKey = true;
                                    if (!this.banned.contains(mac)) {
                                        if (!StringUtils.isNullOrEmpty(this.key)) {
                                            provided = input.getString("ACCESS_KEY");
                                            validKey = provided != null ? provided.equals(this.key) : false;
                                        }
                                        if (validKey) {
                                            sendDecline = false;
                                            if (this.debug) {
                                                this.console.send((CharSequence)"Client {0} connected as {1}", Level.OK, new Object[]{default_name, argument});
                                            }
                                            client = new SSLRemoteClient(argument, mac, incoming, port, channel);
                                            this.clients.put(default_name, client);
                                            this.connections.put(channel, default_name);
                                            event /* !! */  = new ClientConnectEvent(client, this);
                                            RemoteListener.callServerEvent(event /* !! */ );
                                            output = new MessageDataOutput();
                                            output.write("MAC", this.getMAC());
                                            output.write("COMMAND_ENABLED", true);
                                            output.write("COMMAND", "accept");
                                            compile = output.compile();
                                            writer = new PrintWriter(channel.getOutputStream());
                                            writer.println(new String(compile, StandardCharsets.UTF_8));
                                            writer.flush();
                                        }
                                    }
                                    if (sendDecline) {
                                        output = new MessageDataOutput();
                                        output.write("MAC", this.getMAC());
                                        output.write("COMMAND_ENABLED", true);
                                        output.write("COMMAND", "decline");
                                        output.write("ARGUMENT", "connect");
                                        output.write("COMMAND_ARGUMENT", validKey != false ? "You are banned from this server!" : "The provided access key is not valid for this server!");
                                        compile = output.compile();
                                        writer = new PrintWriter(channel.getOutputStream());
                                        writer.println(new String(compile, StandardCharsets.UTF_8));
                                        writer.flush();
                                        this.connections.remove(channel);
                                        ** break;
                                    }
                                    break block36;
                                }
                                case 1: {
                                    if (this.connections.containsValue(default_name) || this.connections.containsValue(designated_name)) {
                                        if (!this.connections.containsValue(argument)) {
                                            if (this.debug) {
                                                this.console.send((CharSequence)"Client {0} is now known as {1}", Level.WARNING, new Object[]{client.getName(), argument});
                                            }
                                            client = new SSLRemoteClient(argument, mac, incoming, port, channel);
                                            this.clients.put(default_name, client);
                                            this.connections.put(channel, argument);
                                            event /* !! */  = new ClientCommandEvent(client, this, command, argument);
                                            RemoteListener.callServerEvent(event /* !! */ );
                                            output = new MessageDataOutput();
                                            output.write("MAC", this.getMAC());
                                            output.write("COMMAND_ENABLED", true);
                                            output.write("COMMAND", "success");
                                            output.write("ARGUMENT", "rename");
                                            output.write("ARGUMENT_DATA", argument);
                                            compile = output.compile();
                                            writer = new PrintWriter(channel.getOutputStream());
                                            writer.println(new String(compile, StandardCharsets.UTF_8));
                                            writer.flush();
                                            ** break;
                                        }
                                        output = new MessageDataOutput();
                                        output.write("MAC", this.getMAC());
                                        output.write("COMMAND_ENABLED", true);
                                        output.write("COMMAND", "failed");
                                        output.write("ARGUMENT", "rename");
                                        output.write("ARGUMENT_DATA", argument + ",A client with that name already exists!");
                                        compile = output.compile();
                                        writer = new PrintWriter(channel.getOutputStream());
                                        writer.println(new String(compile, StandardCharsets.UTF_8));
                                        writer.flush();
                                        ** break;
                                    }
                                    output = new MessageDataOutput();
                                    output.write("MAC", this.getMAC());
                                    output.write("COMMAND_ENABLED", true);
                                    output.write("COMMAND", "failed");
                                    output.write("ARGUMENT", "rename");
                                    output.write("ARGUMENT_DATA", argument + ",You are not connected to this server!");
                                    compile = output.compile();
                                    writer = new PrintWriter(channel.getOutputStream());
                                    writer.println(new String(compile, StandardCharsets.UTF_8));
                                    writer.flush();
                                    ** break;
                                }
                                case 2: {
                                    if (this.connections.containsValue(default_name) || this.connections.containsValue(designated_name)) {
                                        if (this.debug) {
                                            this.console.send((CharSequence)"Client {0} left the server ( {1} )", Level.WARNING, new Object[]{client.getName(), argument});
                                        }
                                        output = new MessageDataOutput();
                                        output.write("MAC", this.getMAC());
                                        output.write("COMMAND_ENABLED", true);
                                        output.write("COMMAND", "DISCONNECT");
                                        output.write("ARGUMENT", "DISCONNECT");
                                        output.write("ARGUMENT_DATA", "Disconnect requested by client");
                                        compile = output.compile();
                                        writer = new PrintWriter(channel.getOutputStream());
                                        writer.println(new String(compile, StandardCharsets.UTF_8));
                                        writer.flush();
                                        this.clients.remove(default_name);
                                        this.connections.remove(channel);
                                        event = new ClientDisconnectEvent(client, this, DisconnectReason.KILLED_BY_CLIENT, argument);
                                        RemoteListener.callServerEvent(event);
                                        ** break;
                                    }
                                    output = new MessageDataOutput();
                                    output.write("MAC", this.getMAC());
                                    output.write("COMMAND_ENABLED", true);
                                    output.write("COMMAND", "failed");
                                    output.write("ARGUMENT", "disconnect");
                                    output.write("ARGUMENT_DATA", "You are not connected to this server!");
                                    compile = output.compile();
                                    writer = new PrintWriter(channel.getOutputStream());
                                    writer.println(new String(compile, StandardCharsets.UTF_8));
                                    writer.flush();
                                    ** break;
                                }
                                case 3: {
                                    if (this.connections.containsValue(default_name) || this.connections.containsValue(designated_name)) {
                                        output = new MessageDataOutput();
                                        output.write("MAC", this.getMAC());
                                        output.write("COMMAND_ENABLED", true);
                                        output.write("COMMAND", "HELLO");
                                        output.write("ARGUMENT", "");
                                        compile = output.compile();
                                        writer = new PrintWriter(channel.getOutputStream());
                                        writer.println(new String(compile, StandardCharsets.UTF_8));
                                        writer.flush();
                                        ** break;
                                    }
                                    break block36;
                                }
                                default: {
                                    if (this.connections.containsValue(default_name) || this.connections.containsValue(designated_name)) {
                                        if (this.debug) {
                                            this.console.send((CharSequence)"Unknown command from {0}: {1} ( {2} )", Level.WARNING, new Object[]{client.getName(), command, argument});
                                        }
                                        event /* !! */  = new ClientCommandEvent(client, this, command, argument);
                                        RemoteListener.callServerEvent(event /* !! */ );
                                        ** break;
                                    }
                                    output = new MessageDataOutput();
                                    output.write("MAC", this.getMAC());
                                    output.write("COMMAND_ENABLED", true);
                                    output.write("COMMAND", "failed");
                                    output.write("ARGUMENT", "unknown");
                                    output.write("ARGUMENT_DATA", command + "," + argument + ",You are not connected to this server!");
                                    compile = output.compile();
                                    writer = new PrintWriter(channel.getOutputStream());
                                    writer.println(new String(compile, StandardCharsets.UTF_8));
                                    writer.flush();
                                }
                            }
lbl190:
                            // 9 sources

                            break block36;
                        }
                        if (this.connections.containsValue(default_name) || this.connections.containsValue(designated_name)) {
                            output = new MessageDataOutput();
                            output.write("MAC", this.getMAC());
                            output.write("COMMAND_ENABLED", true);
                            output.write("COMMAND", "success");
                            output.write("ARGUMENT", "message");
                            output.write("ARGUMENT_DATA", client.getName());
                            compile = output.compile();
                            writer = new PrintWriter(channel.getOutputStream());
                            writer.println(new String(compile, StandardCharsets.UTF_8));
                            writer.flush();
                            event = new ClientMessageEvent(client, this, input);
                            RemoteListener.callServerEvent(event);
                        } else {
                            if (this.debug) {
                                this.console.send((CharSequence)"Denying message from {0} because he's not connected to server", Level.INFO, new Object[]{default_name});
                            }
                            output = new MessageDataOutput();
                            output.write("MAC", this.getMAC());
                            output.write("COMMAND_ENABLED", true);
                            output.write("COMMAND", "failed");
                            output.write("ARGUMENT", "message");
                            output.write("ARGUMENT_DATA", "You are not connected to this server!");
                            compile = output.compile();
                            writer = new PrintWriter(channel.getOutputStream());
                            writer.println(new String(compile, StandardCharsets.UTF_8));
                            writer.flush();
                        }
                    }
                    ++this.processed;
                }
                catch (Throwable ex) {
                    name = this.connections.remove(channel);
                    for (String default_name : this.clients.keySet()) {
                        client = this.clients.getOrDefault(default_name, null);
                        if (client == null) {
                            this.clients.remove(default_name);
                            continue;
                        }
                        if (!client.getName().equals(name)) continue;
                        this.clients.remove(default_name);
                        if (!this.debug) continue;
                        this.console.send((CharSequence)"Client {0} left the server ( {1} )", Level.WARNING, new Object[]{client.getName(), "Internal server error occurred [The client may have disconnected from the server]"});
                    }
                }
            }
        }
    }
}

