/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.assembler;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.core.Component;
import org.burningwave.core.Executable;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ByteCodeHunter;
import org.burningwave.core.classes.ClassFactory;
import org.burningwave.core.classes.ClassHunter;
import org.burningwave.core.classes.ClassPathHelper;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.ClassPathScanner;
import org.burningwave.core.classes.CodeExecutor;
import org.burningwave.core.classes.ExecuteConfig;
import org.burningwave.core.classes.FunctionalInterfaceFactory;
import org.burningwave.core.classes.JavaMemoryCompiler;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchResult;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.Properties;

public class ComponentContainer
implements ComponentSupplier,
Properties.Listener {
    private static Collection<ComponentContainer> instances = ConcurrentHashMap.newKeySet();
    private Map<Class<?>, Component> components;
    private Supplier<Map<?, ?>> propertySupplier;
    private org.burningwave.core.iterable.Properties config;
    private boolean isUndestroyable;
    private Consumer<ComponentContainer> preAfterInitCall;
    private QueuedTaskExecutor.Task afterInitTask;
    private String instanceId = this.getId();

    ComponentContainer(Supplier<Map<?, ?>> propertySupplier) {
        this.propertySupplier = propertySupplier;
        this.config = new org.burningwave.core.iterable.Properties();
        this.checkAndListenTo(StaticComponentContainer.GlobalProperties);
        this.checkAndListenTo(this.config);
        instances.add(this);
    }

    public static final ComponentContainer create(String configFileName) {
        try {
            return new ComponentContainer(() -> {
                try {
                    HashSet<java.lang.ClassLoader> classLoaders = new HashSet<java.lang.ClassLoader>();
                    classLoaders.add(ComponentContainer.class.getClassLoader());
                    classLoaders.add(Thread.currentThread().getContextClassLoader());
                    Properties config = io.github.toolfactory.jvm.util.Properties.loadFromResourcesAndMerge(configFileName, "priority-of-this-configuration", classLoaders, !Configuration.Default.ADDITIONAL_VALUES.isEmpty() ? Configuration.Default.ADDITIONAL_VALUES.toArray(new Map[Configuration.Default.ADDITIONAL_VALUES.size()]) : null);
                    if (config.isEmpty()) {
                        StaticComponentContainer.ManagedLoggerRepository.logInfo(ComponentContainer.class::getName, "No custom properties found for file {}", configFileName);
                    }
                    return config;
                }
                catch (Throwable exc) {
                    return (Map)StaticComponentContainer.Driver.throwException(exc);
                }
            }).init();
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggerRepository.logError(() -> ComponentContainer.class.getName(), "Exception while creating  " + ComponentContainer.class.getSimpleName(), exc);
            return (ComponentContainer)StaticComponentContainer.Driver.throwException(exc);
        }
    }

    public static final ComponentContainer create(Map<?, ?> properties) {
        try {
            return new ComponentContainer(() -> {
                try {
                    Map[] configurations = !Configuration.Default.ADDITIONAL_VALUES.isEmpty() ? Configuration.Default.ADDITIONAL_VALUES.toArray(new Map[Configuration.Default.ADDITIONAL_VALUES.size() + 1]) : new Map[1];
                    configurations[configurations.length - 1] = properties;
                    return io.github.toolfactory.jvm.util.Properties.loadFromResourcesAndMerge("///", "priority-of-this-configuration", null, configurations);
                }
                catch (IOException | ParseException exc) {
                    return (Map)StaticComponentContainer.Driver.throwException(exc);
                }
            }).init();
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggerRepository.logError(() -> ComponentContainer.class.getName(), "Exception while creating  " + ComponentContainer.class.getSimpleName(), exc);
            return (ComponentContainer)StaticComponentContainer.Driver.throwException(exc);
        }
    }

    public static final ComponentContainer create() {
        return ComponentContainer.create((Map)null);
    }

    private ComponentContainer init() {
        this.components = null;
        org.burningwave.core.iterable.Properties config = new org.burningwave.core.iterable.Properties();
        TreeMap<String, Object> defaultProperties = new TreeMap<String, Object>();
        defaultProperties.putAll(Configuration.Default.VALUES);
        defaultProperties.putAll(CodeExecutor.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(PathHelper.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(JavaMemoryCompiler.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassFactory.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ByteCodeHunter.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassHunter.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassPathHunter.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassPathScanner.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassPathHelper.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(PathScannerClassLoader.Configuration.DEFAULT_VALUES);
        config.putAll(StaticComponentContainer.GlobalProperties);
        Optional.ofNullable(this.propertySupplier.get()).ifPresent(customConfig -> config.putAll(customConfig));
        for (Map.Entry defVal : defaultProperties.entrySet()) {
            config.putIfAbsent(defVal.getKey(), defVal.getValue());
        }
        StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> StaticComponentContainer.IterableObjectHelper.refresh(this.config, config));
        this.logConfigProperties();
        return this;
    }

    private ComponentContainer setAndlaunchAfterInitTask() {
        if (this.config.getProperty("component-container.after-init.operations") != null) {
            StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
                this.afterInitTask = (QueuedTaskExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(task -> {
                    Collection tasks;
                    if (this.preAfterInitCall != null) {
                        this.preAfterInitCall.accept(this);
                    }
                    if ((tasks = (Collection)this.resolveProperty(this.config, "component-container.after-init.operations", null)) != null) {
                        for (QueuedTaskExecutor.TaskAbst iteratedTask : tasks) {
                            iteratedTask.waitForFinish();
                        }
                    }
                    this.afterInitTask = null;
                }).submit();
            });
        }
        return this;
    }

    private Map<Class<?>, Component> checkAndInitComponentMapAndAfterInitTask() {
        if (this.components == null) {
            StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
                if (this.components == null) {
                    this.components = new ConcurrentHashMap();
                    this.setAndlaunchAfterInitTask();
                }
            });
        }
        return this.components;
    }

    public ComponentContainer waitForAfterInitTask() {
        if (!this.waitForAfterInitTaskIfNotNull()) {
            this.executeOnComponentMap((Map<Class<?>, Component> components) -> components.getClass());
            this.waitForAfterInitTaskIfNotNull();
        }
        return this;
    }

    private boolean waitForAfterInitTaskIfNotNull() {
        QueuedTaskExecutor.Task afterInitTask = this.afterInitTask;
        if (afterInitTask != null) {
            return afterInitTask.waitForFinish() != null;
        }
        return false;
    }

    public ComponentContainer preAfterInit(Consumer<ComponentContainer> preAfterInitCall) {
        this.preAfterInitCall = preAfterInitCall;
        return this;
    }

    public void logConfigProperties() {
        org.burningwave.core.iterable.Properties componentContainerConfig = new org.burningwave.core.iterable.Properties();
        componentContainerConfig.putAll(this.config);
        ((ConcurrentHashMap.KeySetView)componentContainerConfig.keySet()).removeAll((Collection)StaticComponentContainer.GlobalProperties.keySet());
        StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "\n\n\tConfiguration values for dynamic components:\n\n{}\n\n", componentContainerConfig.toPrettyString(2));
    }

    ComponentContainer markAsUndestroyable() {
        this.isUndestroyable = true;
        return this;
    }

    public void processChangeNotification(org.burningwave.core.iterable.Properties properties, Properties.Event event, Object key, Object newValue, Object oldValue) {
        this.executeOnComponentMap((Map<Class<?>, Component> components) -> {
            if (properties == StaticComponentContainer.GlobalProperties) {
                if (event.name().equals(Properties.Event.PUT.name())) {
                    this.config.put(key, newValue);
                } else if (event.name().equals(Properties.Event.REMOVE.name())) {
                    this.config.remove(key);
                }
            } else if (properties == this.config && event.name().equals(Properties.Event.PUT.name()) && key instanceof String) {
                ClassLoader pathScannerClassLoader;
                String keyAsString = (String)key;
                if (keyAsString.equals("path-scanner-class-loader.parent")) {
                    ClassLoader pathScannerClassLoader2 = (ClassLoader)components.get(ClassLoader.class);
                    if (pathScannerClassLoader2 != null) {
                        StaticComponentContainer.ClassLoaders.setAsParent(pathScannerClassLoader2, (java.lang.ClassLoader)this.resolveProperty(this.config, "path-scanner-class-loader.parent"));
                    }
                } else if (keyAsString.equals("path-scanner-class-loader.search-config.check-file-option") && (pathScannerClassLoader = (ClassLoader)components.get(ClassLoader.class)) != null) {
                    StaticComponentContainer.Fields.setDirect((Object)pathScannerClassLoader, "fileFilterAndProcessor", (Object)FileSystemItem.Criteria.forClassTypeFiles(StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("path-scanner-class-loader.search-config.check-file-option").on(this.config))));
                }
            }
        });
    }

    private String getMutexForComponentsId() {
        return this.instanceId + "_components";
    }

    public void reInit() {
        StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
            this.reset();
            this.init();
        });
    }

    public static ComponentContainer getInstance() {
        return Holder.getComponentContainerInstance();
    }

    public String getConfigProperty(String propertyName) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(propertyName).on(this.config));
    }

    public String getConfigProperty(String propertyName, Map<String, String> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(propertyName).on(this.config)).withDefaultValues(defaultValues));
    }

    public Object setConfigProperty(String propertyName, Object propertyValue) {
        return this.config.put(propertyName, propertyValue);
    }

    public Object removeConfigProperty(String propertyName) {
        return this.config.remove(propertyName);
    }

    @Override
    public <I, T extends Component> T getOrCreate(Class<I> cls, Supplier<I> componentSupplier) {
        return (T)this.executeOnComponentMap((Map<Class<?>, Component> components) -> {
            Component component = (Component)components.get(cls);
            if (component != null) {
                return component;
            }
            return StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId() + "_" + cls.getName(), () -> ComponentContainer.lambda$getOrCreate$12(components, cls, (Supplier)componentSupplier));
        });
    }

    private void executeOnComponentMap(Consumer<Map<Class<?>, Component>> executor) {
        Map<Class<?>, Component> components = this.components;
        try {
            executor.accept(components);
        }
        catch (NullPointerException exc) {
            if (components != null) {
                throw exc;
            }
            executor.accept(this.checkAndInitComponentMapAndAfterInitTask());
        }
    }

    private <T> T executeOnComponentMap(Function<Map<Class<?>, Component>, T> executor) {
        Map<Class<?>, Component> components = this.components;
        try {
            return executor.apply(components);
        }
        catch (NullPointerException exc) {
            if (components != null) {
                throw exc;
            }
            return executor.apply(this.checkAndInitComponentMapAndAfterInitTask());
        }
    }

    @Override
    public PathScannerClassLoader getPathScannerClassLoader() {
        return (PathScannerClassLoader)this.getOrCreate(ClassLoader.class, () -> new ClassLoader(this));
    }

    @Override
    public ClassFactory getClassFactory() {
        return (ClassFactory)this.getOrCreate(ClassFactory.class, () -> ClassFactory.create(this.getByteCodeHunter(), () -> this.getClassPathHunter(), this.getJavaMemoryCompiler(), this.getPathHelper(), this.getClassPathHelper(), () -> this.resolveProperty(this.config, "class-factory.default-class-loader"), this.config));
    }

    @Override
    public CodeExecutor getCodeExecutor() {
        return (CodeExecutor)this.getOrCreate(CodeExecutor.class, () -> CodeExecutor.create(() -> this.getClassFactory(), this.getPathHelper(), this.config));
    }

    @Override
    public JavaMemoryCompiler getJavaMemoryCompiler() {
        return (JavaMemoryCompiler)this.getOrCreate(JavaMemoryCompiler.class, () -> JavaMemoryCompiler.create(this.getPathHelper(), this.getClassPathHelper(), this.config));
    }

    @Override
    public ClassHunter getClassHunter() {
        return (ClassHunter)this.getOrCreate(ClassHunter.class, () -> ClassHunter.create(this.getPathHelper(), () -> this.resolveProperty(this.config, "class-hunter.default-path-scanner-class-loader"), this.config));
    }

    @Override
    public ClassPathHelper getClassPathHelper() {
        return (ClassPathHelper)this.getOrCreate(ClassPathHelper.class, () -> ClassPathHelper.create(this.getClassPathHunter(), this.config));
    }

    @Override
    public ClassPathHunter getClassPathHunter() {
        return (ClassPathHunter)this.getOrCreate(ClassPathHunter.class, () -> ClassPathHunter.create(this.getPathHelper(), () -> this.resolveProperty(this.config, "class-path-hunter.default-path-scanner-class-loader"), this.config));
    }

    @Override
    public ByteCodeHunter getByteCodeHunter() {
        return (ByteCodeHunter)this.getOrCreate(ByteCodeHunter.class, () -> ByteCodeHunter.create(this.getPathHelper(), () -> this.resolveProperty(this.config, "byte-code-hunter.default-path-scanner-class-loader"), this.config));
    }

    @Override
    public FunctionalInterfaceFactory getFunctionalInterfaceFactory() {
        return (FunctionalInterfaceFactory)this.getOrCreate(FunctionalInterfaceFactory.class, () -> FunctionalInterfaceFactory.create(this.getClassFactory()));
    }

    @Override
    public PathHelper getPathHelper() {
        return (PathHelper)this.getOrCreate(PathHelper.class, () -> PathHelper.create(this.config));
    }

    public <T> T resolveProperty(Map<?, ?> properties, String configKey) {
        return this.resolveProperty(properties, configKey, null);
    }

    public <T> T resolveProperty(Map<?, ?> properties, String configKey, Map<?, ?> defaultValues) {
        Object object = StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(configKey).on(this.config)).withDefaultValues(defaultValues));
        if (object instanceof String) {
            ExecuteConfig.ForProperties executeConfig = (ExecuteConfig.ForProperties)((ExecuteConfig.ForProperties)((ExecuteConfig.ForProperties)ExecuteConfig.fromDefaultProperties().setPropertyName(configKey).withParameter(this)).useAsParentClassLoader(StaticComponentContainer.Classes.getClassLoader(Executable.class))).setClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(new HashSet());
            if (defaultValues != null) {
                executeConfig.withDefaultPropertyValues(defaultValues);
            }
            return this.getCodeExecutor().execute(executeConfig);
        }
        if (object instanceof Function) {
            return (T)((Supplier<Object>)() -> ((Function)object).apply(this));
        }
        return object;
    }

    public ComponentContainer reset() {
        this.clear();
        return this.executeOnComponentMap((Map<Class<?>, Component> components) -> {
            this.waitForAfterInitTaskIfNotNull();
            StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
                this.components = new ConcurrentHashMap();
            });
            if (!components.isEmpty()) {
                StaticComponentContainer.BackgroundExecutor.createTask(task -> {
                    AtomicReference classLoaderWrapper = new AtomicReference();
                    StaticComponentContainer.IterableObjectHelper.deepClear(components, (type, component) -> {
                        if (!(component instanceof ClassLoader)) {
                            component.close();
                        } else {
                            classLoaderWrapper.set((ClassLoader)component);
                        }
                    });
                    ClassLoader classLoader = (ClassLoader)classLoaderWrapper.get();
                    if (classLoader != null) {
                        classLoader.unregister(this, true, true);
                    }
                }, 1).submit();
            }
            return this;
        });
    }

    public static void resetAll() {
        for (ComponentContainer componentContainer : instances) {
            try {
                componentContainer.reset();
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(ComponentContainer.class::getName, "Exception occurred while executing reset on {}", exc, componentContainer.toString());
            }
        }
    }

    void close(boolean force) {
        if (force || !this.isUndestroyable) {
            instances.remove(this);
            this.closeResources(() -> this.instanceId == null, task -> {
                this.checkAndUnregister(StaticComponentContainer.GlobalProperties);
                this.checkAndUnregister(this.config);
                this.reset();
                this.components = null;
                this.propertySupplier = null;
                this.config = null;
                this.instanceId = null;
            });
        } else {
            StaticComponentContainer.Driver.throwException("Could not close singleton instance {}", Holder.INSTANCE);
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    static void closeAll() {
        boolean clearCache = !instances.isEmpty();
        for (ComponentContainer componentContainer : instances) {
            try {
                componentContainer.close(true);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(() -> ComponentContainer.class.getName(), "Exception occurred while closing " + componentContainer, exc);
            }
        }
        if (clearCache) {
            StaticComponentContainer.Cache.clear(false, new Object[0]);
        }
    }

    @Override
    public void clear() {
        this.clear(true, true, true);
    }

    @Override
    public void clear(boolean closeHuntersResults, boolean closeClassRetrievers, boolean clearFileSystemItemReferences) {
        if (closeHuntersResults) {
            this.closeHuntersSearchResults();
        }
        this.resetClassFactory(closeClassRetrievers);
        if (!closeHuntersResults && !closeClassRetrievers) {
            this.waitForAfterInitTaskIfNotNull();
        }
        StaticComponentContainer.Cache.clear(true, StaticComponentContainer.Cache.pathForFileSystemItems);
        if (clearFileSystemItemReferences) {
            StaticComponentContainer.Cache.pathForFileSystemItems.iterateParallel((path, fileSystemItem) -> fileSystemItem.reset());
        }
    }

    public static void clearAll() {
        ComponentContainer.clearAll(true, true, true);
    }

    public static void clearAll(boolean closeHuntersResults, boolean closeClassRetrievers) {
        ComponentContainer.clearAll(closeHuntersResults, closeClassRetrievers, true);
    }

    public static synchronized void clearAll(boolean closeHuntersResults, boolean closeClassRetrievers, boolean clearFileSystemItemReferences) {
        for (ComponentContainer componentContainer : instances) {
            componentContainer.waitForAfterInitTaskIfNotNull();
            if (closeHuntersResults) {
                componentContainer.closeHuntersSearchResults();
            }
            componentContainer.resetClassFactory(closeClassRetrievers);
        }
        StaticComponentContainer.Cache.clear(true, StaticComponentContainer.Cache.pathForFileSystemItems);
        if (clearFileSystemItemReferences) {
            StaticComponentContainer.Cache.pathForFileSystemItems.iterateParallel((path, fileSystemItem) -> fileSystemItem.reset());
        }
    }

    @Override
    public void resetClassFactory(boolean closeClassRetrievers) {
        this.executeOnComponentMap((Map<Class<?>, Component> components) -> {
            this.waitForAfterInitTaskIfNotNull();
            ClassFactory classFactory = (ClassFactory)components.get(ClassFactory.class);
            if (classFactory != null) {
                classFactory.reset(closeClassRetrievers);
            }
        });
    }

    @Override
    public void closeHuntersSearchResults() {
        this.executeOnComponentMap((Map<Class<?>, Component> components) -> {
            this.waitForAfterInitTaskIfNotNull();
            ClassPathScanner.Abst hunter = (ClassPathScanner.Abst)components.get(ByteCodeHunter.class);
            if (hunter != null) {
                hunter.closeSearchResults();
            }
            if ((hunter = (ClassPathScanner.Abst)components.get(ClassHunter.class)) != null) {
                hunter.closeSearchResults();
            }
            if ((hunter = (ClassPathScanner.Abst)components.get(ClassPathHunter.class)) != null) {
                hunter.closeSearchResults();
            }
        });
    }

    public boolean isClosed() {
        return !instances.contains(this);
    }

    private static /* synthetic */ Component lambda$getOrCreate$12(Map components, Class cls, Supplier componentSupplier) {
        Component componentTemp = (Component)components.get(cls);
        if (componentTemp == null) {
            componentTemp = (Component)componentSupplier.get();
            components.put(cls, componentTemp);
        }
        return componentTemp;
    }

    public static class Configuration {

        public static class Default {
            private static Map<String, String> FILE_NAME;
            private static final Map<String, Object> VALUES;
            private static Collection<Map<?, ?>> ADDITIONAL_VALUES;

            public static void setFileName(String name) {
                if (name == null || name.isEmpty()) {
                    throw new IllegalArgumentException("The name of the configuration file cannot be empty");
                }
                try {
                    FILE_NAME.put("file-name", name);
                }
                catch (UnsupportedOperationException exc) {
                    throw new UnsupportedOperationException("Cannot set file name after that the " + StaticComponentContainer.class.getSimpleName() + " class has been initialized");
                }
            }

            public static void add(Map<?, ?> ... configurations) {
                if (configurations == null || configurations.length < 1) {
                    throw new IllegalArgumentException("Configuration map cannot be null");
                }
                for (Map<?, ?> configuration : configurations) {
                    if (configuration == null) {
                        throw new IllegalArgumentException("Configuration map cannot be null");
                    }
                    ADDITIONAL_VALUES.add(new LinkedHashMap(configuration));
                }
            }

            static {
                HashMap<String, String> defaultValues = new HashMap<String, String>();
                defaultValues.put("component-container.after-init.operations.imports", "${code-executor.common.imports}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "${" + "component-container.after-init.operations" + ".additional-imports}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + Arrays.class.getName() + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + SearchResult.class.getName() + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator());
                defaultValues.put("component-container.after-init.operations.executor.name", ComponentContainer.class.getPackage().getName() + ".AfterInitOperationsExecutor");
                FILE_NAME = new ConcurrentHashMap<String, String>();
                FILE_NAME.put("file-name", "burningwave.properties");
                VALUES = Collections.unmodifiableMap(defaultValues);
                ADDITIONAL_VALUES = ConcurrentHashMap.newKeySet();
            }
        }

        public static class Key {
            public static final String AFTER_INIT = "component-container.after-init.operations";
        }
    }

    private static class Holder {
        private static final ComponentContainer INSTANCE;

        private Holder() {
        }

        private static ComponentContainer getComponentContainerInstance() {
            return INSTANCE;
        }

        static {
            Configuration.Default.FILE_NAME = Collections.unmodifiableMap(Configuration.Default.FILE_NAME);
            INSTANCE = ComponentContainer.create((String)Configuration.Default.FILE_NAME.get("file-name")).markAsUndestroyable();
        }
    }

    private static class ClassLoader
    extends PathScannerClassLoader {
        private ComponentContainer componentContainer;
        private Map<Class<?>, Component> components;

        ClassLoader(ComponentContainer componentContainer) {
            super((java.lang.ClassLoader)componentContainer.resolveProperty(componentContainer.config, "path-scanner-class-loader.parent"), componentContainer.getPathHelper(), FileSystemItem.Criteria.forClassTypeFiles(StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("path-scanner-class-loader.search-config.check-file-option").on(componentContainer.config))));
            this.components = componentContainer.components;
            this.componentContainer = componentContainer;
            this.register(componentContainer);
        }

        @Override
        public synchronized boolean unregister(Object client, boolean close, boolean markAsCloseable) {
            boolean closeCalled = super.unregister(client, close, markAsCloseable);
            if (!(this.isClosed && closeCalled || !markAsCloseable)) {
                Map<Class<?>, Component> components = this.components;
                ComponentContainer componentContainer = this.componentContainer;
                if (components == null || componentContainer == null) {
                    if (!this.isClosed) {
                        throw new IllegalStateException(StaticComponentContainer.Strings.compile("components map is null but {} is not closed", this));
                    }
                    return this.isClosed;
                }
                closeCalled = StaticComponentContainer.Synchronizer.execute(componentContainer.getMutexForComponentsId(), () -> {
                    ClassLoader cL = (ClassLoader)components.remove(ClassLoader.class);
                    if (cL != null) {
                        if (cL != this) {
                            throw new IllegalStateException(StaticComponentContainer.Strings.compile("{} is not the same instance of {} in the components map", this, cL));
                        }
                        return super.unregister(componentContainer, close, markAsCloseable);
                    }
                    return false;
                });
            }
            return this.isClosed || closeCalled;
        }

        @Override
        protected QueuedTaskExecutor.Task closeResources() {
            return this.closeResources(ClassLoader.class.getName() + "@" + System.identityHashCode(this), () -> this.componentContainer == null, task -> {
                super.closeResources().waitForFinish();
                this.components = null;
                this.componentContainer = null;
                if (this.getClass().equals(ClassLoader.class)) {
                    StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "ClassLoader {} successfully closed", this);
                }
            });
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

