/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.burningwave.core.Closeable;
import org.burningwave.core.Identifiable;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.NullExecutableException;
import org.burningwave.core.concurrent.TaskStateException;
import org.burningwave.core.concurrent.TasksMonitorer;
import org.burningwave.core.concurrent.Thread;
import org.burningwave.core.function.Executor;
import org.burningwave.core.function.ThrowingBiPredicate;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.function.ThrowingFunction;
import org.burningwave.core.function.ThrowingRunnable;
import org.burningwave.core.function.ThrowingSupplier;
import org.burningwave.core.iterable.IterableObjectHelper;

public class QueuedTaskExecutor
implements Closeable {
    private static final Map<String, TaskAbst<?, ?>> runOnlyOnceTasks = new ConcurrentHashMap();
    private static final Map<java.lang.Thread, Collection<TaskAbst<?, ?>>> taskCreatorThreadsForChildTasks = new ConcurrentHashMap();
    Map<TaskAbst<?, ?>, TaskAbst<?, ?>> tasksInExecution;
    Thread.Supplier threadSupplier;
    String name;
    java.lang.Thread tasksLauncher;
    List<TaskAbst<?, ?>> tasksQueue;
    Boolean supended;
    volatile int defaultPriority;
    long executedTasksCount;
    volatile long executorsIndex;
    boolean isDaemon;
    Boolean terminated;
    Runnable initializer = () -> {
        this.threadSupplier = threadSupplier;
        this.tasksQueue = new CopyOnWriteArrayList<TaskAbst<?, ?>>(){
            private static final long serialVersionUID = -176528742161426076L;
            int min = 1500;
            int max = 2000;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean add(TaskAbst<?, ?> e) {
                while (this.size() > this.max) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        try {
                            this.wait();
                        }
                        catch (Throwable exc) {
                            StaticComponentContainer.Driver.throwException(exc);
                        }
                    }
                }
                return super.add(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean remove(Object task) {
                int size;
                boolean removed = super.remove(task);
                if (removed && (size = this.size()) > this.min && size < this.max) {
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        this.notifyAll();
                    }
                }
                return removed;
            }
        };
        this.tasksInExecution = new ConcurrentHashMap();
        this.resumeCallerMutex = new Object();
        this.executingFinishedWaiterMutex = new Object();
        this.suspensionCallerMutex = new Object();
        this.executableCollectionFillerMutex = new Object();
        this.terminatingMutex = new Object();
        this.name = name;
        this.defaultPriority = defaultPriority;
        this.isDaemon = isDaemon;
        this.init0();
    };
    boolean taskCreationTrackingEnabled;
    Object resumeCallerMutex;
    Object executingFinishedWaiterMutex;
    Object suspensionCallerMutex;
    Object executableCollectionFillerMutex;
    Object terminatingMutex;

    QueuedTaskExecutor(String name, Thread.Supplier threadSupplier, int defaultPriority, boolean isDaemon) {
        this.init();
    }

    void init() {
        this.initializer.run();
    }

    void init0() {
        this.supended = Boolean.FALSE;
        this.terminated = Boolean.FALSE;
        this.executedTasksCount = 0L;
        this.tasksLauncher = this.threadSupplier.createDetachedThread().setExecutable(thread -> {
            Object object;
            while (!this.terminated.booleanValue()) {
                TaskAbst<?, ?> task;
                if (this.checkAndNotifySuspension()) continue;
                if (!this.tasksQueue.isEmpty()) {
                    Iterator<TaskAbst<?, ?>> taskIterator = this.tasksQueue.iterator();
                    while (taskIterator.hasNext() && !this.checkAndNotifySuspension() && !this.terminated.booleanValue()) {
                        TaskAbst<?, ?> taskAbst = task = taskIterator.next();
                        synchronized (taskAbst) {
                            if (!this.tasksQueue.remove(task)) {
                                continue;
                            }
                        }
                        ((TaskAbst)task.setExecutor(this.threadSupplier.getOrCreateThread())).start();
                    }
                    continue;
                }
                object = this.executableCollectionFillerMutex;
                synchronized (object) {
                    if (this.tasksQueue.isEmpty()) {
                        try {
                            task = this.executingFinishedWaiterMutex;
                            synchronized (task) {
                                this.executingFinishedWaiterMutex.notifyAll();
                            }
                            if (!this.supended.booleanValue()) {
                                this.executableCollectionFillerMutex.wait();
                            }
                        }
                        catch (InterruptedException exc) {
                            StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                        }
                    }
                }
            }
            object = this.terminatingMutex;
            synchronized (object) {
                this.tasksLauncher = null;
                this.terminatingMutex.notifyAll();
            }
        });
        this.tasksLauncher.setName(this.name + " launcher");
        this.tasksLauncher.setPriority(this.defaultPriority);
        this.tasksLauncher.setDaemon(this.isDaemon);
        this.tasksLauncher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndNotifySuspension() {
        if (this.supended.booleanValue()) {
            Object object = this.resumeCallerMutex;
            synchronized (object) {
                Object object2 = this.suspensionCallerMutex;
                synchronized (object2) {
                    this.suspensionCallerMutex.notifyAll();
                }
                try {
                    this.resumeCallerMutex.wait();
                    return true;
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                }
            }
        }
        return false;
    }

    public static QueuedTaskExecutor create(String executorName, Thread.Supplier threadSupplier, int initialPriority) {
        return QueuedTaskExecutor.create(executorName, threadSupplier, initialPriority, false, false);
    }

    public static QueuedTaskExecutor create(String executorName, Thread.Supplier threadSupplier, int initialPriority, boolean daemon, boolean undestroyable) {
        if (undestroyable) {
            return new QueuedTaskExecutor(executorName, threadSupplier, initialPriority, daemon){
                StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                @Override
                public boolean shutDown(boolean waitForTasksTermination) {
                    if (StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                        return super.shutDown(waitForTasksTermination);
                    }
                    return false;
                }
            };
        }
        return new QueuedTaskExecutor(executorName, threadSupplier, initialPriority, daemon);
    }

    public QueuedTaskExecutor setTasksCreationTrackingFlag(boolean flag) {
        this.taskCreationTrackingEnabled = flag;
        return this;
    }

    public <T> ProducerTask<T> createProducerTask(ThrowingSupplier<T, ? extends Throwable> executable) {
        return this.createProducerTask((ProducerTask<T> task) -> executable.get());
    }

    public <T> ProducerTask<T> createProducerTask(ThrowingFunction<ProducerTask<T>, T, ? extends Throwable> executable) {
        Function<ThrowingFunction<ProducerTask<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>>, ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>, Throwable>, ProducerTask<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>>> taskCreator = this.getProducerTaskSupplier();
        ProducerTask<T> task = taskCreator.apply(executable);
        task.priority = this.defaultPriority;
        return task;
    }

    <T> Function<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>, ProducerTask<T>> getProducerTaskSupplier() {
        return executable -> new ProducerTask<T>((ThrowingFunction)executable, this.taskCreationTrackingEnabled){

            @Override
            QueuedTaskExecutor getQueuedTasksExecutor() {
                return QueuedTaskExecutor.this;
            }

            @Override
            QueuedTaskExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread thread) {
                return QueuedTaskExecutor.this;
            }
        };
    }

    public Task createTask(ThrowingRunnable<? extends Throwable> executable) {
        return this.createTask((Task task) -> executable.run());
    }

    public Task createTask(ThrowingConsumer<Task, ? extends Throwable> executable) {
        Task task = this.getTaskSupplier().apply(executable);
        task.priority = this.defaultPriority;
        return task;
    }

    <T> Function<ThrowingConsumer<Task, ? extends Throwable>, Task> getTaskSupplier() {
        return executable -> new Task((ThrowingConsumer)executable, this.taskCreationTrackingEnabled){

            @Override
            QueuedTaskExecutor getQueuedTasksExecutor() {
                return QueuedTaskExecutor.this;
            }

            @Override
            QueuedTaskExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread thread) {
                return QueuedTaskExecutor.this;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E, T extends TaskAbst<E, T>> T addToQueue(T task, boolean skipCheck) {
        Object[] canBeExecutedBag = null;
        if (skipCheck || ((Boolean)(canBeExecutedBag = this.canBeExecuted(task))[1]).booleanValue()) {
            try {
                task.creator = java.lang.Thread.currentThread();
                StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getId(task.creator), () -> {
                    Collection childrenTask = taskCreatorThreadsForChildTasks.computeIfAbsent(task.creator, key -> ConcurrentHashMap.newKeySet());
                    childrenTask.add(task);
                });
                this.tasksQueue.add(task);
                Object object = this.executableCollectionFillerMutex;
                synchronized (object) {
                    this.executableCollectionFillerMutex.notifyAll();
                }
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
            }
        }
        return (T)(canBeExecutedBag != null ? (TaskAbst)canBeExecutedBag[0] : task);
    }

    <E, T extends TaskAbst<E, T>> Object[] canBeExecuted(T task) {
        Object[] bag = new Object[]{task, true};
        if (task.runOnlyOnce) {
            bag[1] = task.hasBeenExecutedChecker.get() == false && Optional.ofNullable(runOnlyOnceTasks.putIfAbsent(task.id, task)).map(taskk -> {
                bag[0] = taskk;
                return false;
            }).orElseGet(() -> true) != false;
        }
        return bag;
    }

    public <E, T extends TaskAbst<E, T>> QueuedTaskExecutor waitFor(T task) {
        return this.waitFor(task, java.lang.Thread.currentThread().getPriority(), false);
    }

    public <E, T extends TaskAbst<E, T>> QueuedTaskExecutor waitFor(T task, boolean ignoreDeadLocked) {
        return this.waitFor(task, java.lang.Thread.currentThread().getPriority(), ignoreDeadLocked);
    }

    public <E, T extends TaskAbst<E, T>> QueuedTaskExecutor waitFor(T task, int priority, boolean ignoreDeadLocked) {
        this.changePriorityToAllTaskBeforeAndWaitThem(task, priority, ignoreDeadLocked);
        task.waitForFinish(ignoreDeadLocked, false);
        return this;
    }

    public QueuedTaskExecutor waitForTasksEnding() {
        return this.waitForTasksEnding(java.lang.Thread.currentThread().getPriority(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E, T extends TaskAbst<E, T>> boolean abort(T task) {
        Object object = task;
        synchronized (object) {
            if (!task.isSubmitted()) {
                task.aborted = true;
                task.clear();
            }
        }
        if (!task.isStarted()) {
            if (task.runOnlyOnce) {
                for (TaskAbst taskAbst : this.tasksQueue) {
                    if (!task.id.equals(taskAbst.id)) continue;
                    TaskAbst taskAbst2 = taskAbst;
                    synchronized (taskAbst2) {
                        if (this.tasksQueue.remove(taskAbst) && !taskAbst.isStarted()) {
                            taskAbst.aborted = true;
                            task.aborted = true;
                            taskAbst.clear();
                            task.clear();
                            taskAbst.notifyAll();
                            T t = task;
                            synchronized (t) {
                                task.notifyAll();
                            }
                            return task.aborted;
                        }
                    }
                }
                return task.aborted;
            }
            object = task;
            synchronized (object) {
                task.aborted = this.tasksQueue.remove(task);
                if (task.aborted) {
                    task.notifyAll();
                    task.clear();
                    return task.aborted;
                }
            }
        }
        return task.aborted;
    }

    public <E, T extends TaskAbst<E, T>> boolean interrupt(T task) {
        return this.terminate(task, Thread::interrupt, TaskAbst::interrupt, true);
    }

    public <E, T extends TaskAbst<E, T>> boolean kill(T task) {
        return this.terminate(task, Thread::kill, TaskAbst::kill, true);
    }

    public <E, T extends TaskAbst<E, T>> boolean interrupt(T task, boolean terminateChildren) {
        return this.terminate(task, Thread::interrupt, TaskAbst::interrupt, terminateChildren);
    }

    public <E, T extends TaskAbst<E, T>> boolean kill(T task, boolean terminateChildren) {
        return this.terminate(task, Thread::kill, TaskAbst::kill, terminateChildren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E, T extends TaskAbst<E, T>> boolean terminate(T task, Consumer<Thread> terminateOperation, Consumer<TaskAbst<?, ?>> childTerminateOperation, boolean terminateChildren) {
        if (this.abort(task)) {
            return task.aborted;
        }
        if (!task.runOnlyOnce) {
            if (this.tasksInExecution.remove(task) != null) {
                task.aborted = true;
                Thread taskThread = task.executor;
                if (taskThread != null) {
                    terminateOperation.accept(taskThread);
                    task.executorOrTerminatedExecutorFlag = taskThread;
                    taskThread.setPriority(1);
                    if (terminateChildren) {
                        this.terminateChildren(childTerminateOperation, taskThread);
                    }
                    task.aborted = !task.executed;
                }
                task.clear();
                T t = task;
                synchronized (t) {
                    task.notifyAll();
                }
            }
        } else {
            for (TaskAbst<?, ?> queuedTask : this.tasksInExecution.keySet()) {
                if (!task.id.equals(queuedTask.id)) continue;
                TaskAbst<?, ?> taskAbst = queuedTask;
                synchronized (taskAbst) {
                    if (this.tasksInExecution.remove(queuedTask) != null) {
                        queuedTask.aborted = true;
                        task.aborted = true;
                        Thread queuedTaskThread = queuedTask.executor;
                        if (queuedTaskThread != null) {
                            terminateOperation.accept(queuedTaskThread);
                            task.executorOrTerminatedExecutorFlag = queuedTaskThread;
                            queuedTask.executorOrTerminatedExecutorFlag = queuedTaskThread;
                            queuedTaskThread.setPriority(1);
                            if (terminateChildren) {
                                this.terminateChildren(childTerminateOperation, queuedTaskThread);
                            }
                            queuedTask.aborted = !task.executed;
                            task.aborted = queuedTask.aborted;
                        }
                        queuedTask.clear();
                        task.clear();
                        queuedTask.notifyAll();
                        T t = task;
                        synchronized (t) {
                            task.notifyAll();
                        }
                        return task.aborted;
                    }
                }
            }
        }
        return task.aborted;
    }

    private void terminateChildren(Consumer<TaskAbst<?, ?>> childTerminateOperation, Thread taskThread) {
        Collection<TaskAbst<?, ?>> childTasks = taskCreatorThreadsForChildTasks.get(taskThread);
        if (childTasks != null) {
            for (TaskAbst<?, ?> childTask : childTasks) {
                childTerminateOperation.accept(childTask);
            }
        }
    }

    public QueuedTaskExecutor waitForTasksEnding(int priority, boolean waitForNewAddedTasks, boolean ignoreDeadLocked) {
        this.waitForTasksEnding(priority, ignoreDeadLocked);
        if (waitForNewAddedTasks) {
            while (!this.tasksInExecution.isEmpty() || !this.tasksQueue.isEmpty()) {
                this.waitForTasksEnding(priority, ignoreDeadLocked);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedTaskExecutor waitForTasksEnding(int priority, boolean ignoreDeadLocked) {
        this.tasksLauncher.setPriority(priority);
        this.tasksQueue.stream().forEach(executable -> executable.changePriority(priority));
        if (!this.tasksQueue.isEmpty()) {
            Object object = this.executingFinishedWaiterMutex;
            synchronized (object) {
                if (!this.tasksQueue.isEmpty()) {
                    try {
                        this.executingFinishedWaiterMutex.wait();
                    }
                    catch (InterruptedException exc) {
                        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                    }
                }
            }
        }
        this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
        this.tasksLauncher.setPriority(this.defaultPriority);
        return this;
    }

    public QueuedTaskExecutor changePriority(int priority) {
        this.defaultPriority = priority;
        this.tasksLauncher.setPriority(priority);
        this.tasksQueue.stream().forEach(executable -> executable.changePriority(priority));
        return this;
    }

    public QueuedTaskExecutor suspend(boolean immediately, boolean ignoreDeadLocked) {
        return this.suspend0(immediately, java.lang.Thread.currentThread().getPriority(), ignoreDeadLocked);
    }

    public QueuedTaskExecutor suspend(boolean immediately, int priority, boolean ignoreDeadLocked) {
        return this.suspend0(immediately, priority, ignoreDeadLocked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueuedTaskExecutor suspend0(boolean immediately, int priority, boolean ignoreDeadLocked) {
        this.tasksLauncher.setPriority(priority);
        if (immediately) {
            Object object = this.suspensionCallerMutex;
            synchronized (object) {
                this.supended = Boolean.TRUE;
                this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
                try {
                    Object object2 = this.executableCollectionFillerMutex;
                    synchronized (object2) {
                        if (this.tasksLauncher.getState().equals((Object)Thread.State.WAITING)) {
                            this.executableCollectionFillerMutex.notifyAll();
                        }
                    }
                    this.suspensionCallerMutex.wait();
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                }
            }
        }
        this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
        Task supendingTask = this.createSuspendingTask(priority);
        this.changePriorityToAllTaskBeforeAndWaitThem((Task)supendingTask.addToQueue(), priority, ignoreDeadLocked);
        supendingTask.waitForFinish(ignoreDeadLocked, false);
        this.tasksLauncher.setPriority(this.defaultPriority);
        return this;
    }

    Task createSuspendingTask(int priority) {
        Task tsk = (Task)this.createTask((Task task) -> {
            this.supended = Boolean.TRUE;
        }).runOnlyOnce(this.getOperationId("suspend"), () -> this.supended);
        tsk.changePriority(priority);
        return tsk;
    }

    void waitForTasksInExecutionEnding(int priority, boolean ignoreDeadLocked) {
        this.tasksInExecution.keySet().stream().forEach(task -> {
            Thread taskExecutor = task.executor;
            if (taskExecutor != null) {
                taskExecutor.setPriority(priority);
            }
            task.waitForFinish(ignoreDeadLocked, false);
        });
    }

    <E, T extends TaskAbst<E, T>> void changePriorityToAllTaskBeforeAndWaitThem(T task, int priority, boolean ignoreDeadLocked) {
        int taskIndex = this.tasksQueue.indexOf(task);
        if (taskIndex != -1) {
            Iterator<TaskAbst<?, ?>> taskIterator = this.tasksQueue.iterator();
            int idx = 0;
            while (taskIterator.hasNext()) {
                TaskAbst<?, ?> currentIterated = taskIterator.next();
                if (idx < taskIndex) {
                    if (currentIterated == task) break;
                    task.changePriority(priority);
                }
                ++idx;
            }
        }
        this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedTaskExecutor resumeFromSuspension() {
        Object object = this.resumeCallerMutex;
        synchronized (object) {
            try {
                this.supended = Boolean.FALSE;
                this.resumeCallerMutex.notifyAll();
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown(boolean waitForTasksTermination) {
        List<TaskAbst<?, ?>> executables = this.tasksQueue;
        if (waitForTasksTermination) {
            this.suspend(false, true);
        } else {
            this.suspend(true, true);
        }
        this.terminated = Boolean.TRUE;
        this.logStatus();
        executables.clear();
        this.tasksInExecution.clear();
        this.resumeFromSuspension();
        if (this.tasksLauncher != null) {
            Object object = this.terminatingMutex;
            synchronized (object) {
                if (this.tasksLauncher != null) {
                    try {
                        this.terminatingMutex.wait();
                    }
                    catch (InterruptedException exc) {
                        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                    }
                }
            }
        }
        this.closeResources();
        return true;
    }

    public void logStatus() {
        ArrayList tasks = new ArrayList(this.tasksQueue);
        tasks.addAll(this.tasksInExecution.keySet());
        this.logStatus(this.executedTasksCount, tasks);
    }

    private void logStatus(Long executedTasksCount, Collection<TaskAbst<?, ?>> executables) {
        Collection executablesLog = executables.stream().map(task -> {
            Object executable = task.executable;
            if (executable != null) {
                return "\t" + executable;
            }
            return null;
        }).filter(threadInfo -> threadInfo != null).collect(Collectors.toList());
        StringBuffer log = new StringBuffer(this.tasksLauncher.getName() + " - launched tasks: ").append(executedTasksCount).append(", not launched tasks: ").append(executablesLog.size());
        if (executablesLog.size() > 0) {
            log.append(":\n\t").append(String.join((CharSequence)"\n\t", executablesLog));
        }
        StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, log.toString());
    }

    public String getInfoAsString() {
        StringBuffer log = new StringBuffer("");
        Collection<TaskAbst<?, ?>> tasksQueue = this.tasksQueue;
        if (!tasksQueue.isEmpty()) {
            log.append("\n\n");
            log.append(StaticComponentContainer.Strings.compile("{} - Tasks to be executed:", this.tasksLauncher));
            for (TaskAbst<?, ?> task : tasksQueue) {
                log.append("\n" + task.getInfoAsString());
            }
        }
        if (!(tasksQueue = this.tasksInExecution.keySet()).isEmpty()) {
            log.append("\n\n");
            log.append(StaticComponentContainer.Strings.compile("{} - Tasks in execution:", this.tasksLauncher));
            for (TaskAbst<?, ?> task : tasksQueue) {
                log.append("\n" + task.getInfoAsString());
            }
        }
        return log.toString();
    }

    public void logInfo() {
        String message = this.getInfoAsString();
        if (!message.isEmpty()) {
            StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, message);
        }
    }

    @Override
    public void close() {
        this.shutDown(true);
    }

    void closeResources() {
        this.threadSupplier = null;
        this.tasksQueue = null;
        this.tasksInExecution = null;
        this.initializer = null;
        this.terminated = null;
        this.supended = null;
        this.resumeCallerMutex = null;
        this.executingFinishedWaiterMutex = null;
        this.suspensionCallerMutex = null;
        this.executableCollectionFillerMutex = null;
        StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "All resources of '{}' have been closed", this.name);
        this.name = null;
    }

    public static abstract class ProducerTask<T>
    extends TaskAbst<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>, ProducerTask<T>> {
        private T result;

        ProducerTask(ThrowingFunction<ProducerTask<T>, T, ? extends Throwable> executable, boolean creationTracking) {
            super(executable, creationTracking);
        }

        @Override
        void execute0() throws Throwable {
            this.result = ((ThrowingFunction)this.executable).apply(this);
        }

        public T join() {
            return this.join(false, false, 0L);
        }

        public T join(long timeout) {
            return this.join(false, false, timeout);
        }

        public T join(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck, long timeout) {
            this.waitForFinish(ignoreDeadLocked, ignoreSubmittedCheck, timeout);
            Throwable exception = this.getException();
            if (exception != null && !this.exceptionHandled) {
                return StaticComponentContainer.Driver.throwException(exception);
            }
            if (!this.wasExecuted()) {
                throw new TaskStateException(this, "is not completed");
            }
            return this.result;
        }

        public T get() {
            return this.result;
        }
    }

    public static abstract class Task
    extends TaskAbst<ThrowingConsumer<Task, ? extends Throwable>, Task> {
        Task(ThrowingConsumer<Task, ? extends Throwable> executable, boolean creationTracking) {
            super(executable, creationTracking);
        }

        @Override
        void execute0() throws Throwable {
            ((ThrowingConsumer)this.executable).accept(this);
        }

        public void join() {
            this.join(false, false, 0L);
        }

        public void join(long timeout) {
            this.join(false, false, timeout);
        }

        public void join(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck, long timeout) {
            this.waitForFinish(ignoreDeadLocked, ignoreSubmittedCheck, timeout);
            Throwable exception = this.getException();
            if (exception != null && !this.exceptionHandled) {
                StaticComponentContainer.Driver.throwException(exception);
            }
            if (!this.wasExecuted()) {
                throw new TaskStateException(this, "is not completed");
            }
        }
    }

    public static abstract class TaskAbst<E, T extends TaskAbst<E, T>> {
        String name;
        StackTraceElement[] stackTraceOnCreation;
        List<StackTraceElement> creatorInfos;
        Supplier<Boolean> hasBeenExecutedChecker;
        volatile boolean probablyDeadLocked;
        volatile boolean runOnlyOnce;
        volatile String id;
        volatile int priority;
        volatile Long startTime;
        volatile boolean submitted;
        volatile boolean aborted;
        volatile boolean finished;
        volatile boolean executed;
        boolean exceptionHandled;
        volatile E executable;
        java.lang.Thread creator;
        Thread executor;
        Object executorOrTerminatedExecutorFlag;
        Throwable exc;
        ThrowingBiPredicate<T, Throwable, Throwable> exceptionHandler;
        QueuedTaskExecutor queuedTasksExecutor;

        public TaskAbst(E executable, boolean creationTracking) {
            if (executable == null) {
                throw new NullExecutableException("executable could not be null");
            }
            this.executable = executable;
            if (creationTracking) {
                this.stackTraceOnCreation = java.lang.Thread.currentThread().getStackTrace();
            }
        }

        T start() {
            this.executor.start();
            return (T)this;
        }

        public List<StackTraceElement> getCreatorInfos() {
            if (this.creatorInfos == null) {
                if (this.stackTraceOnCreation != null) {
                    this.creatorInfos = Collections.unmodifiableList(StaticComponentContainer.Methods.retrieveExternalCallersInfo(this.stackTraceOnCreation, (clientMethodSTE, currentIteratedSTE) -> !currentIteratedSTE.getClassName().startsWith(QueuedTaskExecutor.class.getName()), -1));
                } else {
                    StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Tasks creation tracking was disabled when {} was created", this);
                }
            }
            return this.creatorInfos;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public T setName(String name) {
            this.name = name;
            return (T)this;
        }

        public T setExceptionHandler(ThrowingBiPredicate<T, Throwable, Throwable> exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return (T)this;
        }

        public boolean isStarted() {
            return this.startTime != null;
        }

        public boolean hasFinished() {
            return this.finished;
        }

        public T runOnlyOnce(String id, Supplier<Boolean> hasBeenExecutedChecker) {
            if (this.isSubmitted()) {
                throw new TaskStateException(this, "is submitted");
            }
            this.runOnlyOnce = true;
            this.id = id;
            this.hasBeenExecutedChecker = hasBeenExecutedChecker;
            return (T)this;
        }

        public boolean isAborted() {
            Thread executor = this.executor;
            return this.aborted && !this.executed && (executor == null || !executor.isAlive());
        }

        private boolean isExecutorTerminated() {
            Object executorOrTerminatedExecutorFlag = this.executorOrTerminatedExecutorFlag;
            if (executorOrTerminatedExecutorFlag instanceof Boolean) {
                return (Boolean)executorOrTerminatedExecutorFlag;
            }
            if (executorOrTerminatedExecutorFlag != null) {
                boolean isAlive = ((Thread)executorOrTerminatedExecutorFlag).isAlive();
                if (!isAlive) {
                    this.executorOrTerminatedExecutorFlag = !isAlive;
                    return (Boolean)this.executorOrTerminatedExecutorFlag;
                }
                return !isAlive;
            }
            return false;
        }

        public boolean isTerminatedThreadNotAlive() {
            return this.isTerminatedThreadNotAlive(0L);
        }

        public boolean isTerminatedThreadNotAlive(long waitingTime) {
            if (this.checkSubmitted() && this.isExecutorTerminated()) {
                return true;
            }
            if (waitingTime > 0L) {
                Thread.waitFor(waitingTime);
            }
            return this.isExecutorTerminated();
        }

        public T waitForTerminatedThreadNotAlive(long pingTime) {
            return this.waitForTerminatedThreadNotAlive(pingTime, 0L);
        }

        public T waitForTerminatedThreadNotAlive(long pingTime, long tentative) {
            if (tentative > 0L) {
                while (!this.isTerminatedThreadNotAlive(pingTime) && tentative-- > 0L) {
                }
            } else {
                while (!this.isTerminatedThreadNotAlive(pingTime)) {
                }
            }
            return (T)this;
        }

        public <EXC extends Throwable> T waitForTerminatedThreadNotAlive(long pingTime, ThrowingConsumer<Integer, EXC> consumer) {
            return this.waitForTerminatedThreadNotAlive(pingTime, 0L, consumer);
        }

        public <EXC extends Throwable> T waitForTerminatedThreadNotAlive(long pingTime, long tentative, ThrowingConsumer<Integer, EXC> consumer) {
            int tentativeCount = 0;
            if (tentative > 0L) {
                while (!this.isTerminatedThreadNotAlive(pingTime) && tentative-- > 0L) {
                    Executor.accept(consumer, ++tentativeCount);
                }
            } else {
                while (!this.isTerminatedThreadNotAlive(pingTime)) {
                    Executor.accept(consumer, ++tentativeCount);
                }
            }
            return (T)this;
        }

        public boolean wasExecuted() {
            return this.executed;
        }

        public boolean wasExecutedWithException() {
            return this.isStarted() && this.exc != null;
        }

        public boolean isSubmitted() {
            return this.submitted;
        }

        public boolean isProbablyDeadLocked() {
            return this.probablyDeadLocked;
        }

        synchronized void markAsProbablyDeadLocked() {
            this.probablyDeadLocked = true;
            this.executor.setName("PROBABLE DEAD-LOCKED THREAD -> " + this.executor.getName());
        }

        public T waitForStarting() {
            return this.waitForStarting(false, false, 0L);
        }

        public T waitForStarting(long timeout) {
            return this.waitForStarting(false, false, timeout);
        }

        public T waitForStarting(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck) {
            return this.waitForStarting(ignoreDeadLocked, ignoreSubmittedCheck, 0L);
        }

        public T waitForStarting(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck, long timeout) {
            if (timeout <= 0L) {
                while (this.waitForStarting0(ignoreDeadLocked, ignoreSubmittedCheck, 0L)) {
                }
                return (T)this;
            }
            long timeAtStartWaiting = System.currentTimeMillis();
            while (this.waitForStarting0(ignoreDeadLocked, ignoreSubmittedCheck, timeout) && System.currentTimeMillis() - timeAtStartWaiting < timeout) {
            }
            return (T)this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForStarting0(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck, long timeout) {
            java.lang.Thread currentThread = java.lang.Thread.currentThread();
            if (currentThread == this.executor) {
                return false;
            }
            if ((ignoreSubmittedCheck || this.checkSubmitted()) && !this.isStarted()) {
                TaskAbst taskAbst = this;
                synchronized (taskAbst) {
                    if (!this.isStarted()) {
                        try {
                            if (this.probablyDeadLocked) {
                                if (ignoreDeadLocked) {
                                    return false;
                                }
                                throw new TaskStateException(this, "could be dead locked");
                            }
                            if (this.isAborted()) {
                                throw new TaskStateException(this, "is aborted");
                            }
                            this.wait(timeout);
                            return true;
                        }
                        catch (InterruptedException exc) {
                            throw new TaskStateException(this, "has been interrupted", exc);
                        }
                    }
                }
            }
            return false;
        }

        private boolean checkSubmitted() {
            if (!this.isSubmitted()) {
                throw new TaskStateException(this, "is not submitted");
            }
            return true;
        }

        public T waitForFinish() {
            return this.waitForFinish(false, false, 0L);
        }

        public T waitForFinish(long timeout) {
            return this.waitForFinish(false, false, timeout);
        }

        public T waitForFinish(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck) {
            return this.waitForFinish(ignoreDeadLocked, ignoreSubmittedCheck, 0L);
        }

        public T waitForFinish(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck, long timeout) {
            if (timeout <= 0L) {
                while (this.waitForFinish0(ignoreDeadLocked, ignoreSubmittedCheck, 0L)) {
                }
                return (T)this;
            }
            long timeAtStartWaiting = System.currentTimeMillis();
            while (this.waitForFinish0(ignoreDeadLocked, ignoreSubmittedCheck, timeout) && System.currentTimeMillis() - timeAtStartWaiting < timeout) {
            }
            return (T)this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForFinish0(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck, long timeout) {
            java.lang.Thread currentThread = java.lang.Thread.currentThread();
            if (currentThread == this.executor) {
                return false;
            }
            if ((ignoreSubmittedCheck || this.checkSubmitted()) && !this.hasFinished()) {
                TaskAbst taskAbst = this;
                synchronized (taskAbst) {
                    if (!this.hasFinished()) {
                        try {
                            if (this.probablyDeadLocked) {
                                if (ignoreDeadLocked) {
                                    return false;
                                }
                                throw new TaskStateException(this, "could be dead locked");
                            }
                            if (this.isAborted()) {
                                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Task is aborted:{} ", this.getInfoAsString());
                                return false;
                            }
                            this.wait(timeout);
                            return true;
                        }
                        catch (InterruptedException exc) {
                            throw new TaskStateException(this, "has been interrupted", exc);
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void execute() {
            try {
                TaskAbst taskAbst = this;
                // MONITORENTER : taskAbst
                if (this.aborted) {
                    this.notifyAll();
                    this.clear();
                    // MONITOREXIT : taskAbst
                    return;
                }
                // MONITOREXIT : taskAbst
                this.startTime = System.currentTimeMillis();
                this.getQueuedTasksExecutor().tasksInExecution.put(this, this);
                taskAbst = this;
                // MONITORENTER : taskAbst
                this.notifyAll();
                // MONITOREXIT : taskAbst
            }
            catch (Throwable exc) {
                this.exc = exc;
                this.startTime = null;
                if (this.exceptionHandler == null) throw exc;
                this.exceptionHandled = this.exceptionHandler.test(this, exc);
                if (!this.exceptionHandled) {
                    throw exc;
                }
                this.forceAbort();
                return;
            }
            try {
                this.execute0();
                this.executed = true;
                ++this.getQueuedTasksExecutor().executedTasksCount;
                return;
            }
            catch (Throwable exc) {
                this.exc = exc;
                if (this.exceptionHandler == null) throw exc;
                this.exceptionHandled = this.exceptionHandler.test(this, exc);
                if (this.exceptionHandled) return;
                throw exc;
            }
            finally {
                this.markAsFinished();
            }
        }

        private synchronized void forceAbort() {
            this.aborted = true;
            this.notifyAll();
            this.clear();
        }

        public String getInfoAsString() {
            if (this.getCreatorInfos() != null) {
                Thread executor = this.executor;
                return StaticComponentContainer.Strings.compile("\n\tTask hash code: {}\n\tTask status: {} {} \n\tcreated at: {}", this.hashCode(), StaticComponentContainer.Strings.compile("\n\t\tpriority: {}\n\t\tstarted: {}\n\t\taborted: {}\n\t\tfinished: {}", this.priority, this.isStarted(), this.isAborted(), this.hasFinished()), executor != null ? "\n\t" + executor + StaticComponentContainer.Strings.from(executor.getStackTrace(), 2) : "", StaticComponentContainer.Strings.from(this.getCreatorInfos(), 2));
            }
            return StaticComponentContainer.Strings.compile("\n\tTask hash code: {}\n\tTask status: {} {}", this.hashCode(), StaticComponentContainer.Strings.compile("\n\t\tpriority: {}\n\t\tstarted: {}\n\t\taborted: {}\n\t\tfinished: {}", this.priority, this.isStarted(), this.isAborted(), this.hasFinished()), this.executor != null ? "\n\t" + this.executor + StaticComponentContainer.Strings.from(this.executor.getStackTrace(), 2) : "");
        }

        public void logInfo() {
            StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, this.getInfoAsString());
        }

        public void logException() {
            this.logException(this.exc);
        }

        private void logException(Throwable exc) {
            Thread executor = this.executor;
            if (executor != null) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, StaticComponentContainer.Strings.compile("Exception occurred while executing {} ({}): \n\t\t{}: {}{}", this, this.executor, exc.toString(), StaticComponentContainer.Strings.from(exc.getStackTrace(), 2), this.getCreatorInfos() != null ? "\n\tthat was created at:" + StaticComponentContainer.Strings.from(this.getCreatorInfos(), 2) : ""));
                return;
            }
            StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, StaticComponentContainer.Strings.compile("Exception occurred while executing {}: \n\t\t{}: {}{}", this, exc.toString(), StaticComponentContainer.Strings.from(exc.getStackTrace(), 2), this.getCreatorInfos() != null ? "\n\tthat was created at:" + StaticComponentContainer.Strings.from(this.getCreatorInfos(), 2) : ""));
        }

        void clear() {
            this.getQueuedTasksExecutor().tasksInExecution.remove(this);
            if (this.runOnlyOnce) {
                runOnlyOnceTasks.remove(this.id);
            }
            this.executable = null;
            java.lang.Thread creator = this.creator;
            if (creator != null) {
                StaticComponentContainer.Synchronizer.execute(StaticComponentContainer.Objects.getId(creator), () -> {
                    Collection creatorChildTasks = (Collection)taskCreatorThreadsForChildTasks.get(creator);
                    if (creatorChildTasks != null) {
                        creatorChildTasks.remove(this);
                        if (creatorChildTasks.isEmpty()) {
                            taskCreatorThreadsForChildTasks.remove(creator);
                        }
                    }
                });
            }
            this.creator = null;
            this.executor = null;
            this.queuedTasksExecutor = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markAsFinished() {
            try {
                this.finished = true;
            }
            finally {
                TaskAbst taskAbst = this;
                synchronized (taskAbst) {
                    this.notifyAll();
                }
                this.clear();
            }
        }

        abstract void execute0() throws Throwable;

        T setExecutor(Thread thread) {
            this.executor = thread.setExecutable(thr -> this.execute());
            this.executor.setPriority(this.priority);
            QueuedTaskExecutor queuedTasksExecutor = this.getQueuedTasksExecutor();
            if (this.name != null) {
                this.executor.setName(queuedTasksExecutor.name + " - " + this.name);
            } else {
                this.executor.setIndexedName(queuedTasksExecutor.name + " " + this.executor.typeName.toLowerCase() + " executor");
            }
            return (T)this;
        }

        public boolean changePriority(int priority) {
            this.priority = priority;
            if (this.executor != null) {
                this.executor.setPriority(this.priority);
                return true;
            }
            return false;
        }

        public boolean setPriorityToCurrentThreadPriority() {
            return this.changePriority(java.lang.Thread.currentThread().getPriority());
        }

        public int getPriority() {
            return this.priority;
        }

        public Throwable getException() {
            return this.exc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T submit() {
            if (this.isAborted()) {
                throw new TaskStateException(this, "is aborted");
            }
            if (!this.submitted) {
                TaskAbst taskAbst = this;
                synchronized (taskAbst) {
                    if (this.submitted) {
                        throw new TaskStateException(this, "is already submitted");
                    }
                    this.submitted = true;
                }
            } else {
                throw new TaskStateException(this, "is already submitted");
            }
            return this.addToQueue();
        }

        T addToQueue() {
            return (T)this.getQueuedTasksExecutor().addToQueue(this, false);
        }

        public T abortOrWaitForFinish() {
            return this.abortOrWaitForFinish(false, false);
        }

        public T abortOrWaitForFinish(boolean ignoreDeadLocked, boolean ignoreSubmittedCheck) {
            if (!((TaskAbst)this.abort()).isAborted()) {
                this.waitForFinish(ignoreDeadLocked, ignoreSubmittedCheck);
            }
            return (T)this;
        }

        public T abort() {
            this.getQueuedTasksExecutor().abort(this);
            return (T)this;
        }

        public T kill() {
            return this.kill(true);
        }

        public T interrupt() {
            return this.interrupt(true);
        }

        public T kill(boolean terminateChildren) {
            this.getQueuedTasksExecutor().kill(this, terminateChildren);
            return (T)this;
        }

        public T interrupt(boolean terminateChildren) {
            this.getQueuedTasksExecutor().interrupt(this, terminateChildren);
            return (T)this;
        }

        abstract QueuedTaskExecutor getQueuedTasksExecutor();

        abstract QueuedTaskExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread var1);
    }

    public static class Group
    implements Identifiable {
        String name;
        Map<Integer, QueuedTaskExecutor> queuedTasksExecutors;
        TasksMonitorer allTasksMonitorer;
        Consumer<Group> initializator = queuedTasksExecutorGroup -> {
            String name = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("name").on(configuration));
            Thread.Supplier mainThreadSupplier = (Thread.Supplier)configuration.get("thread-supplier");
            Boolean isDaemon = StaticComponentContainer.Objects.toBoolean(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("daemon").on(configuration)));
            queuedTasksExecutorGroup.name = name;
            HashMap<Integer, QueuedTaskExecutor> queuedTasksExecutors = new HashMap<Integer, QueuedTaskExecutor>();
            for (int i = 0; i < 10; ++i) {
                Object priorityAsObject = StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("queued-task-executor[" + i + "].priority").on(configuration));
                if (priorityAsObject == null) continue;
                int priority = StaticComponentContainer.Objects.toInt(priorityAsObject);
                if (priority < 1 || priority > 10) {
                    throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("Value of '{}' is not correct: it must be between {} and {}", "queued-task-executor[" + i + "].priority", 1, 10));
                }
                String queuedTasksExecutorName = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("queued-task-executor[" + i + "].name").on(configuration));
                Thread.Supplier queuedTasksExecutorThreadSupplier = (Thread.Supplier)StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("queued-task-executor[" + i + "].thread-supplier").on(configuration));
                if (queuedTasksExecutorThreadSupplier == null) {
                    queuedTasksExecutorThreadSupplier = mainThreadSupplier;
                }
                Object isQueuedTasksExecutorDaemonAsObject = StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("queued-task-executor[" + i + "].daemon").on(configuration));
                Boolean isQueuedTasksExecutorDaemon = isDaemon;
                if (isQueuedTasksExecutorDaemonAsObject != null) {
                    isQueuedTasksExecutorDaemon = StaticComponentContainer.Objects.toBoolean(isQueuedTasksExecutorDaemonAsObject);
                }
                queuedTasksExecutors.put(priority, this.createQueuedTasksExecutor(name + " - " + queuedTasksExecutorName, queuedTasksExecutorThreadSupplier, priority, isQueuedTasksExecutorDaemon));
            }
            this.definedPriorites = new Integer[queuedTasksExecutors.size()];
            this.definedPriorites = queuedTasksExecutors.keySet().toArray(this.definedPriorites);
            this.queuedTasksExecutors = queuedTasksExecutors;
        };
        Integer[] definedPriorites;

        Group(Map<String, Object> configuration) {
        }

        public Group setTasksCreationTrackingFlag(boolean flag) {
            if (this.initializator == null) {
                this.setTasksCreationTrackingFlag(this, flag);
            } else {
                this.initializator = this.initializator.andThen(queuedTasksExecutorGroup -> this.setTasksCreationTrackingFlag((Group)queuedTasksExecutorGroup, flag));
            }
            return this;
        }

        private void setTasksCreationTrackingFlag(Group queuedTasksExecutorGroup, boolean flag) {
            for (Map.Entry<Integer, QueuedTaskExecutor> queuedTasksExecutorBox : queuedTasksExecutorGroup.queuedTasksExecutors.entrySet()) {
                queuedTasksExecutorBox.getValue().setTasksCreationTrackingFlag(flag);
            }
        }

        public Group startAllTasksMonitoring(TasksMonitorer.Config config) {
            if (this.initializator == null) {
                this.startAllTasksMonitoring(this, config);
            } else {
                StaticComponentContainer.Synchronizer.execute(this.getOperationId("initialization"), () -> {
                    if (this.initializator != null) {
                        this.initializator = this.initializator.andThen(queuedTasksExecutorGroup -> this.startAllTasksMonitoring(this, config));
                    } else {
                        this.startAllTasksMonitoring(this, config);
                    }
                });
            }
            return this;
        }

        synchronized void startAllTasksMonitoring(Group queuedTasksExecutorGroup, TasksMonitorer.Config config) {
            TasksMonitorer allTasksMonitorer = queuedTasksExecutorGroup.allTasksMonitorer;
            if (allTasksMonitorer != null) {
                allTasksMonitorer.close();
            }
            queuedTasksExecutorGroup.allTasksMonitorer = new TasksMonitorer(queuedTasksExecutorGroup, config).start();
        }

        public static Group create(String keyPrefix, Map<String, Object> configuration) {
            configuration = StaticComponentContainer.IterableObjectHelper.resolveValues((IterableObjectHelper.ResolveConfig.ForAllKeysThat)IterableObjectHelper.ResolveConfig.forAllKeysThat(key -> key.startsWith(keyPrefix + ".")).on(configuration));
            HashMap<String, Object> finalConfiguration = new HashMap<String, Object>();
            boolean undestroyableFromExternal = StaticComponentContainer.Objects.toBoolean(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(keyPrefix + ".undestroyable-from-external").on(configuration)));
            for (Map.Entry<String, Object> entry : configuration.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Collection && ((Collection)value).size() == 1) {
                    value = ((Collection)value).iterator().next();
                }
                finalConfiguration.put(entry.getKey().replace(keyPrefix + ".", ""), value);
            }
            if (!undestroyableFromExternal) {
                return new Group(finalConfiguration);
            }
            return new Group(finalConfiguration){
                StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                @Override
                public boolean shutDown(boolean waitForTasksTermination) {
                    if (StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                        return super.shutDown(waitForTasksTermination);
                    }
                    return false;
                }
            };
        }

        public <T> ProducerTask<T> createProducerTask(ThrowingFunction<ProducerTask<T>, T, ? extends Throwable> executable) {
            return this.createProducerTask(executable, java.lang.Thread.currentThread().getPriority());
        }

        public <T> ProducerTask<T> createProducerTask(ThrowingFunction<ProducerTask<T>, T, ? extends Throwable> executable, int priority) {
            return this.getByPriority(priority).createProducerTask(executable);
        }

        public <T> ProducerTask<T> createProducerTask(ThrowingSupplier<T, ? extends Throwable> executable) {
            return this.createProducerTask(executable, java.lang.Thread.currentThread().getPriority());
        }

        public <T> ProducerTask<T> createProducerTask(ThrowingSupplier<T, ? extends Throwable> executable, int priority) {
            return this.getByPriority(priority).createProducerTask(executable);
        }

        QueuedTaskExecutor getByPriority(int priority) {
            QueuedTaskExecutor queuedTasksExecutor = null;
            try {
                queuedTasksExecutor = this.queuedTasksExecutors.get(priority);
            }
            catch (NullPointerException exc) {
                if (this.queuedTasksExecutors == null && this.initializator != null) {
                    StaticComponentContainer.Synchronizer.execute(this.getOperationId("initialization"), () -> {
                        if (this.initializator != null) {
                            this.initializator.accept(this);
                            this.initializator = null;
                        }
                    });
                }
                queuedTasksExecutor = this.queuedTasksExecutors.get(priority);
            }
            if (queuedTasksExecutor == null) {
                queuedTasksExecutor = this.queuedTasksExecutors.get(this.checkAndCorrectPriority(priority));
            }
            return queuedTasksExecutor;
        }

        int checkAndCorrectPriority(int priority) {
            if (this.queuedTasksExecutors.get(priority) != null) {
                return priority;
            }
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("Priority value must be between {} and {}", 1, 10));
            }
            Integer currentMaxPriorityHandled = this.definedPriorites[this.definedPriorites.length - 1];
            if (priority > currentMaxPriorityHandled) {
                return currentMaxPriorityHandled;
            }
            for (Integer definedPriorite : this.definedPriorites) {
                if (priority >= definedPriorite) continue;
                return definedPriorite;
            }
            return this.definedPriorites[this.definedPriorites.length - 1];
        }

        public Task createTask(ThrowingConsumer<Task, ? extends Throwable> executable) {
            return this.createTask(executable, java.lang.Thread.currentThread().getPriority());
        }

        public Task createTask(ThrowingConsumer<Task, ? extends Throwable> executable, int priority) {
            return this.getByPriority(priority).createTask(executable);
        }

        public Task createTask(ThrowingRunnable<? extends Throwable> executable) {
            return this.createTask(executable, java.lang.Thread.currentThread().getPriority());
        }

        public Task createTask(ThrowingRunnable<? extends Throwable> executable, int priority) {
            return this.getByPriority(priority).createTask(executable);
        }

        QueuedTaskExecutor createQueuedTasksExecutor(String executorName, Thread.Supplier threadSupplier, int priority, boolean isDaemon) {
            return new QueuedTaskExecutor(executorName, threadSupplier, priority, isDaemon){

                @Override
                <T> Function<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>, ProducerTask<T>> getProducerTaskSupplier() {
                    return executable -> new ProducerTask<T>((ThrowingFunction)executable, this.taskCreationTrackingEnabled){

                        @Override
                        QueuedTaskExecutor getQueuedTasksExecutor() {
                            return this.queuedTasksExecutor != null ? this.queuedTasksExecutor : this.getByPriority(this.priority);
                        }

                        @Override
                        public boolean changePriority(int priority) {
                            return this.changePriority(this, priority);
                        }

                        @Override
                        QueuedTaskExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread thread) {
                            return this.getByPriority(thread.getPriority());
                        }
                    };
                }

                @Override
                <T> Function<ThrowingConsumer<Task, ? extends Throwable>, Task> getTaskSupplier() {
                    return executable -> new Task((ThrowingConsumer)executable, this.taskCreationTrackingEnabled){

                        @Override
                        QueuedTaskExecutor getQueuedTasksExecutor() {
                            return this.queuedTasksExecutor != null ? this.queuedTasksExecutor : this.getByPriority(this.priority);
                        }

                        @Override
                        public boolean changePriority(int priority) {
                            return this.changePriority(this, priority);
                        }

                        @Override
                        QueuedTaskExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread thread) {
                            return this.getByPriority(thread.getPriority());
                        }
                    };
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public QueuedTaskExecutor waitForTasksEnding(int priority, boolean ignoreDeadLocked) {
                    if (priority == this.defaultPriority) {
                        if (!this.tasksQueue.isEmpty()) {
                            Object object = this.executingFinishedWaiterMutex;
                            synchronized (object) {
                                if (!this.tasksQueue.isEmpty()) {
                                    try {
                                        this.executingFinishedWaiterMutex.wait();
                                    }
                                    catch (InterruptedException exc) {
                                        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, exc);
                                    }
                                }
                            }
                        }
                        this.tasksInExecution.keySet().stream().forEach(task -> task.waitForFinish(ignoreDeadLocked, false));
                    } else {
                        this.tasksQueue.stream().forEach(executable -> executable.changePriority(priority));
                        this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
                    }
                    return this;
                }

                @Override
                public <E, T extends TaskAbst<E, T>> QueuedTaskExecutor waitFor(T task, int priority, boolean ignoreDeadLocked) {
                    task.waitForFinish(ignoreDeadLocked, false);
                    return this;
                }

                @Override
                Task createSuspendingTask(int priority) {
                    return this.createTask((Task task) -> {
                        this.supended = Boolean.TRUE;
                    });
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <E, T extends TaskAbst<E, T>> boolean changePriority(T task, int priority) {
            int oldPriority = task.priority;
            int newPriority = this.checkAndCorrectPriority(priority);
            if (oldPriority != priority) {
                T t = task;
                synchronized (t) {
                    if (this.getByPriority((int)oldPriority).tasksQueue.remove(task)) {
                        task.priority = newPriority;
                        QueuedTaskExecutor queuedTasksExecutor = this.getByPriority(newPriority);
                        task.queuedTasksExecutor = null;
                        task.executor = null;
                        queuedTasksExecutor.addToQueue(task, true);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isClosed() {
            return this.queuedTasksExecutors == null;
        }

        public Group waitForTasksEnding() {
            return this.waitForTasksEnding(java.lang.Thread.currentThread().getPriority(), false, false);
        }

        public Group waitForTasksEnding(boolean ignoreDeadLocked) {
            return this.waitForTasksEnding(java.lang.Thread.currentThread().getPriority(), false, ignoreDeadLocked);
        }

        public Group waitForTasksEnding(boolean waitForNewAddedTasks, boolean ignoreDeadLocked) {
            return this.waitForTasksEnding(java.lang.Thread.currentThread().getPriority(), waitForNewAddedTasks, ignoreDeadLocked);
        }

        public Group waitForTasksEnding(int priority, boolean waitForNewAddedTasks, boolean ignoreDeadLocked) {
            StaticComponentContainer.Synchronizer.execute(this.getOperationId("initialization"), () -> {
                QueuedTaskExecutor queuedTasksExecutor;
                if (this.initializator != null) {
                    return;
                }
                QueuedTaskExecutor lastToBeWaitedFor = this.getByPriority(priority);
                for (Map.Entry<Integer, QueuedTaskExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                    queuedTasksExecutor = queuedTasksExecutorBox.getValue();
                    if (queuedTasksExecutor == lastToBeWaitedFor) continue;
                    queuedTasksExecutor.waitForTasksEnding(priority, waitForNewAddedTasks, ignoreDeadLocked);
                }
                lastToBeWaitedFor.waitForTasksEnding(priority, waitForNewAddedTasks, ignoreDeadLocked);
                for (Map.Entry<Integer, QueuedTaskExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                    queuedTasksExecutor = queuedTasksExecutorBox.getValue();
                    if (!waitForNewAddedTasks || queuedTasksExecutor.tasksQueue.isEmpty() && queuedTasksExecutor.tasksInExecution.isEmpty()) continue;
                    this.waitForTasksEnding(priority, waitForNewAddedTasks, ignoreDeadLocked);
                    break;
                }
            });
            return this;
        }

        public <E, T extends TaskAbst<E, T>> Group waitFor(T task, boolean ignoreDeadLocked) {
            return this.waitFor(task, java.lang.Thread.currentThread().getPriority(), ignoreDeadLocked);
        }

        public <E, T extends TaskAbst<E, T>> Group waitFor(T task, int priority, boolean ignoreDeadLocked) {
            if (task.getPriority() != priority) {
                task.changePriority(priority);
            }
            task.waitForFinish(ignoreDeadLocked, false);
            return this;
        }

        public Group logInfo() {
            String loggableMessage = this.getInfoAsString();
            loggableMessage = this.getInfoAsString();
            if (!loggableMessage.isEmpty()) {
                StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, loggableMessage);
            }
            return this;
        }

        public String getInfoAsString() {
            StringBuffer loggableMessage = new StringBuffer("");
            for (Map.Entry<Integer, QueuedTaskExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                loggableMessage.append(queuedTasksExecutorBox.getValue().getInfoAsString());
            }
            return loggableMessage.toString();
        }

        public <E, T extends TaskAbst<E, T>> boolean abort(T task) {
            for (Map.Entry<Integer, QueuedTaskExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                if (!queuedTasksExecutorBox.getValue().abort(task)) continue;
                return true;
            }
            return false;
        }

        public <E, T extends TaskAbst<E, T>> boolean kill(T task) {
            for (Map.Entry<Integer, QueuedTaskExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                if (!queuedTasksExecutorBox.getValue().kill(task)) continue;
                return true;
            }
            return false;
        }

        public Collection<TaskAbst<?, ?>> getAllTasksInExecution() {
            HashSet tasksInExecution = new HashSet();
            for (Map.Entry<Integer, QueuedTaskExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                tasksInExecution.addAll(queuedTasksExecutorBox.getValue().tasksInExecution.keySet());
            }
            return tasksInExecution;
        }

        public Group startAllTasksMonitoring() {
            TasksMonitorer allTasksMonitorer = this.allTasksMonitorer;
            if (allTasksMonitorer != null) {
                allTasksMonitorer.start();
                return this;
            }
            return (Group)StaticComponentContainer.Driver.throwException("All tasks monitorer has not been configured", new Object[0]);
        }

        public Group stopAllTasksMonitoring() {
            TasksMonitorer allTasksMonitorer = this.allTasksMonitorer;
            if (allTasksMonitorer != null) {
                allTasksMonitorer.stop();
            }
            return this;
        }

        public boolean shutDown(boolean waitForTasksTermination) {
            StaticComponentContainer.Synchronizer.execute(this.getOperationId("initialization"), () -> {
                if (this.initializator != null) {
                    this.initializator = null;
                    return;
                }
                QueuedTaskExecutor lastToBeWaitedFor = this.getByPriority(java.lang.Thread.currentThread().getPriority());
                for (Map.Entry<Integer, QueuedTaskExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                    QueuedTaskExecutor queuedTasksExecutor = queuedTasksExecutorBox.getValue();
                    if (queuedTasksExecutor == lastToBeWaitedFor) continue;
                    queuedTasksExecutor.shutDown(waitForTasksTermination);
                }
                lastToBeWaitedFor.shutDown(waitForTasksTermination);
                this.allTasksMonitorer.close(waitForTasksTermination);
                this.allTasksMonitorer = null;
                this.queuedTasksExecutors.clear();
                this.queuedTasksExecutors = null;
            });
            return true;
        }
    }
}

