/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.KarmaMain;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaArray;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaElement;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaObject;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;

public final class KarmaConfig {
    public final KarmaMain mn;

    public KarmaConfig() {
        KarmaMain tmp = null;
        try {
            Path dst = KarmaAPI.source(false).getDataPath().resolve("config.kf");
            InputStream internal = KarmaConfig.class.getResourceAsStream("/config.kf");
            if (!Files.exists(dst, new LinkOption[0]) && internal != null) {
                Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                Files.createFile(dst, new FileAttribute[0]);
                Files.copy(internal, dst, StandardCopyOption.REPLACE_EXISTING);
            }
            if (Files.size(dst) <= 100L && internal != null) {
                Files.copy(internal, dst, StandardCopyOption.REPLACE_EXISTING);
            }
            tmp = new KarmaMain(dst);
            tmp.preCache();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.mn = tmp;
    }

    public String consolePrefix(KarmaSource source, Level lvl) {
        String placeholder;
        switch (lvl) {
            case OK: {
                String rs;
                KarmaElement element;
                placeholder = "&b[ &3%project% &b| &2OK &b] >> &9";
                if (this.mn == null || (element = this.mn.get("ok_prefix", null)) == null || !element.isString() || StringUtils.isNullOrEmpty(rs = element.getObjet().getString())) break;
                placeholder = rs;
                break;
            }
            case INFO: {
                String rs;
                KarmaElement element;
                placeholder = "&b[ &3%project% &b| &7INFO &b] >> &9";
                if (this.mn == null || (element = this.mn.get("info_prefix", null)) == null || !element.isString() || StringUtils.isNullOrEmpty(rs = element.getObjet().getString())) break;
                placeholder = rs;
                break;
            }
            case WARNING: {
                String rs;
                KarmaElement element;
                placeholder = "&b[ &3%project% &b| &6WARNING &b] >> &9";
                if (this.mn == null || (element = this.mn.get("warning_prefix", null)) == null || !element.isString() || StringUtils.isNullOrEmpty(rs = element.getObjet().getString())) break;
                placeholder = rs;
                break;
            }
            default: {
                String rs;
                KarmaElement element;
                placeholder = "&b[ &3%project% &b| &cGRAVE &b] >> &9";
                if (this.mn == null || (element = this.mn.get("grave_prefix", null)) == null || !element.isString() || StringUtils.isNullOrEmpty(rs = element.getObjet().getString())) break;
                placeholder = rs;
            }
        }
        return placeholder.replace("%project%", source.name()).replace("%version%", source.version()).replace("%author%", source.authors(false, " ; ")).replace("%level%", lvl.name().toUpperCase());
    }

    public boolean fileDebug(Level lvl) {
        KarmaElement levels;
        boolean result;
        KarmaElement element;
        if (this.mn != null && (element = this.mn.get("file_copy_debug", new KarmaObject(false))).isBoolean() && (result = element.getObjet().getBoolean().booleanValue()) && (levels = this.mn.get("file_copy_levels", new KarmaArray(new KarmaObject("WARNING"), new KarmaObject("INFO")))).isArray()) {
            KarmaArray array = levels.toLowerCase().getArray();
            return array.contains(new KarmaObject(lvl.name().toLowerCase()));
        }
        return false;
    }

    public boolean utilDebug(Level lvl) {
        KarmaElement levels;
        boolean result;
        KarmaElement element;
        if (this.mn != null && (element = this.mn.get("file_util_debug", new KarmaObject(false))).isBoolean() && (result = element.getObjet().getBoolean().booleanValue()) && (levels = this.mn.get("file_util_levels", new KarmaArray(new KarmaObject("OK"), new KarmaObject("INFO"), new KarmaObject("WARNING"), new KarmaObject("GRAVE")))).isArray()) {
            KarmaArray array = levels.toLowerCase().getArray();
            return array.contains(new KarmaObject(lvl.name().toLowerCase()));
        }
        return false;
    }

    public boolean debug(Level lvl) {
        KarmaElement levels;
        boolean result;
        KarmaElement element;
        if (this.mn != null && (element = this.mn.get("debug", new KarmaObject(true))).isBoolean() && (result = element.getObjet().getBoolean().booleanValue()) && (levels = this.mn.get("debug_levels", new KarmaArray(new KarmaObject("OK"), new KarmaObject("INFO"), new KarmaObject("WARNING"), new KarmaObject("GRAVE")))).isArray()) {
            KarmaArray array = levels.toLowerCase().getArray();
            return array.contains(new KarmaObject(lvl.name()).toLowerCase());
        }
        return false;
    }

    public boolean log(Level lvl) {
        KarmaElement levels;
        boolean result;
        KarmaElement element;
        if (this.mn != null && (element = this.mn.get("logging", new KarmaObject(true))).isBoolean() && (result = element.getObjet().getBoolean().booleanValue()) && (levels = this.mn.get("logging_levels", new KarmaArray(new KarmaObject("OK"), new KarmaObject("INFO"), new KarmaObject("WARNING"), new KarmaObject("GRAVE")))).isArray()) {
            KarmaArray array = levels.toLowerCase().getArray();
            return array.contains(new KarmaObject(lvl.name()).toLowerCase());
        }
        return true;
    }
}

