/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import ml.karmaconfigs.remote.messaging.google.gson.Gson;
import ml.karmaconfigs.remote.messaging.google.gson.GsonBuilder;
import ml.karmaconfigs.remote.messaging.google.gson.JsonElement;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;

public final class HttpUtil {
    private final URI url;
    private static CloseableHttpClient httpClient = null;

    HttpUtil(URL target) throws URISyntaxException {
        this.url = target.toURI();
        if (httpClient == null) {
            httpClient = HttpClientBuilder.create().disableRedirectHandling().disableDefaultUserAgent().setUserAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36").build();
        }
    }

    public void push() {
        try {
            HttpGet httpget = new HttpGet(this.url);
            httpClient.execute((HttpUriRequest)httpget);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public String getResponse() {
        String response = "";
        try {
            HttpGet httpget = new HttpGet(this.url);
            CloseableHttpResponse httpresponse = httpClient.execute((HttpUriRequest)httpget);
            Header[] contentType = httpresponse.getHeaders("Content-type");
            boolean json = false;
            for (Header header : contentType) {
                if (!header.getValue().equalsIgnoreCase("application/json")) continue;
                json = true;
                break;
            }
            Scanner sc = new Scanner(httpresponse.getEntity().getContent());
            StringBuilder sb = new StringBuilder();
            while (sc.hasNext()) {
                sb.append(sc.next());
            }
            response = sb.toString();
            if (json) {
                Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                JsonElement object = (JsonElement)gson.fromJson(response, JsonElement.class);
                response = gson.toJson(object);
            }
        }
        catch (HttpHostConnectException ex) {
            response = "403 - Connection refused";
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }
}

