/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.tcp.remote;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import ml.karmaconfigs.remote.messaging.remote.RemoteClient;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataOutput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.util.message.type.MergeType;

public final class TCPRemoteClient
extends RemoteClient {
    private final String name;
    private final String MAC;
    private final InetAddress host;
    private final int port;
    private final SocketChannel clientSocket;

    public TCPRemoteClient(String client, String m, InetAddress address, int incoming_port, SocketChannel socket) {
        this.name = client;
        this.MAC = m;
        this.host = address;
        this.port = incoming_port;
        this.clientSocket = socket;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMAC() {
        return this.MAC;
    }

    @Override
    public InetAddress getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean sendMessage(MessageOutput message) {
        try {
            MessageDataOutput output = new MessageDataOutput(message, MergeType.DIFFERENCE);
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", false);
            byte[] compile = ((MessageOutput)output).compile();
            ByteBuffer buffer = ByteBuffer.wrap(compile);
            this.clientSocket.write(buffer);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

