/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url.HttpUtil;
import org.jetbrains.annotations.Nullable;

public final class URLUtils {
    @Deprecated
    public static void fastConnect(URL url) {
        try {
            HttpUtil response = new HttpUtil(url);
            response.push();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static boolean exists(String url) {
        return URLUtils.getResponseCode(url) == 200;
    }

    public static int getResponseCode(String url) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setInstanceFollowRedirects(false);
            con.setRequestMethod("HEAD");
            return con.getResponseCode();
        }
        catch (Throwable e) {
            return 503;
        }
    }

    @Nullable
    public static URL getOrNull(String target) {
        try {
            URL url = new URL(target);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.disconnect();
            connection.getResponseCode();
            return url;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Nullable
    public static URL getOrBackup(String def, String ... backup) {
        URL defURL = URLUtils.getOrNull(def);
        if (defURL == null) {
            int trie = 0;
            do {
                defURL = URLUtils.getOrNull(backup[trie]);
            } while (++trie < backup.length);
        }
        return defURL;
    }

    @Deprecated
    public static String getResponse(URL url) {
        try {
            HttpUtil response = new HttpUtil(url);
            return response.getResponse();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static String getDomainName(String url) {
        try {
            URI uri;
            String domain;
            String tmp = url;
            if (!url.startsWith("https://") && !url.startsWith("http://")) {
                tmp = "https://" + url;
            }
            return (domain = (uri = new URI(tmp)).getHost()).startsWith("www.") ? domain.substring(4) : domain;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Nullable
    public static HttpUtil extraUtils(URL url) {
        try {
            return new HttpUtil(url);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        KarmaAPI.install();
    }
}

