/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import ml.karmaconfigs.remote.messaging.karmaapi.common.Console;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.ConcurrentList;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.PathUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.listener.RemoteListener;
import ml.karmaconfigs.remote.messaging.listener.ServerEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientCommandEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientConnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientDisconnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientMessageEvent;
import ml.karmaconfigs.remote.messaging.platform.Server;
import ml.karmaconfigs.remote.messaging.remote.RemoteClient;
import ml.karmaconfigs.remote.messaging.util.DisconnectReason;
import ml.karmaconfigs.remote.messaging.util.WorkLevel;
import ml.karmaconfigs.remote.messaging.util.message.DataFixer;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataOutput;
import ml.karmaconfigs.remote.messaging.util.message.MessageInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.worker.tcp.remote.TCPRemoteClient;

public final class TCPServer
extends Server {
    private final List<MessageInput> queue = new ConcurrentList<MessageInput>();
    private final Map<String, RemoteClient> clients = new ConcurrentHashMap<String, RemoteClient>();
    private final Set<String> banned = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private String server = "127.0.0.1";
    private int sv_port = 49305;
    private boolean debug = false;
    private boolean operative = false;
    private ServerSocketChannel socket;
    private int processed = 0;
    private String key = "";
    private final Console console = new Console(this);

    public TCPServer() {
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Server (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Server (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Server (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Server (&4ERROR&3)]&b ");
    }

    public TCPServer(int port) {
        this.sv_port = port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Server (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Server (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Server (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Server (&4ERROR&3)]&b ");
    }

    public TCPServer(String host, int port) {
        this.server = host;
        this.sv_port = port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Server (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Server (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Server (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Server (&4ERROR&3)]&b ");
    }

    @Override
    public Server debug(boolean status) {
        this.debug = status;
        return this;
    }

    @Override
    public LateScheduler<Boolean> start() {
        if (!this.operative) {
            AsyncLateScheduler<Boolean> result = new AsyncLateScheduler<Boolean>();
            Thread thread = new Thread(() -> {
                try {
                    this.socket = ServerSocketChannel.open().bind(new InetSocketAddress(this.server, this.sv_port));
                    this.socket.configureBlocking(false);
                    result.complete(true);
                    this.operative = true;
                    while (this.operative) {
                        try {
                            SocketChannel channel = this.socket.accept();
                            if (channel == null) continue;
                            new Thread(() -> {
                                while (channel.isConnected()) {
                                    block29: {
                                        try {
                                            ByteBuffer writeBuffer;
                                            byte[] compile;
                                            MessageDataOutput output;
                                            ByteBuffer tmpBuffer = ByteBuffer.allocate(5120);
                                            channel.read(tmpBuffer);
                                            InetAddress incoming = ((InetSocketAddress)channel.getRemoteAddress()).getAddress();
                                            int port = ((InetSocketAddress)channel.getRemoteAddress()).getPort();
                                            String default_name = incoming.getHostAddress() + "/" + port;
                                            ByteBuffer BUFFER = DataFixer.fixBuffer(tmpBuffer);
                                            MessageInput input = new MessageDataInput(BUFFER.array());
                                            if (!this.queue.isEmpty()) {
                                                this.queue.add(input);
                                                input = this.queue.get(0);
                                            }
                                            String mac = input.getString("MAC");
                                            RemoteClient client = this.getClient(default_name, mac, incoming, port, channel);
                                            if (input.getBoolean("COMMAND_ENABLED")) {
                                                String command = input.getString("COMMAND");
                                                String argument = input.getString("ARGUMENT");
                                                if (command == null || argument == null) break block29;
                                                switch (command.toLowerCase()) {
                                                    case "connect": {
                                                        ByteBuffer writeBuffer2;
                                                        byte[] compile2;
                                                        MessageDataOutput output2;
                                                        ByteBuffer writeBuffer3;
                                                        byte[] compile3;
                                                        MessageDataOutput output3;
                                                        ServerEvent event;
                                                        boolean sendDecline = true;
                                                        boolean validKey = true;
                                                        if (!this.banned.contains(mac)) {
                                                            if (!StringUtils.isNullOrEmpty(this.key)) {
                                                                String provided = input.getString("ACCESS_KEY");
                                                                validKey = provided != null ? provided.equals(this.key) : false;
                                                            }
                                                            if (validKey) {
                                                                sendDecline = false;
                                                                if (this.debug) {
                                                                    this.console.send((CharSequence)"Client {0} connected as {1}", Level.OK, default_name, argument);
                                                                }
                                                                client = new TCPRemoteClient(argument, mac, incoming, port, channel);
                                                                this.clients.put(default_name, client);
                                                                this.connections.add(default_name);
                                                                event = new ClientConnectEvent(client, this);
                                                                RemoteListener.callServerEvent(event);
                                                                output3 = new MessageDataOutput();
                                                                ((MessageOutput)output3).write("MAC", this.getMAC());
                                                                ((MessageOutput)output3).write("COMMAND_ENABLED", true);
                                                                ((MessageOutput)output3).write("COMMAND", "accept");
                                                                compile3 = ((MessageOutput)output3).compile();
                                                                writeBuffer3 = ByteBuffer.wrap(compile3);
                                                                channel.write(writeBuffer3);
                                                            }
                                                        }
                                                        if (sendDecline) {
                                                            output2 = new MessageDataOutput();
                                                            ((MessageOutput)output2).write("MAC", this.getMAC());
                                                            ((MessageOutput)output2).write("COMMAND_ENABLED", true);
                                                            ((MessageOutput)output2).write("COMMAND", "decline");
                                                            ((MessageOutput)output2).write("ARGUMENT", "connect");
                                                            ((MessageOutput)output2).write("COMMAND_ARGUMENT", validKey ? "You are banned from this server!" : "The provided access key is not valid for this server!");
                                                            compile2 = ((MessageOutput)output2).compile();
                                                            writeBuffer2 = ByteBuffer.wrap(compile2);
                                                            channel.write(writeBuffer2);
                                                            break;
                                                        }
                                                        break block29;
                                                    }
                                                    case "rename": {
                                                        ByteBuffer writeBuffer3;
                                                        byte[] compile3;
                                                        MessageDataOutput output3;
                                                        ServerEvent event;
                                                        if (this.connections.contains(default_name)) {
                                                            if (this.debug) {
                                                                this.console.send((CharSequence)"Client {0} is now known as {1}", Level.WARNING, client.getName(), argument);
                                                            }
                                                            client = new TCPRemoteClient(argument, mac, incoming, port, channel);
                                                            this.clients.put(default_name, client);
                                                            event = new ClientCommandEvent(client, this, command, argument);
                                                            RemoteListener.callServerEvent(event);
                                                            output3 = new MessageDataOutput();
                                                            ((MessageOutput)output3).write("MAC", this.getMAC());
                                                            ((MessageOutput)output3).write("COMMAND_ENABLED", true);
                                                            ((MessageOutput)output3).write("COMMAND", "success");
                                                            ((MessageOutput)output3).write("ARGUMENT", "rename");
                                                            ((MessageOutput)output3).write("ARGUMENT_DATA", argument);
                                                            compile3 = ((MessageOutput)output3).compile();
                                                            writeBuffer3 = ByteBuffer.wrap(compile3);
                                                            channel.write(writeBuffer3);
                                                            break;
                                                        }
                                                        MessageDataOutput output2 = new MessageDataOutput();
                                                        ((MessageOutput)output2).write("MAC", this.getMAC());
                                                        ((MessageOutput)output2).write("COMMAND_ENABLED", true);
                                                        ((MessageOutput)output2).write("COMMAND", "failed");
                                                        ((MessageOutput)output2).write("ARGUMENT", "rename");
                                                        ((MessageOutput)output2).write("ARGUMENT_DATA", argument + ",You are not connected to this server!");
                                                        byte[] compile2 = ((MessageOutput)output2).compile();
                                                        ByteBuffer writeBuffer2 = ByteBuffer.wrap(compile2);
                                                        channel.write(writeBuffer2);
                                                        break;
                                                    }
                                                    case "disconnect": {
                                                        ServerEvent event;
                                                        if (this.connections.contains(default_name)) {
                                                            if (this.debug) {
                                                                this.console.send((CharSequence)"Client {0} left the server ( {1} )", Level.WARNING, client.getName(), argument);
                                                            }
                                                            this.clients.remove(default_name);
                                                            this.connections.remove(default_name);
                                                            event = new ClientDisconnectEvent(client, this, DisconnectReason.KILLED_BY_CLIENT, argument);
                                                            RemoteListener.callServerEvent(event);
                                                            break;
                                                        }
                                                        MessageDataOutput output2 = new MessageDataOutput();
                                                        ((MessageOutput)output2).write("MAC", this.getMAC());
                                                        ((MessageOutput)output2).write("COMMAND_ENABLED", true);
                                                        ((MessageOutput)output2).write("COMMAND", "failed");
                                                        ((MessageOutput)output2).write("ARGUMENT", "disconnect");
                                                        ((MessageOutput)output2).write("ARGUMENT_DATA", "You are not connected to this server!");
                                                        byte[] compile2 = ((MessageOutput)output2).compile();
                                                        ByteBuffer writeBuffer2 = ByteBuffer.wrap(compile2);
                                                        channel.write(writeBuffer2);
                                                        break;
                                                    }
                                                    default: {
                                                        ServerEvent event;
                                                        if (this.connections.contains(default_name)) {
                                                            if (this.debug) {
                                                                this.console.send((CharSequence)"Unknown command from {0}: {1} ( {2} )", Level.WARNING, client.getName(), command, argument);
                                                            }
                                                            event = new ClientCommandEvent(client, this, command, argument);
                                                            RemoteListener.callServerEvent(event);
                                                            break;
                                                        }
                                                        MessageDataOutput output2 = new MessageDataOutput();
                                                        ((MessageOutput)output2).write("MAC", this.getMAC());
                                                        ((MessageOutput)output2).write("COMMAND_ENABLED", true);
                                                        ((MessageOutput)output2).write("COMMAND", "failed");
                                                        ((MessageOutput)output2).write("ARGUMENT", "unknown");
                                                        ((MessageOutput)output2).write("ARGUMENT_DATA", command + "," + argument + ",You are not connected to this server!");
                                                        byte[] compile2 = ((MessageOutput)output2).compile();
                                                        ByteBuffer writeBuffer2 = ByteBuffer.wrap(compile2);
                                                        channel.write(writeBuffer2);
                                                    }
                                                }
                                                break block29;
                                            }
                                            if (this.connections.contains(default_name)) {
                                                output = new MessageDataOutput();
                                                ((MessageOutput)output).write("MAC", this.getMAC());
                                                ((MessageOutput)output).write("COMMAND_ENABLED", true);
                                                ((MessageOutput)output).write("COMMAND", "success");
                                                ((MessageOutput)output).write("ARGUMENT", "message");
                                                ((MessageOutput)output).write("ARGUMENT_DATA", client.getName());
                                                compile = ((MessageOutput)output).compile();
                                                writeBuffer = ByteBuffer.wrap(compile);
                                                channel.write(writeBuffer);
                                                ClientMessageEvent event = new ClientMessageEvent(client, this, input);
                                                RemoteListener.callServerEvent(event);
                                            } else {
                                                if (this.debug) {
                                                    this.console.send((CharSequence)"Denying message from {0} because he's not connected to server", Level.INFO, default_name);
                                                }
                                                output = new MessageDataOutput();
                                                ((MessageOutput)output).write("MAC", this.getMAC());
                                                ((MessageOutput)output).write("COMMAND_ENABLED", true);
                                                ((MessageOutput)output).write("COMMAND", "failed");
                                                ((MessageOutput)output).write("ARGUMENT", "message");
                                                ((MessageOutput)output).write("ARGUMENT_DATA", "You are not connected to this server!");
                                                compile = ((MessageOutput)output).compile();
                                                writeBuffer = ByteBuffer.wrap(compile);
                                                channel.write(writeBuffer);
                                            }
                                        }
                                        catch (Throwable ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                    ++this.processed;
                                }
                            }).start();
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
                catch (Throwable ex) {
                    result.complete(false);
                }
            });
            thread.start();
            return result;
        }
        return null;
    }

    @Override
    public LateScheduler<Boolean> start(String accessKey) {
        if (!this.operative) {
            this.key = accessKey;
            return this.start();
        }
        return null;
    }

    @Override
    public InetAddress getHost() {
        try {
            return InetAddress.getByName(this.server);
        }
        catch (Throwable throwable) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (Throwable ex) {
                return InetAddress.getLoopbackAddress();
            }
        }
    }

    @Override
    public String getMAC() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] macArray = network.getHardwareAddress();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < macArray.length; ++i) {
                str.append(String.format("%02X%s", macArray[i], i < macArray.length - 1 ? ":" : ""));
            }
            return str.toString();
        }
        catch (Throwable ex) {
            System.out.println("Failed to locate MAC address...");
            System.exit(1);
            return null;
        }
    }

    @Override
    public int getPort() {
        return this.sv_port;
    }

    @Override
    public boolean sendMessage(byte[] message) {
        return false;
    }

    @Override
    public Set<RemoteClient> getClients() {
        return new HashSet<RemoteClient>(this.clients.values());
    }

    @Override
    public WorkLevel getWorkLevel() {
        return WorkLevel.TCP;
    }

    @Override
    public void close() {
        this.operative = false;
        try {
            this.socket.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void exportBans(Path destination) {
        try {
            PathUtilities.create(destination);
            String serialized = StringUtils.serialize(new ArrayList<String>(this.banned));
            Files.write(destination, serialized.getBytes(), StandardOpenOption.CREATE);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void loadBans(Path bans) {
        try {
            PathUtilities.create(bans);
            byte[] result = Files.readAllBytes(bans);
            Object serialized = StringUtils.load(new String(result));
            if (serialized instanceof ArrayList) {
                ArrayList list = (ArrayList)serialized;
                for (Object obj : list) {
                    this.ban(String.valueOf(obj));
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void broadcast(MessageOutput data) {
        int max = this.queue.size();
        int expected = this.processed + max;
        new Thread(() -> {
            long wait = 0L;
            while (this.processed < expected) {
                ++wait;
            }
            if (this.debug) {
                long sec = TimeUnit.MILLISECONDS.toSeconds(wait);
                this.console.send((CharSequence)"Sent message to everyone after {0} {1}", Level.OK, sec > 0L ? sec : wait, sec > 0L ? "seconds" : "ms");
            }
            for (RemoteClient client : this.clients.values()) {
                client.sendMessage(data);
            }
        }).start();
    }

    @Override
    public void redirect(String name, MessageOutput data) {
        int max = this.queue.size();
        int expected = this.processed + max;
        new Thread(() -> {
            long wait = 0L;
            while (this.processed < expected) {
                ++wait;
            }
            if (this.debug) {
                long sec = TimeUnit.MILLISECONDS.toSeconds(wait);
                this.console.send((CharSequence)"Sent message to {0} after {1} {2}", Level.OK, name, sec > 0L ? sec : wait, sec > 0L ? "seconds" : "ms");
            }
            for (RemoteClient client : this.clients.values()) {
                if (!client.getName().equals(name) && !client.getMAC().equals(name)) continue;
                client.sendMessage(data);
            }
        }).start();
    }

    @Override
    public void ban(String ... macAddresses) {
        this.banned.addAll(Arrays.asList(macAddresses));
        for (RemoteClient client : this.clients.values()) {
            if (!this.banned.contains(client.getMAC())) continue;
            MessageDataOutput output = new MessageDataOutput();
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", true);
            ((MessageOutput)output).write("COMMAND", "DISCONNECT");
            ((MessageOutput)output).write("ARGUMENT", "");
            ((MessageOutput)output).write("ARGUMENT_DATA", "You have been banned from this server!");
            client.sendMessage(output);
        }
    }

    @Override
    public void kick(String ... macAddresses) {
        List<String> macs = Arrays.asList(macAddresses);
        for (RemoteClient client : this.clients.values()) {
            if (!macs.contains(client.getMAC())) continue;
            MessageDataOutput output = new MessageDataOutput();
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", true);
            ((MessageOutput)output).write("COMMAND", "DISCONNECT");
            ((MessageOutput)output).write("ARGUMENT", "");
            ((MessageOutput)output).write("ARGUMENT_DATA", "You have been kicked from this server!");
            client.sendMessage(output);
        }
    }

    @Override
    public void unBan(String ... macAddresses) {
        Arrays.asList(macAddresses).forEach(this.banned::remove);
    }

    private RemoteClient getClient(String name, String mac, InetAddress address, int port, SocketChannel socket) {
        RemoteClient client = this.clients.getOrDefault(address.getHostAddress() + "/" + port, null);
        if (client == null) {
            client = new TCPRemoteClient(name, mac, address, port, socket);
            this.clients.put(address.getHostAddress() + "/" + port, client);
        }
        return client;
    }

    @Override
    public String name() {
        return "TCP Server";
    }

    @Override
    public String version() {
        return "0";
    }

    @Override
    public String description() {
        return "TCP server to allow TCP Clients from RemoteMessaging API connect";
    }

    @Override
    public String[] authors() {
        return new String[]{"KarmaDev"};
    }

    @Override
    public String updateURL() {
        return null;
    }

    @Override
    public Console console() {
        return this.console;
    }
}

