/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.util;

import io.github.toolfactory.jvm.Info;
import io.github.toolfactory.jvm.function.template.Supplier;
import io.github.toolfactory.jvm.util.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class ObjectProvider {
    private final List<String> classNameItems = new CopyOnWriteArrayList<String>();
    private Map<String, List<String>> jVMVendorToClassSuffix = new LinkedHashMap<String, List<String>>();
    private static final String CLASS_NAME = ObjectProvider.class.getName();
    private int jVMVersion;
    private String vendor;

    public ObjectProvider(int ... versions) {
        this.jVMVendorToClassSuffix.put("Oracle Corporation", new ArrayList());
        this.jVMVendorToClassSuffix.put("International Business Machines Corporation", Arrays.asList("ForSemeru"));
        this.jVMVendorToClassSuffix.put("IBM Corporation", Arrays.asList("ForSemeru"));
        this.jVMVersion = Info.Provider.getInfoInstance().getVersion();
        this.vendor = System.getProperty("java.vendor");
        if (!this.jVMVendorToClassSuffix.containsKey(this.vendor)) {
            this.jVMVendorToClassSuffix.put(this.vendor, this.jVMVendorToClassSuffix.get("Oracle Corporation"));
        }
        TreeSet<Integer> registeredVersions = new TreeSet<Integer>();
        for (int version : versions) {
            if (this.jVMVersion < version) continue;
            registeredVersions.add(version);
        }
        for (Integer version : registeredVersions.descendingSet().toArray(new Integer[registeredVersions.size()])) {
            this.classNameItems.add("ForJava" + version);
        }
    }

    public <T> T getOrBuildObject(Class<? super T> clazz, Map<Object, Object> context) {
        BuildingException mainException = null;
        try {
            context.put("classNameOptionalItems", this.jVMVendorToClassSuffix.get(this.vendor));
            return this.getOrBuildObjectInternal(clazz, context);
        }
        catch (Throwable exc) {
            mainException = new BuildingException(Strings.compile("Exception occurred while retrieving the implementation of class {} (jvm architecture: {}, jvm version: {}, jvm vendor: {})", clazz.getName(), Info.Provider.getInfoInstance().is64Bit() ? "x64" : "x86", this.jVMVersion, this.vendor), exc);
            ExceptionHandler exceptionHandler = ObjectProvider.getExceptionHandler(context);
            if (exceptionHandler != null) {
                return exceptionHandler.handle(this, clazz, context, mainException);
            }
            throw mainException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putClassNameOptionalItem(List<String> classNameOptionalItems, String value) {
        if (!classNameOptionalItems.contains(value)) {
            List<String> list = classNameOptionalItems;
            synchronized (list) {
                if (!classNameOptionalItems.contains(value)) {
                    classNameOptionalItems.clear();
                    classNameOptionalItems.add(value);
                    return true;
                }
            }
        }
        return false;
    }

    private <T> T getOrBuildObjectInternal(Class<? super T> clazz, Map<Object, Object> context) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedHashSet<String> searchedClasses = new LinkedHashSet<String>();
        T object = this.getObjectInternal(clazz, context);
        if (object != null) {
            return object;
        }
        context.put(CLASS_NAME, this);
        List classNameOptionalItems = (List)context.get("classNameOptionalItems");
        List<String> classNameItems = Arrays.asList(new String[classNameOptionalItems.size() + 2]);
        classNameItems.set(0, clazz.getName());
        for (int i = 0; i < classNameOptionalItems.size(); ++i) {
            classNameItems.set(i + 2, (String)classNameOptionalItems.get(i));
        }
        classNameItems = new ArrayList<String>(classNameItems);
        while (classNameItems.size() > 1) {
            for (String classNameItem : this.classNameItems) {
                try {
                    classNameItems.set(1, classNameItem);
                    object = this.retrieveClass(classNameItems, searchedClasses, "$").getDeclaredConstructor(Map.class).newInstance(context);
                    context.put(clazz, object);
                    return object;
                }
                catch (ClassNotFoundException exc) {
                }
            }
            classNameItems.remove(classNameItems.size() - 1);
        }
        if (!Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface()) {
            try {
                return clazz.getDeclaredConstructor(Map.class).newInstance(context);
            }
            catch (Throwable exc) {
                throw new BuildingException("Unable to build the related object of " + clazz.getName(), exc);
            }
        }
        Class<T> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            try {
                return this.getOrBuildObject(superClass, context);
            }
            catch (BuildingException exc) {
                throw new BuildingException("Unable to build the related object of " + clazz.getName() + ": " + Strings.join(", ", searchedClasses) + " have been searched without success", exc);
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> interf : interfaces) {
                try {
                    return (T)this.getOrBuildObject(interf, context);
                }
                catch (BuildingException buildingException) {
                }
            }
        }
        throw new BuildingException("Unable to build the related object of " + clazz.getName() + ": " + Strings.join(", ", searchedClasses) + " have been searched without success");
    }

    private <T> Class<? super T> retrieveClass(List<String> classNameItems, Collection<String> notFoundClasses, String separator) throws ClassNotFoundException {
        Collection<String> allClassNameCombinations = this.retrieveAllClassNameCombinations(classNameItems, separator);
        for (String className : allClassNameCombinations) {
            try {
                Class<?> cls = Class.forName(className);
                if (Modifier.isAbstract(cls.getModifiers()) || cls.isInterface()) {
                    notFoundClasses.add(className);
                    continue;
                }
                return Class.forName(className);
            }
            catch (ClassNotFoundException exc) {
                notFoundClasses.add(className);
            }
        }
        throw new ClassNotFoundException();
    }

    Collection<String> retrieveAllClassNameCombinations(List<String> classNameItems, String separator) {
        ArrayList<String> finalStringColl = new ArrayList<String>();
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        ArrayList combinationsToBeReprocessed = new ArrayList();
        for (int i = classNameItems.size(); i > 0; --i) {
            List<String> list = classNameItems.subList(0, i);
            String firstPart = Strings.join("", list);
            if (!list.isEmpty()) {
                finalStringColl.add(firstPart);
            }
            List<String> secondPartList = classNameItems.subList(i, classNameItems.size());
            String secondPart = Strings.join("", secondPartList);
            if (!secondPartList.isEmpty()) {
                finalStringColl.add(secondPart);
            }
            classNames.add(Strings.join(separator, finalStringColl));
            if (secondPartList.size() > 1) {
                ArrayList<String> toBeReprocessed = new ArrayList<String>();
                String firstPartOfSecondPart = secondPartList.get(0);
                toBeReprocessed.add(firstPart + separator + firstPartOfSecondPart);
                toBeReprocessed.addAll(secondPartList.subList(1, secondPartList.size()));
                combinationsToBeReprocessed.add(toBeReprocessed);
            }
            finalStringColl.clear();
        }
        for (List list : combinationsToBeReprocessed) {
            classNames.addAll(this.retrieveAllClassNameCombinations(list, separator));
        }
        return classNames;
    }

    private <F> F getObjectInternal(Class<? super F> clazz, Map<Object, Object> context) {
        Object objectFound = context.get(clazz);
        if (objectFound != null) {
            if (objectFound instanceof InitializationMarkViaExceptionHandler) {
                context.remove(clazz);
                throw (InitializationMarkViaExceptionHandler)objectFound;
            }
            return (F)objectFound;
        }
        for (Map.Entry<Object, Object> entry : context.entrySet()) {
            if (clazz.isAssignableFrom(entry.getValue().getClass())) {
                return (F)entry.getValue();
            }
            if (!(entry.getKey() instanceof Class) || !clazz.isAssignableFrom((Class)entry.getKey()) || !(entry.getValue() instanceof InitializationMarkViaExceptionHandler)) continue;
            context.remove(clazz);
            throw (InitializationMarkViaExceptionHandler)entry.getValue();
        }
        return null;
    }

    public static <F> F getObject(Class<? super F> clazz, Map<Object, Object> context) {
        Object objectFound = context.get(clazz);
        if (objectFound != null) {
            if (objectFound instanceof InitializationMarkViaExceptionHandler) {
                return null;
            }
            return (F)objectFound;
        }
        for (Map.Entry<Object, Object> entry : context.entrySet()) {
            if (clazz.isAssignableFrom(entry.getValue().getClass())) {
                return (F)entry.getValue();
            }
            if (!(entry.getKey() instanceof Class) || !clazz.isAssignableFrom((Class)entry.getKey()) || !(entry.getValue() instanceof InitializationMarkViaExceptionHandler)) continue;
            return null;
        }
        return null;
    }

    public static ObjectProvider get(Map<Object, Object> context) {
        return (ObjectProvider)context.get(CLASS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putIfAbsent(Map<Object, Object> context, Supplier<ObjectProvider> objectProvider) {
        ObjectProvider objectProviderInMap = (ObjectProvider)context.get(CLASS_NAME);
        if (objectProviderInMap == null) {
            Map<Object, Object> map = context;
            synchronized (map) {
                objectProviderInMap = (ObjectProvider)context.get(CLASS_NAME);
                if (objectProviderInMap == null) {
                    context.put(CLASS_NAME, objectProvider.get());
                }
            }
        }
    }

    public <T> boolean markToBeInitializedViaExceptionHandler(Class<? super T> clazz, Map<Object, Object> context) {
        return this.markToBeInitializedViaExceptionHandler(clazz, context, InitializationMarkViaExceptionHandler.INSTANCE);
    }

    public <T> boolean markToBeInitializedViaExceptionHandler(Class<? super T> clazz, Map<Object, Object> context, InitializationMarkViaExceptionHandler exception) {
        try {
            if (this.getObjectInternal(clazz, context) != null) {
                return false;
            }
            context.put(clazz, exception);
            return true;
        }
        catch (InitializationMarkViaExceptionHandler exc) {
            return true;
        }
    }

    public boolean isMarkedToBeInitializedViaExceptionHandler(BuildingException exception) {
        return exception.getCause() instanceof InitializationMarkViaExceptionHandler;
    }

    public static void setExceptionHandler(Map<Object, Object> context, ExceptionHandler exceptionHandler) {
        context.put("exceptionHandler", exceptionHandler);
    }

    public static ExceptionHandler getExceptionHandler(Map<Object, Object> context) {
        return (ExceptionHandler)context.get("exceptionHandler");
    }

    public static class BuildingException
    extends RuntimeException {
        private static final long serialVersionUID = -7606794206649872816L;

        public BuildingException(String message, Throwable cause) {
            super(message, cause);
        }

        public BuildingException(String message) {
            super(message);
        }
    }

    public static interface ExceptionHandler {
        public <T> T handle(ObjectProvider var1, Class<? super T> var2, Map<Object, Object> var3, BuildingException var4);
    }

    public static class InitializationMarkViaExceptionHandler
    extends BuildingException {
        private static final long serialVersionUID = -6243247518915161086L;
        public static final InitializationMarkViaExceptionHandler INSTANCE = new InitializationMarkViaExceptionHandler();

        public InitializationMarkViaExceptionHandler() {
            super((String)null);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

