/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.CancellableScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;

public final class AsyncLateScheduler<A>
implements LateScheduler<A> {
    private Runnable whenCompleteRunner;
    private Runnable onCancel;
    private Consumer<A> whenComplete;
    private BiConsumer<A, Throwable> whenCompleteWithError;
    private boolean cancelled = false;
    private boolean completed = false;
    private A typeA = null;
    private Throwable typeE = null;

    @Override
    public LateScheduler<A> whenComplete(Runnable action) {
        this.whenCompleteRunner = action;
        if (this.completed) {
            this.whenCompleteRunner.run();
        }
        return this;
    }

    @Override
    public LateScheduler<A> whenComplete(Consumer<A> action) {
        this.whenComplete = action;
        if (this.completed) {
            this.whenComplete.accept(this.typeA);
        }
        return this;
    }

    @Override
    public LateScheduler<A> whenComplete(BiConsumer<A, Throwable> caughtAction) {
        this.whenCompleteWithError = caughtAction;
        if (this.completed) {
            this.whenCompleteWithError.accept(this.typeA, this.typeE);
        }
        return this;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public A get() {
        return this.typeA;
    }

    @Override
    public void complete(A target) {
        if (this.cancelled || this.completed) {
            return;
        }
        try {
            new Thread(() -> {
                if (this.whenComplete != null) {
                    this.whenComplete.accept(target);
                }
                if (this.whenCompleteWithError != null) {
                    this.whenCompleteWithError.accept(target, null);
                }
                if (this.whenCompleteRunner != null) {
                    this.whenCompleteRunner.run();
                }
                this.typeA = target;
            }).start();
            this.completed = true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void complete(A target, Throwable error) {
        if (this.cancelled || this.completed) {
            return;
        }
        try {
            new Thread(() -> {
                if (this.whenCompleteWithError != null) {
                    this.whenCompleteWithError.accept(target, error);
                }
                if (this.whenComplete != null) {
                    this.whenComplete.accept(target);
                }
                if (this.whenCompleteRunner != null) {
                    this.whenCompleteRunner.run();
                }
                this.typeA = target;
                this.typeE = error;
            }).start();
            this.completed = true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public CancellableScheduler whenCancelled(Runnable action) {
        this.onCancel = action;
        return this;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled() {
        this.cancelled = true;
        if (this.onCancel != null) {
            this.onCancel.run();
        }
    }
}

